/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;
import java.util.TreeSet;

public class Numeric {
    private static String s = "#,###,###,###";
    private static DecimalFormatSymbols dfs = Numeric.GetDecimalFormatSymbols();
    public static DecimalFormat[] df = new DecimalFormat[]{new DecimalFormat(s, dfs), new DecimalFormat(s + ".#", dfs), new DecimalFormat(s + ".##", dfs), new DecimalFormat(s + ".###", dfs), new DecimalFormat(s + ".####", dfs), new DecimalFormat(s + ".#####", dfs), new DecimalFormat(s + ".######", dfs), new DecimalFormat(s + ".#######", dfs)};
    private static String s1 = "#,###,###,##0";
    public static DecimalFormat[] fixed = new DecimalFormat[]{new DecimalFormat(s1, dfs), new DecimalFormat(s1 + ".0", dfs), new DecimalFormat(s1 + ".00", dfs), new DecimalFormat(s1 + ".000", dfs), new DecimalFormat(s1 + ".0000", dfs), new DecimalFormat(s1 + ".00000", dfs), new DecimalFormat(s1 + ".000000", dfs), new DecimalFormat(s1 + ".0000000", dfs)};
    public static DecimalFormat[] percs = new DecimalFormat[]{new DecimalFormat(s1 + " %", dfs), new DecimalFormat(s1 + ".0 %", dfs), new DecimalFormat(s1 + ".00 %", dfs), new DecimalFormat(s1 + ".000 %", dfs), new DecimalFormat(s1 + ".0000 %", dfs), new DecimalFormat(s1 + ".00000 %", dfs), new DecimalFormat(s1 + ".000000 %", dfs), new DecimalFormat(s1 + ".0000000 %", dfs)};

    public static double[][] Dif(double[][] dArray, double[][] dArray2) {
        int n;
        int n2 = dArray[0].length;
        int n3 = dArray.length;
        assert (dArray2[0].length == n2) : "This and That must have " + n2 + " columns";
        assert (dArray2.length == n3) : "This and That must have " + n3 + " columns";
        double[][] dArrayArray = new double[n3][];
        for (n = 0; n < n3; ++n) {
            dArrayArray[n] = new double[n2];
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                dArrayArray[i][n] = Double.isNaN(dArray[i][n]) || Double.isNaN(dArray2[i][n]) ? Double.NaN : (dArray[i][n] > dArray2[i][n] ? dArray[i][n] - dArray2[i][n] : dArray2[i][n] - dArray[i][n]);
            }
        }
        return dArrayArray;
    }

    public static void print(int[][] nArray) {
        System.out.println();
        int n = nArray[0].length;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                System.out.print(nArray[i][j]);
                System.out.print(' ');
            }
            System.out.println();
        }
    }

    public static void print(double[][] dArray) {
        System.out.println();
        int n = dArray[0].length;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                System.out.print(dArray[i][j]);
                System.out.print(' ');
            }
            System.out.println();
        }
    }

    public static int[][] Rank(double[][] dArray, boolean[] blArray) {
        int n;
        int n2 = blArray.length;
        int n3 = dArray.length;
        assert (dArray[0].length == n2) : "scores must have " + n2 + " columns";
        int[][] nArrayArray = new int[n3][];
        for (n = 0; n < n3; ++n) {
            nArrayArray[n] = new int[n2];
        }
        for (n = 0; n < n2; ++n) {
            TreeSet<Double> treeSet = new TreeSet<Double>();
            for (int i = 0; i < n3; ++i) {
                treeSet.add(dArray[i][n]);
            }
            ArrayList arrayList = blArray[n] ? new ArrayList(treeSet.descendingSet()) : new ArrayList(treeSet);
            for (int i = 0; i < n3; ++i) {
                nArrayArray[i][n] = arrayList.indexOf(dArray[i][n]) + 1;
            }
        }
        return nArrayArray;
    }

    static DecimalFormatSymbols GetDecimalFormatSymbols() {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.getDefault());
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormatSymbols.setGroupingSeparator(',');
        return decimalFormatSymbols;
    }

    public static Object encodeRounded(double d, int n) {
        if (Double.isNaN(d)) {
            return "nan";
        }
        return df[n].format(d);
    }

    public static int sum(int[] nArray) {
        int n = nArray == null ? 0 : nArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += nArray[i];
        }
        return n2;
    }

    public static Object encodeSpaces(double d, int n) {
        String string = (String)Numeric.display(999111.111, n);
        String string2 = (String)Numeric.display(d, n);
        int n2 = string.length();
        int n3 = string2.length();
        int n4 = string.indexOf(46);
        if (string.charAt(n2 - 1) == 'k' && string2.charAt(n3 - 1) != 'k') {
            String string3 = (String)Numeric.display(111.111, n);
            int n5 = n4 < 0 ? n2 - n3 + 2 + (string3.length() - n3) : n4 + 1 + (2 - n3);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n5; ++i) {
                stringBuilder.append(' ');
            }
            string2 = stringBuilder.toString() + string2;
        } else if (n2 > n3) {
            int n6;
            int n7 = 0;
            int n8 = 0;
            if (n4 >= 0) {
                n7 = n2 - n4;
                n6 = string2.indexOf(46);
                if (n6 >= 0) {
                    n8 = n3 - n6;
                }
            }
            n6 = n7 - n8;
            int n9 = n2 - n3 - n6;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n9; ++i) {
                stringBuilder.append(' ');
            }
            string2 = stringBuilder.toString() + string2;
        }
        return string2;
    }

    public static Object display(double d, int n) {
        Object object;
        if (n == 3) {
            object = Numeric.encodeK(d);
        } else if (d < 1000.0 && n < 0) {
            int n2 = 0 - n;
            object = "" + Numeric.encodeRounded(d, n2);
        } else if (n < 0) {
            int n3 = 0 - n;
            object = "" + Numeric.encodeRounded(d, n3);
        } else if (n == 0) {
            object = "" + Numeric.encodeRounded(d, 0);
        } else if (n < 3) {
            object = Math.abs(d) < 1000.0 ? "" + Numeric.encodeRounded(d, 0) : "" + Numeric.encodeRounded(d / 1000.0, 3 - n) + 'k';
        } else {
            double d2 = Math.pow(10.0, n);
            object = "" + Numeric.encodeRounded(d / d2, n - 2) + 'k';
        }
        return object;
    }

    public static Object encodeMb(double d) {
        boolean bl;
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            d = 0.0 - d;
        }
        String string = null;
        string = d < 1048576.0 ? (String)Numeric.encodeRounded(d, 0) : "" + Numeric.encodeRounded(d / 1048576.0, 2) + " MB";
        if (bl) {
            string = "-" + string;
        }
        return string;
    }

    public static Object encodeK(double d) {
        boolean bl;
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            d = 0.0 - d;
        }
        String string = null;
        string = d < 1024.0 ? (String)Numeric.encodeRounded(d, 0) : "" + Numeric.encodeRounded(d / 1024.0, 0) + 'k';
        if (bl) {
            string = "-" + string;
        }
        return string;
    }

    public static Object encode(String string, int n) {
        try {
            return df[n].format(Double.valueOf(string));
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return string;
        }
    }

    public static Object encodeEmd(String string) {
        return Numeric.encode(string, 3);
    }

    public static Object encodePercent(double d, double d2) {
        double d3 = d / d2 * 100.0;
        if (d3 == 0.0) {
            return "0%";
        }
        if (d3 < 1.0) {
            if (d3 < 0.01) {
                if (d3 < 0.001) {
                    return "<.001%";
                }
                return (String)Numeric.encodeRounded(d3, 3) + '%';
            }
            return (String)Numeric.encodeRounded(d3, 2) + '%';
        }
        if (d3 < 10.0) {
            return (String)Numeric.encodeRounded(d3, 1) + '%';
        }
        if (d3 > 99.0 && d3 < 100.0) {
            return (String)Numeric.encodeRounded(d3, 2) + '%';
        }
        return (String)Numeric.encodeRounded(d3, 0) + '%';
    }

    public static Object[][] encodeForUitable(double[][] dArray, int[] nArray, int[] nArray2, int n) {
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        Object[][] objectArray = new Object[n2][];
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = new Object[n3];
            for (int j = 0; j < n3; ++j) {
                int n4 = nArray[j];
                double d = dArray[i][j];
                if (Double.isNaN(d)) {
                    objectArray[i][j] = "<html>  N/A</html>";
                    continue;
                }
                Object object = n4 >= 0 ? Numeric.ConvertDecimalHtml(d, n4) : (n4 < -6 ? Numeric.encodeMb(d) : (n4 < -3 ? Numeric.encodeK(d) : df[0 - n4].format(d / 1.0 * 100.0) + '%'));
                String string = df[df.length - 1].format(1.0E12 + 1000.0 * d);
                string = d < 0.0 ? 'N' + string.substring(1) : 'P' + string.substring(1);
                objectArray[i][j] = "<html><table width='" + Integer.toString(nArray2[j] * n) + "px'><tr><td align='right'><" + string + '>' + object + "</td></tr></table>";
            }
        }
        return objectArray;
    }

    public static String ConvertDecimal(double d, int n) {
        String string;
        if (n >= df.length) {
            n = df.length - 1;
        }
        if ("0".equals((string = df[n].format(d)).trim()) && d != 0.0) {
            if (n == 0) {
                return "<0";
            }
            Double d2 = 1.0 / Math.pow(10.0, n);
            return "<" + d2.toString();
        }
        return string;
    }

    public static String ConvertDecimalHtml(double d, int n) {
        String string;
        if (n >= df.length) {
            n = df.length - 1;
        }
        if ("0".equals((string = df[n].format(d)).trim()) && d != 0.0) {
            if (n == 0) {
                return "&lt;0";
            }
            Double d2 = 1.0 / Math.pow(10.0, n);
            return "&lt;" + d2.toString();
        }
        return string;
    }

    public static void main(String[] stringArray) {
        String string = Numeric.ConvertDecimal(2.6, 0);
        string = Numeric.ConvertDecimal(0.6, 0);
        string = Numeric.ConvertDecimal(3.006, 2);
        string = Numeric.ConvertDecimal(0.0, 2);
        string = Numeric.ConvertDecimal(0.006, 2);
        string = Numeric.ConvertDecimal(0.0012, 2);
        string = Numeric.ConvertDecimal(0.4, 0);
        string = Numeric.ConvertDecimal(0.049, 1);
    }
}

