/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

import edu.stanford.facs.swing.Basics;
import edu.stanford.facs.swing.CpuInfo;
import edu.stanford.facs.swing.ImageButton;
import edu.stanford.facs.swing.MarkerSorter;
import edu.stanford.facs.swing.Mover;
import edu.stanford.facs.swing.SwingUtil;
import edu.stanford.facs.swing.ToolTipOnDemand;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Orderer<T> {
    private Window owner;
    final JCheckBox cbAutoUpdate = new JCheckBox("Update table now");
    private boolean showUpdate = true;
    private boolean emptyNotAllowed = false;
    public JDialog dlg;
    public JList<T> leftList;
    public JList<T> rightList;
    public JScrollPane leftListScrollPane;
    public JScrollPane rightListScrollPane;
    private final AbstractButton updateButton;
    private DefaultListModel<T> leftModel;
    private DefaultListModel<T> rightModel = new DefaultListModel();
    public JLabel rightListHeader = new JLabel("<html><b>Available columns</html>");
    public int visibleRows = 0;
    public String itemName = "keyword";
    public String itemNamePlural = "keyword(s)";
    public boolean resetRequired = true;
    private String rightListTip;
    private String leftListTip;
    private JButton leftButton;
    private JButton rightButton;
    private boolean isLeftRightOk = true;
    private JComponent lastDrag;
    private boolean dropOk = true;
    public JPanel btns;
    ActionListener doneListener = null;
    boolean sortingAlphaCD = false;
    MarkerSorter ms;
    public String title = "Select and order";
    public String guide = "Pick the order of items you want";

    public Orderer(AbstractButton abstractButton, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(abstractButton, bl, bl2, bl3);
        this.emptyNotAllowed = bl4;
    }

    public Orderer(AbstractButton abstractButton, boolean bl, boolean bl2, boolean bl3) {
        this(abstractButton, bl, bl2);
        if (bl3) {
            this.cbAutoUpdate.setText("Update tree now");
        }
    }

    public Orderer(AbstractButton abstractButton, boolean bl, boolean bl2) {
        this(abstractButton, bl);
        this.showUpdate = bl2;
    }

    public Orderer(final AbstractButton abstractButton, boolean bl) {
        this.updateButton = abstractButton;
        this.cbAutoUpdate.setSelected(bl);
        if (abstractButton != null) {
            abstractButton.setEnabled(false);
            abstractButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    abstractButton.setEnabled(false);
                }
            });
            abstractButton.setEnabled(false);
            this.cbAutoUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Orderer.this.cbAutoUpdate.isSelected() && Orderer.this.updateButton.isEnabled()) {
                        abstractButton.doClick();
                    }
                }
            });
        }
    }

    public void setButtonEnabled(boolean bl) {
        if (this.updateButton != null) {
            this.updateButton.setEnabled(bl);
        }
    }

    private void enableUpdates() {
        if (this.updateButton != null) {
            this.updateButton.setEnabled(true);
            if (this.cbAutoUpdate.isSelected()) {
                this.updateButton.doClick();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Orderer.this.updateButton.setEnabled(false);
                    }
                });
            }
            ToolTipOnDemand.getSingleton().showLater(this.updateButton);
        }
    }

    public JLabel setCountListeningLabel(final JLabel jLabel, final String string, final String string2, final String string3) {
        this.leftModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                System.out.println("intervalRemoved");
                Orderer.this.reflectCount(jLabel, string, string2, string3);
            }

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                System.out.println("intervalAdded");
                Orderer.this.reflectCount(jLabel, string, string2, string3);
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                System.out.println("intervalRemoved");
                Orderer.this.reflectCount(jLabel, string, string2, string3);
            }
        });
        return jLabel;
    }

    public void reflectCount(JLabel jLabel, String string, String string2, String string3) {
        int n = this.leftList.getModel().getSize();
        int n2 = n + this.rightList.getModel().getSize();
        jLabel.setText("<html>" + string + string2 + n + "/" + n2 + string3 + "</html>");
    }

    public void resetRight(Collection<T> collection) {
        LinkedHashSet<T> linkedHashSet = new LinkedHashSet<T>(collection);
        this.rightModel.removeAllElements();
        for (Object e : linkedHashSet) {
            if (this.leftModel.contains(e)) continue;
            this.rightModel.addElement(e);
        }
    }

    public void resetLeft(Collection<T> collection) {
        LinkedHashSet<T> linkedHashSet = new LinkedHashSet<T>(collection);
        this.leftModel.removeAllElements();
        for (Object e : linkedHashSet) {
            if (this.rightModel.contains(e)) continue;
            this.leftModel.addElement(e);
        }
    }

    public void setRightListHeader(String string) {
        this.rightListHeader.setHorizontalAlignment(0);
        this.rightListHeader.setText(string);
    }

    public void resetLists(Collection<T> collection, Collection<T> collection2) {
        this.leftModel.removeAllElements();
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.leftModel.addElement(iterator.next());
        }
        this.rightModel.removeAllElements();
        iterator = collection2.iterator();
        while (iterator.hasNext()) {
            this.rightModel.addElement(iterator.next());
        }
    }

    public JPanel setLists(Window window, Collection<T> collection, Collection<T> collection2, JComponent jComponent, JComponent jComponent2, JComponent jComponent3, ListCellRenderer<T> listCellRenderer, ListCellRenderer<T> listCellRenderer2, DoubleClickResponder doubleClickResponder) {
        this.dlg = new JDialog(window);
        this.owner = window;
        this.dlg.setModal(true);
        JPanel jPanel = this.getMainPanel(this.dlg, collection, collection2, jComponent, jComponent2, jComponent3, listCellRenderer, listCellRenderer2, doubleClickResponder);
        this.dlg.setContentPane(jPanel);
        this.dlg.setTitle(this.title);
        this.dlg.pack();
        return jPanel;
    }

    public JPanel getMainPanel(Collection<T> collection, String string, Collection<T> collection2, String string2) {
        JLabel jLabel = new JLabel(string);
        JLabel jLabel2 = new JLabel(string2);
        jLabel2.setHorizontalAlignment(0);
        jLabel.setHorizontalAlignment(0);
        return this.getMainPanel(null, collection, collection2, null, jLabel, jLabel2, null, null, null);
    }

    private void sort(DefaultListModel defaultListModel) {
        Object[] objectArray = defaultListModel.toArray();
        List<Object> list = Arrays.asList(objectArray);
        if (this.ms == null) {
            Collections.sort(list, new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    if (string.startsWith("$")) {
                        string = string.substring(1);
                    }
                    if (string2.startsWith("$")) {
                        string2 = string2.substring(1);
                    }
                    return string.compareTo(string2);
                }
            });
        } else {
            list = this.ms.sort(list);
        }
        defaultListModel.clear();
        for (Object object : list) {
            defaultListModel.addElement(object);
        }
    }

    public boolean setIsLeftRightOk(boolean bl) {
        boolean bl2 = bl;
        this.isLeftRightOk = bl;
        if (this.leftButton != null) {
            this.leftButton.setVisible(this.isLeftRightOk);
        }
        if (this.rightButton != null) {
            this.rightButton.setVisible(this.isLeftRightOk);
        }
        if (this.leftList != null) {
            if (bl) {
                this.leftList.setToolTipText("<html>To <b><i>stop using</i></b> a " + this.itemName + " <u>drag</u> it right to the " + this.rightListTip + " list or click right button.<br>To <b><i>reorder</i></b> a " + this.itemName + " drag up/down or click up/down buttons.</html>");
            } else {
                this.leftList.setToolTipText("<html>To <b><i>reorder</i></b> a " + this.itemName + " drag up/down or click up/down buttons.</html>");
            }
        }
        if (this.rightList != null) {
            if (bl) {
                this.rightList.setToolTipText("<html>To <b><i>use</i></b> a " + this.itemName + " <u>drag</u> it left to the " + this.leftListTip + " list.</html>");
            } else {
                this.rightList.setToolTipText("<html>To <b><i>reorder</i></b> a " + this.itemName + " drag up/down or click up/down buttons.</html>");
            }
        }
        return bl2;
    }

    public JPanel getMainPanel(final Window window, Collection<T> collection, Collection<T> collection2, JComponent jComponent, JComponent jComponent2, JComponent jComponent3, ListCellRenderer<T> listCellRenderer, ListCellRenderer<T> listCellRenderer2, final DoubleClickResponder doubleClickResponder) {
        JComponent jComponent4;
        JPanel jPanel;
        int n;
        JPanel jPanel2 = new JPanel();
        final LinkedHashSet<T> linkedHashSet = new LinkedHashSet<T>(collection);
        final LinkedHashSet<T> linkedHashSet2 = new LinkedHashSet<T>(collection2);
        if (this.visibleRows == 0) {
            int n2;
            int n3 = linkedHashSet.size();
            int n4 = n3 + (n2 = linkedHashSet2.size());
            if (n4 < 5) {
                n4 = 5;
            } else if (n4 > 15) {
                n4 = 15;
            }
            n = n4;
        } else {
            n = this.visibleRows;
        }
        this.leftModel = new DefaultListModel();
        final JDialog jDialog = this.dlg;
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (jDialog != null) {
                    jDialog.getRootPane().setDefaultButton(null);
                }
            }
        };
        this.leftList = new JList<T>(this.leftModel){
            private static final long serialVersionUID = 1L;

            @Override
            public void setListData(T[] TArray) {
                DefaultListModel defaultListModel = new DefaultListModel();
                for (int i = 0; i < TArray.length; ++i) {
                    defaultListModel.addElement(TArray[i]);
                }
                this.setModel(defaultListModel);
            }
        };
        if (listCellRenderer != null) {
            this.leftList.setCellRenderer(listCellRenderer);
        }
        this.leftList.setBorder(BorderFactory.createEmptyBorder(10, 5, 8, 5));
        this.leftList.addFocusListener(focusListener);
        class ListItems {
            private Set<T> set = new TreeSet();

            ListItems() {
            }

            public Object stringToObject(String string) {
                for (Object t : this.set) {
                    if (!t.toString().equals(string)) continue;
                    return t;
                }
                return null;
            }

            public void addAll(Collection<T> collection) {
                this.set.addAll(collection);
            }
        }
        final ListItems listItems = new ListItems();
        listItems.addAll(linkedHashSet);
        listItems.addAll(linkedHashSet2);
        this.rightModel = new DefaultListModel();
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            this.leftModel.addElement(iterator.next());
        }
        iterator = linkedHashSet2.iterator();
        while (iterator.hasNext()) {
            this.rightModel.addElement(iterator.next());
        }
        this.rightList = new JList<T>(this.rightModel){
            private static final long serialVersionUID = 1L;

            @Override
            public void setListData(T[] TArray) {
                DefaultListModel defaultListModel = new DefaultListModel();
                for (int i = 0; i < TArray.length; ++i) {
                    defaultListModel.addElement(TArray[i]);
                }
                this.setModel(defaultListModel);
            }
        };
        this.rightList.addFocusListener(focusListener);
        if (listCellRenderer2 != null) {
            this.rightList.setCellRenderer(listCellRenderer2);
        }
        this.rightList.setBorder(BorderFactory.createEmptyBorder(10, 5, 8, 5));
        this.rightList.setVisibleRowCount(n);
        this.rightList.setSelectionMode(2);
        this.rightList.setDragEnabled(true);
        JPanel jPanel3 = null;
        final DragSource dragSource = new DragSource();
        class ListTransferHandler
        extends StringTransferHandler {
            private static final long serialVersionUID = 1L;
            private int[] indices = null;
            private int addIndex = -1;
            private int addCount = 0;

            public ListTransferHandler() {
            }

            @Override
            protected String exportString(JComponent jComponent) {
                JList jList = (JList)jComponent;
                this.indices = jList.getSelectedIndices();
                Object[] objectArray = jList.getSelectedValues();
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    stringBuilder.append(object == null ? "" : object.toString());
                    if (i == objectArray.length - 1) continue;
                    stringBuilder.append("\n");
                }
                return stringBuilder.toString();
            }

            @Override
            protected void importString(JComponent jComponent, String string) {
                int n;
                if (!(jComponent instanceof JList) || string.trim().length() == 0) {
                    return;
                }
                boolean bl = jComponent.equals(Orderer.this.lastDrag);
                Orderer.this.dropOk = bl || Orderer.this.isLeftRightOk;
                System.out.println("importString() drag & drop are same = " + bl + ", drop OK=" + Orderer.this.dropOk);
                if (!Orderer.this.dropOk) {
                    return;
                }
                JList jList = (JList)jComponent;
                DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
                this.addIndex = n = jList.getSelectedIndex() == -1 ? 0 : jList.getSelectedIndex();
                String[] stringArray = string.split("\n");
                this.addCount = stringArray.length;
                for (int i = 0; i < stringArray.length; ++i) {
                    Object object = listItems.stringToObject(stringArray[i]);
                    if (Orderer.this.rightList.equals(jList)) {
                        ((DefaultListModel)Orderer.this.leftList.getModel()).removeElement(object);
                    }
                    if (Orderer.this.leftList.equals(jList)) {
                        ((DefaultListModel)Orderer.this.rightList.getModel()).removeElement(object);
                    }
                    defaultListModel.removeElement(object);
                    try {
                        defaultListModel.add(n++, object);
                        continue;
                    }
                    catch (Exception exception) {
                        defaultListModel.add(defaultListModel.getSize() - 1, object);
                    }
                }
                Orderer.this.enableUpdates();
            }

            @Override
            protected void cleanup(JComponent jComponent, boolean bl) {
                boolean bl2 = jComponent.equals(Orderer.this.lastDrag);
                System.out.println("cleanup() drag & drop are same = " + bl2 + ", drop OK=" + Orderer.this.dropOk);
                if (!Orderer.this.dropOk) {
                    return;
                }
                if (bl && this.indices != null && this.addCount > 0) {
                    for (int i = 0; i < this.indices.length; ++i) {
                        if (this.indices[i] <= this.addIndex) continue;
                        int n = i;
                        this.indices[n] = this.indices[n] + this.addCount;
                    }
                }
                this.indices = null;
                this.addCount = 0;
                this.addIndex = -1;
            }
        }
        this.leftList.setTransferHandler(new ListTransferHandler());
        class ListDragGesture
        implements DragGestureListener,
        DragSourceListener {
            JComponent m_cmp = null;

            public ListDragGesture(JComponent jComponent) {
                this.m_cmp = jComponent;
                dragSource.createDefaultDragGestureRecognizer(jComponent, 1, this);
            }

            @Override
            public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            }

            @Override
            public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            }

            @Override
            public void dragExit(DragSourceEvent dragSourceEvent) {
            }

            @Override
            public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            }

            @Override
            public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
            }

            @Override
            public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
                try {
                    dragSource.startDrag(dragGestureEvent, DragSource.DefaultMoveDrop, ((StringTransferHandler)((JList)this.m_cmp).getTransferHandler()).createTransferable(this.m_cmp), this);
                    Orderer.this.lastDrag = this.m_cmp;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        dragSource.createDefaultDragGestureRecognizer(this.leftList, 2, new ListDragGesture(this.leftList));
        this.rightList.setTransferHandler(new ListTransferHandler());
        dragSource.createDefaultDragGestureRecognizer(this.rightList, 2, new ListDragGesture(this.rightList));
        this.leftListTip = "<b>" + (jComponent2 instanceof JLabel ? ((JLabel)jComponent2).getText() : " left list ") + "</b>";
        this.rightListTip = "<b>" + (jComponent3 instanceof JLabel ? ((JLabel)jComponent3).getText() : " right list ") + "</b>";
        JPanel jPanel4 = new JPanel(new BorderLayout());
        final ImageButton imageButton = new ImageButton(SwingUtil.getImageGifIcon("moveTop"));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Mover.move(Orderer.this.rightList, Mover.Direction.TOP);
                Orderer.this.rightList.requestFocus();
                Orderer.this.enableUpdates();
            }
        };
        SwingUtil.echoAction(this.rightList, imageButton, actionListener, KeyStroke.getKeyStroke(36, 8), 't');
        final ImageButton imageButton2 = new ImageButton(SwingUtil.getImageGifIcon("moveBottom"));
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Mover.move(Orderer.this.rightList, Mover.Direction.BOTTOM);
                Orderer.this.rightList.requestFocus();
                Orderer.this.enableUpdates();
            }
        };
        SwingUtil.echoAction(this.leftList, imageButton2, actionListener, KeyStroke.getKeyStroke(35, 8), 'b');
        final JButton jButton = new JButton(SwingUtil.getImageGifIcon("upArrow"));
        jButton.setToolTipText("<html>Click to move a used " + this.itemName + " up the " + this.leftListTip + " list</html>");
        final JButton jButton2 = new JButton(SwingUtil.getImageGifIcon("downArrow"));
        jButton2.setToolTipText("<html>Click to move a used " + this.itemName + " down the " + this.leftListTip + " list</html>");
        jButton.setMargin(new Insets(1, 2, 1, 2));
        jButton2.setMargin(new Insets(1, 2, 1, 2));
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Mover.move(Orderer.this.rightList, Mover.Direction.UP);
                Orderer.this.rightList.requestFocus();
                Orderer.this.enableUpdates();
            }
        };
        SwingUtil.echoAction(this.rightList, jButton, actionListener, KeyStroke.getKeyStroke(38, 8), 'u');
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Mover.move(Orderer.this.rightList, Mover.Direction.DOWN);
                Orderer.this.rightList.requestFocus();
                Orderer.this.enableUpdates();
            }
        };
        SwingUtil.echoAction(this.rightList, jButton2, actionListener, KeyStroke.getKeyStroke(40, 8), 'd');
        JPanel jPanel5 = new JPanel(new BorderLayout(0, 4));
        jPanel5.add((Component)imageButton, "North");
        jPanel5.add((Component)jButton, "South");
        jPanel4.add((Component)jPanel5, "North");
        JPanel jPanel6 = new JPanel(new BorderLayout(0, 4));
        jPanel6.add((Component)jButton2, "North");
        jPanel6.add((Component)imageButton2, "South");
        jPanel4.add((Component)jPanel6, "South");
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (Orderer.this.rightList.getSelectedIndex() > -1) {
                    Orderer.this.leftButton.setEnabled(true);
                    ToolTipOnDemand.getSingleton().showLater(Orderer.this.rightButton, false, null, -35, 45, false, "<html><center><u>Double click</u> to <b><i>stop using</i></b><br><small>(or <u>drag</u> to " + Orderer.this.rightListTip + " list<br>or <u>click</u> right button)</small></center><</html>");
                } else {
                    Orderer.this.leftButton.setEnabled(false);
                }
                imageButton.setEnabled(true);
                imageButton2.setEnabled(true);
                jButton.setEnabled(true);
                jButton2.setEnabled(true);
                int[] nArray = Orderer.this.rightList.getSelectedIndices();
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == 0) {
                        imageButton.setEnabled(false);
                        jButton.setEnabled(false);
                        continue;
                    }
                    if (nArray[i] != Orderer.this.rightList.getModel().getSize() - 1) continue;
                    imageButton2.setEnabled(false);
                    jButton2.setEnabled(false);
                }
                if (Orderer.this.rightList.getModel().getSize() <= 1 || nArray.length <= 0) {
                    jButton.setEnabled(false);
                    jButton2.setEnabled(false);
                    imageButton.setEnabled(false);
                    imageButton2.setEnabled(false);
                } else if (Orderer.this.rightList.getSelectedIndices().length == Orderer.this.rightList.getModel().getSize()) {
                    jButton.setEnabled(false);
                    jButton2.setEnabled(false);
                    imageButton.setEnabled(false);
                    imageButton2.setEnabled(false);
                }
            }
        };
        final ImageButton imageButton3 = new ImageButton(SwingUtil.getImageGifIcon("moveBottom"));
        final ImageButton imageButton4 = new ImageButton(SwingUtil.getImageGifIcon("moveTop"));
        final JButton jButton3 = new JButton(SwingUtil.getImageGifIcon("upArrow"));
        jButton3.setToolTipText("<html>Click to move a used " + this.itemName + " up the " + this.leftListTip + " list</html>");
        final JButton jButton4 = new JButton(SwingUtil.getImageGifIcon("downArrow"));
        jButton4.setToolTipText("<html>Click to move a used " + this.itemName + " down the " + this.leftListTip + " list</html>");
        final AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = Orderer.this.leftList.getSelectedValues();
                if (Orderer.this.emptyNotAllowed && objectArray.length == Orderer.this.leftList.getModel().getSize()) {
                    JOptionPane.showMessageDialog(jDialog, "<html>Can not remove, as you need to have at least one " + Orderer.this.itemName + " for column/tree display.</html>");
                    return;
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    ((DefaultListModel)Orderer.this.leftList.getModel()).removeElement(objectArray[i]);
                    ((DefaultListModel)Orderer.this.rightList.getModel()).addElement(objectArray[i]);
                }
                Orderer.this.sort((DefaultListModel)Orderer.this.rightList.getModel());
                int[] nArray = Orderer.this.leftList.getSelectedIndices();
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == 0) {
                        jButton3.setEnabled(false);
                        imageButton4.setEnabled(false);
                    }
                    if (nArray[i] != Orderer.this.leftList.getModel().getSize() - 1) continue;
                    jButton4.setEnabled(false);
                    imageButton3.setEnabled(false);
                }
                Orderer.this.enableUpdates();
            }
        };
        this.rightButton = new JButton(abstractAction);
        this.rightButton.setToolTipText("<html>Click to <b><i>stop using</i></b> a selected " + this.itemNamePlural + " in " + this.leftListTip + " list </html>");
        final ListSelectionListener listSelectionListener2 = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (Orderer.this.leftList.getSelectedIndex() > -1) {
                    Orderer.this.rightButton.setEnabled(true);
                    ToolTipOnDemand.getSingleton().showLater(Orderer.this.rightButton, false, null, -35, 45, false, "<html><center><u>Double click</u> to <b><i>stop using</i></b><br><small>(or <u>drag</u> to " + Orderer.this.rightListTip + " list<br>or <u>click</u> right button)</small></center><</html>");
                } else {
                    Orderer.this.rightButton.setEnabled(false);
                }
                imageButton4.setEnabled(true);
                imageButton3.setEnabled(true);
                jButton3.setEnabled(true);
                jButton4.setEnabled(true);
                int[] nArray = Orderer.this.leftList.getSelectedIndices();
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == 0) {
                        imageButton4.setEnabled(false);
                        jButton3.setEnabled(false);
                        continue;
                    }
                    if (nArray[i] != Orderer.this.leftList.getModel().getSize() - 1) continue;
                    imageButton3.setEnabled(false);
                    jButton4.setEnabled(false);
                }
                if (Orderer.this.leftList.getModel().getSize() <= 1 || nArray.length <= 0) {
                    imageButton4.setEnabled(false);
                    imageButton3.setEnabled(false);
                    jButton3.setEnabled(false);
                    jButton4.setEnabled(false);
                } else if (Orderer.this.leftList.getSelectedIndices().length == Orderer.this.leftList.getModel().getSize()) {
                    imageButton4.setEnabled(false);
                    imageButton3.setEnabled(false);
                    jButton3.setEnabled(false);
                    jButton4.setEnabled(false);
                }
            }
        };
        this.rightButton.setVisible(this.isLeftRightOk);
        final AbstractAction abstractAction2 = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = Orderer.this.rightList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    ((DefaultListModel)Orderer.this.leftList.getModel()).addElement(objectArray[i]);
                    ((DefaultListModel)Orderer.this.rightList.getModel()).removeElement(objectArray[i]);
                    listSelectionListener2.valueChanged(new ListSelectionEvent(Orderer.this.leftList, 0, 0, false));
                }
                int[] nArray = Orderer.this.leftList.getSelectedIndices();
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == 0) {
                        imageButton4.setEnabled(false);
                        jButton3.setEnabled(false);
                    }
                    if (nArray[i] != Orderer.this.leftList.getModel().getSize() - 1) continue;
                    imageButton3.setEnabled(false);
                    jButton4.setEnabled(false);
                }
                if (Orderer.this.ms != null) {
                    System.out.println("Marker sort now");
                    Orderer.this.sort((DefaultListModel)Orderer.this.leftList.getModel());
                }
                Orderer.this.enableUpdates();
            }
        };
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Mover.move(Orderer.this.leftList, Mover.Direction.TOP);
                Orderer.this.leftList.requestFocus();
                Orderer.this.enableUpdates();
            }
        };
        SwingUtil.echoAction(this.leftList, imageButton4, actionListener, KeyStroke.getKeyStroke(36, 8), 't');
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Mover.move(Orderer.this.leftList, Mover.Direction.BOTTOM);
                Orderer.this.leftList.requestFocus();
                Orderer.this.enableUpdates();
            }
        };
        SwingUtil.echoAction(this.leftList, imageButton3, actionListener, KeyStroke.getKeyStroke(35, 8), 'b');
        jButton3.setMargin(new Insets(1, 2, 1, 2));
        jButton4.setMargin(new Insets(1, 2, 1, 2));
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Mover.move(Orderer.this.leftList, Mover.Direction.UP);
                Orderer.this.leftList.requestFocus();
                Orderer.this.enableUpdates();
            }
        };
        SwingUtil.echoAction(this.leftList, jButton3, actionListener, KeyStroke.getKeyStroke(38, 8), 'u');
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Mover.move(Orderer.this.leftList, Mover.Direction.DOWN);
                Orderer.this.leftList.requestFocus();
                Orderer.this.enableUpdates();
            }
        };
        SwingUtil.echoAction(this.leftList, jButton4, actionListener, KeyStroke.getKeyStroke(40, 8), 'd');
        JPanel jPanel7 = new JPanel(new BorderLayout());
        JPanel jPanel8 = new JPanel(new BorderLayout(0, 4));
        jPanel8.add((Component)imageButton4, "North");
        jPanel8.add((Component)jButton3, "South");
        jPanel7.add((Component)jPanel8, "North");
        JPanel jPanel9 = new JPanel(new BorderLayout(0, 4));
        jPanel9.add((Component)jButton4, "North");
        jPanel9.add((Component)imageButton3, "South");
        jPanel7.add((Component)jPanel9, "South");
        jPanel3 = new JPanel(new BorderLayout(0, 0));
        jPanel3.setOpaque(true);
        this.rightListScrollPane = new JScrollPane(this.rightList);
        this.rightListScrollPane.setPreferredSize(new Dimension(350, 250));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout(0, 0));
        jPanel10.add((Component)this.rightListScrollPane, "Center");
        jPanel10.add((Component)jPanel4, "East");
        JPanel jPanel11 = new JPanel(new BorderLayout(8, 1));
        jPanel11.setBorder(BorderFactory.createEmptyBorder(1, 2, 10, 2));
        JPanel jPanel12 = new JPanel();
        jPanel12.add(this.rightListHeader);
        jPanel11.add((Component)jPanel12, "North");
        jPanel11.add((Component)jPanel10, "Center");
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new BoxLayout(jPanel13, 1));
        this.leftButton = new JButton(abstractAction2);
        Basics.HearEnterKey(this.leftList, this.rightButton);
        Basics.HearEnterKey(this.rightList, this.leftButton);
        this.leftButton.setToolTipText("<html>Click to <b><i>use</i></b> selected " + this.itemNamePlural + " in list " + this.rightListTip);
        if (this.rightList != null) {
            this.rightList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (Orderer.this.isLeftRightOk && mouseEvent.getClickCount() == 2) {
                        abstractAction2.actionPerformed(new ActionEvent(Orderer.this.rightList, mouseEvent.getID(), "select"));
                    }
                }
            });
        }
        this.leftButton.setIcon(SwingUtil.getImageGifIcon("leftArrow"));
        if (this.rightList != null) {
            this.rightList.addListSelectionListener(listSelectionListener);
        }
        this.leftButton.setMargin(new Insets(1, 2, 1, 2));
        jPanel13.add(this.leftButton);
        this.leftList.setVisibleRowCount(n);
        this.leftList.setDragEnabled(true);
        this.leftList.setSelectionMode(2);
        this.leftButton.setEnabled(false);
        if (this.leftList != null) {
            if (doubleClickResponder != null) {
                this.leftList.setToolTipText("<html><h3>More options exist ...</h3>Double click on any item in the " + this.rightListTip + "<br>in order to access more options...</html>");
            } else {
                this.leftList.setToolTipText("<html>To <b><i>stop using</i></b> a " + this.itemName + " <u>drag</u> it right to the " + this.rightListTip + " list or click right button.<br>To <b><i>reorder</i></b> a " + this.itemName + " drag up/down or click up/down buttons.</html>");
                jComponent2.setToolTipText(this.leftList.getToolTipText());
            }
            this.leftList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    if (doubleClickResponder != null) {
                        ToolTipManager.sharedInstance().setEnabled(false);
                        ToolTipOnDemand.getSingleton().showWithoutCancelButton(Orderer.this.leftList, false, mouseEvent.getX() + 5, mouseEvent.getY() + 5);
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    if (doubleClickResponder != null) {
                        ToolTipManager.sharedInstance().setEnabled(true);
                        ToolTipOnDemand.getSingleton().hideTipWindow();
                    }
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (doubleClickResponder != null) {
                        ToolTipManager.sharedInstance().setEnabled(true);
                        ToolTipOnDemand.getSingleton().hideTipWindow();
                    }
                    if (mouseEvent.getClickCount() == 2 && Orderer.this.isLeftRightOk) {
                        if (doubleClickResponder == null) {
                            abstractAction.actionPerformed(new ActionEvent(Orderer.this.leftList, mouseEvent.getID(), "select"));
                        } else {
                            int n = Orderer.this.leftList.locationToIndex(mouseEvent.getPoint());
                            if (n >= 0) {
                                doubleClickResponder.respond(Orderer.this.leftList.getModel().getElementAt(n), Orderer.this.leftList);
                                listSelectionListener2.valueChanged(new ListSelectionEvent(Orderer.this.leftList, 0, 0, false));
                            }
                        }
                    }
                }
            });
        }
        this.rightButton.setIcon(SwingUtil.getImageGifIcon("rightArrow"));
        if (this.leftList != null) {
            this.leftList.addListSelectionListener(listSelectionListener2);
        }
        this.rightButton.setEnabled(false);
        this.rightButton.setMargin(new Insets(1, 2, 1, 2));
        jPanel13.add(this.rightButton);
        this.leftListScrollPane = new JScrollPane(this.leftList);
        this.leftListScrollPane.setPreferredSize(new Dimension(350, 250));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new BorderLayout(0, 0));
        jPanel14.add((Component)this.leftListScrollPane, "Center");
        jPanel14.add((Component)jPanel7, "East");
        JPanel jPanel15 = new JPanel(new BorderLayout(8, 1));
        jPanel15.setBorder(BorderFactory.createEmptyBorder(1, 15, 10, 2));
        JPanel jPanel16 = new JPanel();
        if (jComponent2 != null) {
            jPanel16.add(jComponent2);
        } else {
            jPanel16.add(new JLabel("Selected"));
        }
        jPanel15.add((Component)jPanel16, "North");
        jPanel15.add((Component)jPanel14, "Center");
        Box box = new Box(2);
        box.add(jPanel15);
        box.add(jPanel13);
        box.add(jPanel11);
        if (this.guide != null) {
            jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)jComponent3, "North");
            jPanel.add((Component)new JPanel(), "Center");
            jComponent4 = new JLabel(this.guide);
            jPanel.add((Component)jComponent4, "South");
            jPanel3.add((Component)jPanel, "North");
        }
        jPanel3.add((Component)box, "Center");
        jPanel = new JPanel(new BorderLayout());
        if (jComponent != null) {
            jPanel2.add(jComponent);
        }
        jPanel.add((Component)jPanel2, "West");
        jComponent4 = new JButton("Done");
        if (window != null) {
            Object object;
            if (window instanceof JDialog) {
                object = new ActionListener(){
                    final /* synthetic */ JButton val$done;
                    {
                        this.val$done = jButton;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((JDialog)window).getRootPane().setDefaultButton(val$done);
                                val$done.requestFocus();
                                System.out.println("Focus is done...");
                            }
                        });
                    }
                };
                Timer timer = new Timer(300, (ActionListener)object);
                timer.setRepeats(false);
                timer.start();
            }
            ((AbstractButton)jComponent4).addActionListener(CpuInfo.getCloseAction(window));
            if (this.doneListener != null) {
                ((AbstractButton)jComponent4).addActionListener(this.doneListener);
            }
            if (window instanceof RootPaneContainer) {
                CpuInfo.registerEscape((RootPaneContainer)((Object)window), (AbstractButton)jComponent4);
            }
            if (this.updateButton != null && this.showUpdate) {
                jPanel2.add(this.cbAutoUpdate);
            }
            if (this.resetRequired) {
                object = new JButton("Revert to original");
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Orderer.this.leftModel.removeAllElements();
                        Orderer.this.rightModel.removeAllElements();
                        Iterator iterator = linkedHashSet.iterator();
                        while (iterator.hasNext()) {
                            Orderer.this.leftModel.addElement(iterator.next());
                        }
                        iterator = linkedHashSet2.iterator();
                        while (iterator.hasNext()) {
                            Orderer.this.rightModel.addElement(iterator.next());
                        }
                        Orderer.this.enableUpdates();
                    }
                });
                jPanel2.add((Component)object);
            }
            object = new JPanel();
            ((Container)object).add(jComponent4);
            jPanel.add((Component)object, "East");
        }
        jPanel3.add((Component)jPanel, "South");
        if (this.leftList != null && this.leftList.getSelectedIndex() < 0) {
            imageButton4.setEnabled(false);
            imageButton3.setEnabled(false);
            jButton3.setEnabled(false);
            jButton4.setEnabled(false);
        }
        if (this.rightList != null && this.rightList.getSelectedIndex() < 0) {
            imageButton.setEnabled(false);
            imageButton2.setEnabled(false);
            jButton.setEnabled(false);
            jButton2.setEnabled(false);
        }
        this.setIsLeftRightOk(this.isLeftRightOk);
        this.btns = jPanel2;
        return jPanel3;
    }

    public void setDoneListener(ActionListener actionListener) {
        this.doneListener = actionListener;
    }

    public void show(boolean bl, String string) {
        if (string != null) {
            SwingUtil.position(this.owner, this.dlg, string);
        }
        this.dlg.setModal(bl);
        if (this.updateButton != null) {
            this.dlg.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    if (Orderer.this.updateButton.isEnabled()) {
                        try {
                            Orderer.this.updateButton.doClick();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(System.err);
                        }
                    }
                    Orderer.this.dlg.dispose();
                }
            });
        }
        this.dlg.setVisible(true);
        ToolTipManager.sharedInstance().setEnabled(true);
    }

    public List<T> getResults() {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (int i = 0; i < this.leftList.getModel().getSize(); ++i) {
            arrayList.add(this.leftList.getModel().getElementAt(i));
        }
        return arrayList;
    }

    public void sortAlphaCD() {
        if (this.ms == null) {
            this.ms = new MarkerSorter();
        }
        this.resetLists(this.ms.sort(this.getLeftList()), this.ms.sort(this.getRightList()));
    }

    public List<T> getLeftList() {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (int i = 0; i < this.leftList.getModel().getSize(); ++i) {
            arrayList.add(this.leftList.getModel().getElementAt(i));
        }
        return arrayList;
    }

    public List<T> getRightList() {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (int i = 0; i < this.rightList.getModel().getSize(); ++i) {
            arrayList.add(this.rightList.getModel().getElementAt(i));
        }
        return arrayList;
    }

    public void setLists(Window window, Collection<T> collection, Collection<T> collection2, String string, String string2) {
        JLabel jLabel = SwingUtil.TitleLabel(new JLabel(string));
        JLabel jLabel2 = SwingUtil.TitleLabel(new JLabel(string2));
        this.setLists(window, collection, collection2, null, jLabel, jLabel2, null, null, null);
    }

    public void setLists(Window window, Collection<T> collection, Collection<T> collection2, String string, JComponent jComponent) {
        JLabel jLabel = SwingUtil.TitleLabel(new JLabel(string));
        this.setLists(window, collection, collection2, null, jLabel, jComponent, null, null, null);
    }

    public JPanel setLists(Window window, Collection<T> collection, Collection<T> collection2, String string, JComponent jComponent, ListCellRenderer<T> listCellRenderer, ListCellRenderer<T> listCellRenderer2) {
        JLabel jLabel = SwingUtil.TitleLabel(new JLabel(string));
        return this.setLists(window, collection, collection2, null, jLabel, jComponent, listCellRenderer, listCellRenderer2, null);
    }

    public static Collection<String> toCollection(String string, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        for (String string2 : stringArray) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        JButton jButton = new JButton("Show result");
        jButton.setToolTipText("Click to update results");
        Orderer<String> orderer = new Orderer<String>(jButton, true);
        orderer.visibleRows = 6;
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                List list = Orderer.this.getResults();
                System.out.println(list.size() + " selected..." + list);
            }
        });
        Collection<String> collection = Orderer.toCollection("File name (in file system)", "SPECIMEN", "$SRC", "TYPE", "TUBE NAME", "keyword5", "keyword6", "k7", "k8", "yada yaada yada");
        Collection<String> collection2 = Orderer.toCollection("Sample keyword", "$SRC");
        orderer.title = "Testing";
        orderer.setLists(null, collection2, collection, "Used for name", "Available for name");
        orderer.btns.add(jButton);
        orderer.show(false, "south west");
    }

    public static interface DoubleClickResponder {
        public void respond(Object var1, Component var2);
    }

    public static abstract class StringTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;

        protected abstract String exportString(JComponent var1);

        protected abstract void importString(JComponent var1, String var2);

        protected abstract void cleanup(JComponent var1, boolean var2);

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            return new StringSelection(this.exportString(jComponent));
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 2;
        }

        @Override
        public boolean importData(JComponent jComponent, Transferable transferable) {
            if (this.canImport(jComponent, transferable.getTransferDataFlavors())) {
                try {
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    this.importString(jComponent, string);
                    return true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            this.cleanup(jComponent, n == 2);
        }

        @Override
        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!DataFlavor.stringFlavor.equals(dataFlavorArray[i])) continue;
                return true;
            }
            return false;
        }
    }
}

