/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

import edu.stanford.facs.swing.Basics;
import edu.stanford.facs.swing.CurveSimplifier;
import edu.stanford.facs.swing.Numeric;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;

public class Separatrix
implements Runnable {
    static final int[] empty = new int[0];
    final int minSplit;
    final double[][] clueDistances;
    final int numClues;
    final String[] clueLetters;
    final int[] tooLow;
    final int[] clueCnts4Balanced;
    final int[] clueCnts4MinSplit;
    final int totalEventCount;
    final int totalClueCnt4MinSplit;
    ArrayList<int[]> groupsOfClues = null;
    ArrayList<Double> separatracies = null;
    final int[] clueGridAssignments;
    final double[] densityGrid;
    final int M;
    final double totalDensity;
    final double kld;
    final double kldThreshold;
    final double kldFreqThreshold;
    final double[] normalDistribution;
    final boolean doKldTest;
    final boolean doKldFreqTest;
    boolean balanced = true;
    static final int GROUP_ANY = 3;
    static final int GROUP_CONTIGUOUS = 2;
    static final int GROUP_SCORE = 1;
    int groupRule = 1;
    double worstScore;
    double bestScore;
    int worstIdx;
    int bestIdx;
    int numberOfTopScoresToKeep = 10;
    public int verboseFlags = 0;
    double densityW = 0.006;
    int possibleGroups = 0;
    int nThreads = 0;
    int myThread = 0;
    int edgeRule = 1;
    static final int EDGE_WITH_OTHER_NOT_GRID = 1;
    static final int EDGE_WITH_OTHER_ONLY = 2;
    static final int EDGE_WITH_OTHER_OR_GRID = 3;
    public static int dfltDecimalPlaces = 5;
    CountDownLatch latch;

    public int[] getBestClusterGroup() {
        if (this.groupsOfClues.size() == 0 || this.bestScore > 1.0) {
            return empty;
        }
        return this.groupsOfClues.get(this.bestIdx);
    }

    public double getBestScore() {
        if (this.groupsOfClues.size() == 0 || this.bestScore > 1.0) {
            return Double.NaN;
        }
        return this.bestScore;
    }

    public int[] getWorstClusterGroup() {
        if (this.groupsOfClues.size() == 0 || this.worstScore < 0.0 || this.worstIdx < 0) {
            return empty;
        }
        return this.groupsOfClues.get(this.worstIdx);
    }

    public double getWorstScore() {
        if (this.groupsOfClues.size() == 0 || this.worstScore < 0.0 || this.worstIdx < 0) {
            return Double.NaN;
        }
        return this.worstScore;
    }

    public TreeMap<Double, int[]> getBestScores() {
        TreeMap<Double, int[]> treeMap = new TreeMap<Double, int[]>();
        for (int i = 0; i < this.groupsOfClues.size(); ++i) {
            treeMap.put(this.separatracies.get(i), this.groupsOfClues.get(i));
        }
        return treeMap;
    }

    public Separatrix(int[] nArray, double[][] dArray, int[] nArray2, int n, int[] nArray3, double[] dArray2, double d, double[] dArray3, double d2, double d3, int n2) throws Exception {
        this(nArray, dArray, nArray2, n, nArray3, dArray2, d, dArray3, d2, d3, n2, Numeric.sum(nArray), nArray);
    }

    public Separatrix(Separatrix separatrix) throws Exception {
        this(separatrix.clueCnts4Balanced, separatrix.clueDistances, separatrix.tooLow, separatrix.M, separatrix.clueGridAssignments, separatrix.densityGrid, separatrix.kld, separatrix.normalDistribution, separatrix.kldThreshold, separatrix.kldFreqThreshold, separatrix.minSplit, separatrix.totalEventCount, separatrix.clueCnts4MinSplit);
        this.groupRule = separatrix.groupRule;
        this.edgeRule = separatrix.edgeRule;
        this.verboseFlags = separatrix.verboseFlags;
        this.numberOfTopScoresToKeep = separatrix.numberOfTopScoresToKeep;
        this.balanced = separatrix.balanced;
        this.worstScore = separatrix.worstScore;
        this.worstIdx = separatrix.worstIdx;
        this.bestIdx = separatrix.bestIdx;
        this.bestScore = separatrix.bestScore;
        this.possibleGroups = separatrix.possibleGroups;
        this.groupsOfClues.addAll(separatrix.groupsOfClues);
        this.separatracies.addAll(separatrix.separatracies);
    }

    public Separatrix(int[] nArray, double[][] dArray, int[] nArray2, int n, int[] nArray3, double[] dArray2, double d, double[] dArray3, double d2, double d3, int n2, int n3, int[] nArray4) throws Exception {
        this.numClues = nArray == null ? 0 : nArray.length;
        this.clueCnts4Balanced = nArray;
        this.totalEventCount = n3;
        this.clueCnts4MinSplit = nArray4;
        this.totalClueCnt4MinSplit = Numeric.sum(nArray4);
        this.clueDistances = dArray;
        this.groupsOfClues = new ArrayList(this.numClues);
        this.separatracies = new ArrayList(this.numClues);
        this.tooLow = nArray2;
        this.groupsOfClues.clear();
        this.clueLetters = this.numClues > 0 ? new Basics.IndirectSorter().sortLetters(Basics.toIntegers(nArray), true) : null;
        if (nArray3 != null && n * n != nArray3.length) {
            throw new Exception("M=" + n + ", so there must be " + n * n + " allClusterGridAssignments ID values");
        }
        if (dArray2 != null && n * n != dArray2.length) {
            throw new Exception("M=" + n + ", so there must be " + n * n + " density values");
        }
        this.M = n;
        this.clueGridAssignments = nArray3;
        this.densityGrid = dArray2;
        if (dArray2 == null) {
            this.totalDensity = 0.0;
        } else {
            double d4 = 0.0;
            for (int i = 0; i < dArray2.length; ++i) {
                d4 += dArray2[i];
            }
            this.totalDensity = d4;
        }
        this.kld = d;
        this.kldThreshold = d2;
        this.kldFreqThreshold = d3;
        this.normalDistribution = dArray3;
        if (dArray3 != null && n * n != dArray3.length) {
            throw new Exception("M=" + n + ", so there must be " + n * n + " normalDistribution values");
        }
        this.doKldTest = d2 > 0.0 && d < d2;
        this.doKldFreqTest = dArray3 != null && this.doKldTest;
        this.minSplit = n2;
    }

    public Separatrix(int[] nArray, double[][] dArray, int[] nArray2, int n, int[] nArray3, double[] dArray2, double d, double[] dArray3, double d2) throws Exception {
        this(nArray, dArray, nArray2, n, nArray3, dArray2, d, dArray3, d2, 0.0075, 0);
    }

    public int getMinSplit() {
        return this.minSplit;
    }

    public double[][] getDists() {
        return this.clueDistances;
    }

    public int getNumClusters() {
        return this.numClues;
    }

    public String[] getClusterLetters() {
        return this.clueLetters;
    }

    public int[] getTooLow() {
        return this.tooLow;
    }

    public int[] getClusterCountsForBalanced() {
        return this.clueCnts4Balanced;
    }

    public int[] getClusterCountsForMinSplit() {
        return this.clueCnts4MinSplit;
    }

    public int getTotalEventCount() {
        return this.totalEventCount;
    }

    public Separatrix(int[] nArray, double[][] dArray, int[] nArray2) throws Exception {
        this(nArray, dArray, nArray2, dArray == null ? 0 : dArray.length, null, null, 0.0, null, 0.0);
    }

    public int[] getClusterGridAssignments() {
        return this.clueGridAssignments;
    }

    public double[] getDensityGrid() {
        return this.densityGrid;
    }

    public int getM() {
        return this.M;
    }

    public double getTotalDensity() {
        return this.totalDensity;
    }

    public Separatrix(int n, int[] nArray, double[] dArray) throws Exception {
        this(null, null, null, n, nArray, dArray, 0.0, null, 0.0);
    }

    public double getKld() {
        return this.kld;
    }

    public double getKldThreshold() {
        return this.kldThreshold;
    }

    public double getKldFreqThreshold() {
        return this.kldFreqThreshold;
    }

    public double[] getKldNormal() {
        return this.normalDistribution;
    }

    void resolveBestIdx() {
        int n = this.separatracies.size();
        if (n == 1) {
            this.worstIdx = -1;
        }
        for (int i = 0; i < n; ++i) {
            double d = this.separatracies.get(i);
            if (d != this.bestScore) continue;
            this.bestIdx = i;
            return;
        }
    }

    void resolveBest() {
        int n = this.separatracies.size();
        double d = 100.0;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d2 = this.separatracies.get(i);
            if (!(d2 < d)) continue;
            n2 = i;
            d = d2;
        }
        this.bestIdx = n2;
        this.bestScore = d;
    }

    void resolveWorst() {
        int n = this.separatracies.size();
        double d = -1.0;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d2 = this.separatracies.get(i);
            if (!(d2 > d)) continue;
            n2 = i;
            d = d2;
        }
        this.worstIdx = n2;
        this.worstScore = d;
    }

    public void merge(Collection<Separatrix> collection) {
        for (Separatrix separatrix : collection) {
            this.groupsOfClues.addAll(separatrix.groupsOfClues);
            this.separatracies.addAll(separatrix.separatracies);
        }
        this.resolveBest();
        this.resolveWorst();
    }

    public void compute() {
        this.compute(0);
    }

    private void initScoring(int n) {
        this.possibleGroups = 0;
        this.bestScore = 100.0;
        this.worstIdx = 0;
        this.worstScore = -1.0;
        this.separatracies.clear();
        this.groupsOfClues.clear();
        int n2 = Separatrix.count(this.numClues);
        if (n > 0 && n < n2) {
            n2 = n;
        }
        this.separatracies.ensureCapacity(n2);
        this.groupsOfClues.ensureCapacity(n2);
        if (n < 0) {
            System.err.println("Top score count of " + n + ", re-interpreted as 0... all scores");
            this.numberOfTopScoresToKeep = 0;
        } else {
            this.numberOfTopScoresToKeep = n;
        }
    }

    public void compute(int n) {
        if (this.numClues == 0) {
            System.err.println("Clusters not defined");
            return;
        }
        this.initScoring(n);
        int n2 = this.numClues / 2;
        for (int i = 1; i <= n2; ++i) {
            this.addGroupsOfClusters(i, this.groupRule, true);
        }
        this.resolveBestIdx();
        if (this.verboseFlags > 0 && this.verboseFlags != 16) {
            this.printResult();
        }
    }

    public void printResult() {
        this.printResult(System.out);
    }

    public void printResult(PrintStream printStream) {
        printStream.println("For all groups grid " + this.M + "x" + this.M + ", " + this.numClues + " clusters & edge rule #" + this.edgeRule + "\n\t-best score is " + Separatrix.toString(this.getBestScore()) + " " + Arrays.toString(this.getBestClusterGroup()) + "\n\t-worst score is " + Separatrix.toString(this.getWorstScore()) + Arrays.toString(this.getWorstClusterGroup()));
        printStream.println();
    }

    public int[][] toArray() {
        return (int[][])this.groupsOfClues.toArray((T[])new int[0][]);
    }

    public String toLetters(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append(this.clueLetters[nArray[i] - 1]);
            if (i >= nArray.length - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public String[] toLetters() {
        String[] stringArray = new String[this.groupsOfClues.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.toLetters(this.groupsOfClues.get(i));
        }
        return stringArray;
    }

    public int[] getOtherClusters(int[] nArray) {
        if (nArray == null) {
            return empty;
        }
        int n = nArray.length;
        int[] nArray2 = new int[this.numClues - n];
        int n2 = 0;
        for (int i = 1; i <= this.numClues; ++i) {
            boolean bl = false;
            for (int j = 0; j < n; ++j) {
                if (i != nArray[j]) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            nArray2[n2++] = i;
        }
        return nArray2;
    }

    boolean allAreTooLow(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < this.tooLow.length; ++j) {
                if (nArray[i] == this.tooLow[j]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isContiguous(int[] nArray) {
        if (this.numClues < 3) {
            return true;
        }
        int[] nArray2 = this.getOtherClusters(nArray);
        if (this.tooLow != null && this.tooLow.length > 0 && (this.allAreTooLow(nArray) || this.allAreTooLow(nArray2))) {
            return false;
        }
        ContiguityChecker contiguityChecker = new ContiguityChecker();
        if (!contiguityChecker.isContiguous(nArray)) {
            return false;
        }
        return contiguityChecker.isContiguous(nArray2);
    }

    public static boolean isExactlyHalf(int n, int n2) {
        return n % 2 == 0 && n2 == n / 2;
    }

    public static int count(int n) {
        return (int)(Math.pow(2.0, n - 1) - 1.0);
    }

    public static int count(int n, int n2) {
        int n3 = 1;
        for (int i = 1; i <= n2; ++i) {
            n3 *= n - i + 1;
            n3 /= i;
        }
        return n3;
    }

    public boolean getBalanced() {
        return this.balanced;
    }

    public void setBalanced(boolean bl) {
        this.balanced = bl;
    }

    public void setRuleGroup1_SeparatrixScore() {
        this.groupRule = 1;
    }

    public void setRuleGroup2_Contiguous() {
        this.groupRule = 2;
    }

    public void setRuleGroup3_Any() {
        this.groupRule = 3;
    }

    public int getCount4Balanced(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            n += this.clueCnts4Balanced[n2 - 1];
        }
        return n;
    }

    public int getCount4MinSplit(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            n += this.clueCnts4MinSplit[n2 - 1];
        }
        return n;
    }

    public double getKldFreq(int[] nArray) {
        int[] nArray2 = this.get1stPartInds(nArray);
        int[] nArray3 = new int[4];
        int[] nArray4 = this.findEdges(nArray2, this.edgeRule, nArray3);
        int[] nArray5 = null;
        double[] dArray = null;
        double[] dArray2 = null;
        nArray5 = this.makeMap012(nArray2, nArray4);
        dArray = this.sumMap012(nArray5, this.densityGrid);
        dArray2 = this.sumMap012(nArray5, this.normalDistribution);
        return this.tallySumsOfMap012(dArray, dArray2);
    }

    public void printPolygon(int n) {
        this.getPolygon(new int[]{n}, this.densityW).print();
    }

    public void printPolygon() {
        this.getPolygon(this.getBestClusterGroup(), this.densityW).print();
    }

    public void printPolygon(int[] nArray) {
        this.getPolygon(nArray, this.densityW).print();
    }

    public Polygon getPolygon(int[] nArray) {
        return new Polygon(nArray, this.densityW);
    }

    public Polygon getPolygon() {
        return new Polygon(this.getBestClusterGroup(), this.densityW);
    }

    public Polygon getPolygon(int[] nArray, double d) {
        return new Polygon(nArray, d);
    }

    public Polygon getPolygon(double d) {
        return new Polygon(this.getBestClusterGroup(), d);
    }

    public int[] getBest() {
        return this.get(this.getBestClusterGroup());
    }

    public int[] get(int[] nArray) {
        return this.findEdges(this.get1stPartInds(nArray), this.edgeRule);
    }

    public int[][] getXy(int[] nArray) {
        int[] nArray2 = this.get1stPartInds(nArray);
        return Separatrix.ind2Sub(this.M, nArray2);
    }

    public double getScore(int[] nArray, int n) {
        int n2 = this.getCount4Balanced(nArray);
        int[] nArray2 = this.get1stPartInds(nArray);
        int[] nArray3 = new int[4];
        int[] nArray4 = this.findEdges(nArray2, this.edgeRule, nArray3);
        double d = this.computeDensity(nArray4);
        double d2 = 0.0;
        double d3 = d;
        if (this.balanced) {
            d2 = (double)n2 / (double)this.totalEventCount;
            d /= 4.0 * d2 * (1.0 - d2);
        }
        int[] nArray5 = null;
        double[] dArray = null;
        double[] dArray2 = null;
        double d4 = 0.0;
        if (this.doKldTest) {
            if (this.doKldFreqTest) {
                nArray5 = this.makeMap012(nArray2, nArray4);
                dArray = this.sumMap012(nArray5, this.densityGrid);
                d4 = this.tallySumsOfMap012(dArray, dArray2 = this.sumMap012(nArray5, this.normalDistribution));
                if (d4 < this.kldFreqThreshold) {
                    d = 1.0;
                }
            } else {
                d = 1.0;
            }
        }
        if (d < 1.0) {
            int n3 = 0;
            for (int i = 0; i < nArray3.length; ++i) {
                if (nArray3[i] <= 0) continue;
                ++n3;
            }
            if (n3 < 2) {
                d = n3 == 1 ? (d += 0.05) : (d += 0.1);
                if (d > 1.0) {
                    d = 1.0;
                }
            }
        }
        if (n == 0 || n == 16) {
            return d;
        }
        System.out.print("For clusters [");
        System.out.print(Arrays.toString(nArray));
        System.out.print("](");
        System.out.print(this.toLetters(nArray));
        System.out.print(") separatrix=");
        System.out.print(Separatrix.toString(d));
        if ((n & 2) == 2) {
            if (d != d3) {
                System.out.print("(raw=");
                System.out.print(Separatrix.toString(d3));
                if (this.balanced) {
                    System.out.print(", P=");
                    if (d2 > 0.5) {
                        System.out.print(Separatrix.toString(1.0 - d2));
                    } else {
                        System.out.print(Separatrix.toString(d2));
                    }
                    System.out.print(", adjusted=");
                    System.out.print(Separatrix.toString(d3 / (4.0 * d2 * (1.0 - d2))));
                }
                System.out.print(")");
            } else {
                System.out.print(" (no adjusting)");
            }
        }
        System.out.println();
        if ((n & 1) == 1) {
            System.out.println("\tisContiguous=" + this.isContiguous(nArray));
        }
        if ((n & 4) == 4) {
            System.out.print("\tborders=[");
            System.out.println("]");
        }
        if ((n & 8) == 8) {
            if (this.normalDistribution == null) {
                System.out.println("\tNo KLD normal distribution");
            } else {
                System.out.print("\tkld=");
                System.out.print(this.kld);
                System.out.print(", threshold=");
                System.out.print(this.kldThreshold);
                if (this.doKldTest) {
                    if (this.doKldFreqTest) {
                        System.out.print(", freq=");
                        System.out.print(Numeric.encodeRounded(d4, 4));
                        if (d4 > this.kldFreqThreshold) {
                            System.out.print(" > ");
                        } else {
                            System.out.print(" LESS than ");
                        }
                        System.out.print(this.kldFreqThreshold);
                        System.out.print(", actual=[");
                        System.out.print(Separatrix.toString(dArray));
                        System.out.print("], normal=[");
                        System.out.print(Separatrix.toString(dArray2));
                        System.out.println("]");
                    } else {
                        System.out.println(" ... KLD too low!");
                    }
                } else {
                    System.out.println(" ... no KLD test needed!");
                }
            }
        }
        return d;
    }

    public void computeInParallel(int n) throws Exception {
        this.computeInParallel(n, 0);
    }

    public void computeInParallel(int n, int n2) throws Exception {
        if (n < 2) {
            System.err.println("nThreads must be > 1 to run in parallel");
            this.compute(n2);
            return;
        }
        this.initScoring(n2);
        this.nThreads = n;
        ArrayList<Separatrix> arrayList = new ArrayList<Separatrix>();
        int n3 = 1;
        while (n3 < n) {
            Separatrix separatrix = new Separatrix(this);
            separatrix.nThreads = n;
            separatrix.myThread = n3++;
            arrayList.add(separatrix);
        }
        this.numberOfTopScoresToKeep = n2;
        this.latch = new CountDownLatch(arrayList.size() + 1);
        if ((this.verboseFlags & 0x10) == 16) {
            System.out.println("Starting " + n + " threads");
        }
        for (Separatrix separatrix : arrayList) {
            separatrix.latch = this.latch;
            Thread thread = new Thread(separatrix);
            thread.start();
        }
        Thread thread = new Thread(this);
        thread.start();
        try {
            this.latch.await();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        this.merge(arrayList);
        if ((this.verboseFlags & 0x10) == 16) {
            this.printResult();
        }
    }

    public void addGroupOfClusters(int[] nArray) {
        ++this.possibleGroups;
        if (this.nThreads > 0) {
            if (this.possibleGroups % this.nThreads != this.myThread) {
                if ((this.verboseFlags & 0x20) == 32) {
                    System.out.println("\t\t(thread #" + this.myThread + " AVOIDS #" + this.possibleGroups);
                }
                return;
            }
            if ((this.verboseFlags & 0x10) == 16) {
                System.out.println("** thread #" + this.myThread + " DOES  #" + this.possibleGroups + Arrays.toString(nArray));
            }
        }
        if (this.groupRule != 3) {
            int n = this.getCount4MinSplit(nArray);
            if (this.minSplit > 0 && (n < this.minSplit || this.totalClueCnt4MinSplit - n < this.minSplit)) {
                if ((this.verboseFlags & 1) == 1) {
                    if (n < this.minSplit) {
                        System.out.println("Size of " + Arrays.toString(nArray) + "(" + this.toLetters(nArray) + ") is " + n + "... < " + this.minSplit);
                    } else {
                        int[] nArray2 = this.getOtherClusters(nArray);
                        System.out.println("Size of " + Arrays.toString(nArray2) + "(" + this.toLetters(nArray2) + ") is " + n + "... < " + this.minSplit);
                    }
                }
            } else if (this.isContiguous(nArray)) {
                if (this.groupRule != 1) {
                    this.groupsOfClues.add(nArray);
                    this.separatracies.add(Double.NaN);
                } else {
                    double d = this.getScore(nArray, this.verboseFlags);
                    if (this.numberOfTopScoresToKeep > 0 && this.groupsOfClues.size() >= this.numberOfTopScoresToKeep) {
                        if (d < this.worstScore) {
                            this.groupsOfClues.set(this.worstIdx, nArray);
                            this.separatracies.set(this.worstIdx, d);
                            if (d < this.bestScore) {
                                this.bestScore = d;
                            }
                            this.resolveWorst();
                        }
                    } else {
                        if (d > this.worstScore) {
                            this.worstScore = d;
                            this.worstIdx = this.separatracies.size();
                        }
                        if (d < this.bestScore) {
                            this.bestScore = d;
                        }
                        this.groupsOfClues.add(nArray);
                        this.separatracies.add(d);
                    }
                    if ((this.verboseFlags & 2) == 2 && (d == this.bestScore || d == this.worstScore) && this.groupsOfClues.size() > 1) {
                        if (d == this.bestScore) {
                            System.out.println("\t\tBEST score so far");
                        } else if (d == this.worstScore) {
                            System.out.println("\t\tWORST score so far");
                        }
                    }
                }
            } else if ((this.verboseFlags & 1) == 1) {
                System.out.println("Not contiguous: " + Arrays.toString(nArray) + "(" + this.toLetters(nArray) + ")");
            }
        } else {
            this.groupsOfClues.add(nArray);
        }
    }

    public void addGroupsOfClusters(int n) {
        this.addGroupsOfClusters(n, 1, true);
    }

    public void addGroupsOfClusters(int n, int n2, boolean bl) {
        int n3;
        this.groupRule = n2;
        int n4 = Separatrix.count(this.numClues, n);
        if (bl && Separatrix.isExactlyHalf(this.numClues, n)) {
            n4 /= 2;
        }
        if ((n3 = n - 1) < 1) {
            if (this.numClues == 2) {
                this.addGroupOfClusters(new int[]{1});
            } else {
                int n5 = 1;
                while (n5 <= this.numClues) {
                    this.addGroupOfClusters(new int[]{n5++});
                }
            }
            return;
        }
        int n6 = this.numClues - n3;
        int[] nArray = new int[n3];
        int n7 = 0;
        block1: for (int i = 1; i <= n6; ++i) {
            int n8;
            for (n8 = 1; n8 <= n3; ++n8) {
                nArray[n8 - 1] = n8;
            }
            n8 = this.numClues - i;
            while (++n7 <= n4) {
                int n9;
                int[] nArray2 = new int[n];
                nArray2[0] = i;
                for (n9 = 0; n9 < n3; ++n9) {
                    nArray2[n9 + 1] = i + nArray[n9];
                }
                this.addGroupOfClusters(nArray2);
                if (nArray[--n9] == n8) {
                    boolean bl2 = true;
                    --n9;
                    while (n9 >= 0) {
                        if (nArray[n9] < n8 - (n3 - (n9 + 1))) {
                            int n10 = n9;
                            nArray[n10] = nArray[n10] + 1;
                            int n11 = nArray[n9] + 1;
                            for (int j = n9 + 1; j < n3; ++j) {
                                nArray[j] = n11++;
                            }
                            bl2 = false;
                            break;
                        }
                        --n9;
                    }
                    if (!bl2) continue;
                    continue block1;
                }
                int n12 = n9;
                nArray[n12] = nArray[n12] + 1;
            }
            return;
        }
    }

    public void printGroupsOfClues() {
        this.printGroupsOfClues(System.out);
    }

    public void printGroupsOfClues(PrintStream printStream) {
        if (printStream == null) {
            printStream = System.out;
        }
        int[][] nArray = this.toArray();
        String[] stringArray = this.toLetters();
        for (int i = 0; i < nArray.length; ++i) {
            printStream.print('#');
            printStream.print(i + 1);
            printStream.print(", ");
            printStream.print(Arrays.toString(nArray[i]));
            printStream.print("(");
            printStream.print(stringArray[i]);
            printStream.println(")");
        }
    }

    public boolean[] get1stSide(int[] nArray) {
        int n = this.clueGridAssignments.length;
        int n2 = nArray.length;
        boolean[] blArray = new boolean[n];
        block0: for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (this.clueGridAssignments[i] != nArray[j]) continue;
                blArray[i] = true;
                continue block0;
            }
        }
        return blArray;
    }

    public int[] makeMap012(int[] nArray, int[] nArray2) {
        int n;
        int[] nArray3 = new int[this.M * this.M];
        int n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            nArray3[nArray[n] - 1] = 1;
        }
        n2 = nArray2.length;
        for (n = 0; n < n2; ++n) {
            nArray3[nArray2[n] - 1] = 2;
        }
        return nArray3;
    }

    public double[] sumMap012(int[] nArray, double[] dArray) {
        int n;
        double[] dArray2 = new double[3];
        int n2 = nArray.length;
        double d = 0.0;
        for (n = 0; n < n2; ++n) {
            int n3 = nArray[n];
            dArray2[n3] = dArray2[n3] + dArray[n];
            d += dArray[n];
        }
        n = 0;
        while (n < 3) {
            int n4 = n++;
            dArray2[n4] = dArray2[n4] / d;
        }
        return dArray2;
    }

    public double tallySumsOfMap012(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            if (dArray[i] == 0.0 || dArray2[i] == 0.0) continue;
            d += dArray[i] * (Math.log(dArray[i]) - Math.log(dArray2[i]));
        }
        return d;
    }

    public int[] get1stPartInds(int[] nArray) {
        int n;
        int n2 = this.clueGridAssignments.length;
        int n3 = nArray.length;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        block0: for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                if (this.clueGridAssignments[n] != nArray[i]) continue;
                arrayList.add(n + 1);
                continue block0;
            }
        }
        n = arrayList.size();
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = (Integer)arrayList.get(i);
        }
        return nArray2;
    }

    public double getDensityWithOtherOrGrid(int[] nArray) {
        return this.getDensity(nArray, 3);
    }

    public double getDensityWithOtherNotGrid(int[] nArray) {
        return this.getDensity(nArray, 1);
    }

    public double getDensityWithOtherOnly(int[] nArray) {
        return this.getDensity(nArray, 2);
    }

    public double getDensity(int[] nArray) {
        return this.getDensity(nArray, this.edgeRule);
    }

    public double getDensity(int[] nArray, int n) {
        return this.computeDensity(this.getEdge(nArray, n));
    }

    public double computeDensity(int[] nArray) {
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            d += this.densityGrid[n - 1];
        }
        return d / this.totalDensity;
    }

    public int getRuleEdge() {
        return this.edgeRule;
    }

    void setRuleEdge(int n) {
        this.edgeRule = n;
        if (this.verboseFlags > 0) {
            System.out.println("\n** NEW edge rule: #" + this.edgeRule);
        }
    }

    public void setRuleEdge1_OtherClusterNotGridBorder() {
        this.setRuleEdge(1);
    }

    public void setRuleEdge2_OtherClusterOnly() {
        this.setRuleEdge(2);
    }

    public void setRuleEdge3_OtherClusterOrGridBorder() {
        this.setRuleEdge(3);
    }

    public int[] getEdgeWithOtherOrGrid(int[] nArray) {
        return this.findEdges(this.get1stPartInds(nArray), 3);
    }

    public int[] getEdgeWithOtherNotGrid(int[] nArray) {
        return this.findEdges(this.get1stPartInds(nArray), 1);
    }

    public int[] getEdgeWithOtherOnly(int[] nArray) {
        return this.findEdges(this.get1stPartInds(nArray), 2);
    }

    int[] getEdge(int[] nArray, int n) {
        return this.findEdges(this.get1stPartInds(nArray), n);
    }

    int[] findEdges(int[] nArray, int n) {
        int[] nArray2 = new int[4];
        return this.findEdges(nArray, n, nArray2);
    }

    int[] findEdges(int[] nArray, int n, int[] nArray2) {
        int n2;
        int n3;
        boolean[] blArray = new boolean[this.M * this.M + 2];
        int n4 = nArray.length;
        for (int i = 0; i < n4; ++i) {
            blArray[nArray[i]] = true;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        boolean[][] blArray2 = new boolean[this.M + 1][this.M + 1];
        boolean[][] blArray3 = new boolean[this.M + 1][this.M + 1];
        boolean[][] blArray4 = new boolean[this.M + 1][this.M + 1];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            n2 = (n5 - 1) % this.M + 1;
            int n6 = (n5 - 1) / this.M + 1;
            for (int i = -1; i < 2; ++i) {
                int n7 = n2 + i;
                boolean bl = false;
                if (n7 < 1) {
                    n7 = 1;
                    bl = true;
                    nArray2[0] = nArray2[0] + 1;
                } else if (n7 > this.M) {
                    n7 = this.M;
                    bl = true;
                    nArray2[1] = nArray2[1] + 1;
                }
                for (int j = -1; j < 2; ++j) {
                    int n8 = n6 + j;
                    boolean bl2 = bl;
                    if (!bl2) {
                        if (n8 < 1) {
                            n8 = 1;
                            bl2 = true;
                            nArray2[2] = nArray2[2] + 1;
                        } else if (n8 > this.M) {
                            n8 = this.M;
                            bl2 = true;
                            nArray2[3] = nArray2[3] + 1;
                        }
                    }
                    if (n == 3) {
                        if (!bl2 && blArray[(n8 - 1) * this.M + n7]) continue;
                        blArray2[n2][n6] = true;
                        arrayList.add(n2);
                        arrayList2.add(n6);
                        break;
                    }
                    if (bl2) {
                        blArray3[n2][n6] = true;
                        continue;
                    }
                    if (blArray[(n8 - 1) * this.M + n7]) continue;
                    blArray4[n2][n6] = true;
                }
                if (n == 3 && blArray2[n2][n6]) break;
            }
            if (n == 3 || !blArray4[n2][n6]) continue;
            if (n == 1) {
                if (blArray3[n2][n6]) continue;
                arrayList.add(n2);
                arrayList2.add(n6);
                continue;
            }
            if (n != 2) continue;
            arrayList.add(n2);
            arrayList2.add(n6);
        }
        n3 = arrayList.size();
        int[] nArray3 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray3[n2] = ((Integer)arrayList2.get(n2) - 1) * this.M + (Integer)arrayList.get(n2);
        }
        return nArray3;
    }

    public static int[][] orderEdge(int[][] nArray, int n) {
        int[] nArray2;
        int[] nArray3;
        int n2;
        int n3;
        int n4;
        Object object;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        Integer n5 = new Integer(1);
        int n6 = nArray.length;
        for (int i = 0; i < n6; ++i) {
            arrayList.add(nArray[i]);
        }
        HashMap<int[], Integer> hashMap = new HashMap<int[], Integer>();
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        int n7 = 0;
        while (n6 > 1) {
            int n8 = 0;
            object = (int[])arrayList.remove(n7);
            n4 = object[0];
            int n9 = object[1];
            if (!hashMap.containsKey(object) || n8 == 0) {
                linkedHashSet.add(object);
            }
            if (--n6 == 1) {
                if (hashMap.containsKey(arrayList.get(0))) continue;
                linkedHashSet.add(arrayList.get(0));
                continue;
            }
            n3 = Integer.MAX_VALUE;
            n7 = -1;
            n2 = object[0] == true || object[0] == n || object[1] == true || object[1] == n ? 1 : 0;
            for (int i = 0; i < n6; ++i) {
                nArray3 = (int[])arrayList.get(i);
                int n10 = nArray3[0];
                int n11 = nArray3[1];
                int n12 = nArray3[0] == 1 || nArray3[0] == n || nArray3[1] == 1 || nArray3[1] == n ? 1 : 0;
                int n13 = 0;
                if (n2 != n12) {
                    n13 = 2;
                }
                for (int j = 0; j < 2; ++j) {
                    reference var21_26 = object[j] - nArray3[j];
                    n13 += var21_26 * var21_26;
                }
                if (n13 == 1) {
                    Integer n14 = (Integer)hashMap.get(nArray3);
                    if (n14 != null) {
                        n13 += n14.intValue();
                        hashMap.put(nArray3, n14 + 1);
                    } else {
                        hashMap.put(nArray3, n5);
                    }
                } else {
                    ++n8;
                }
                if (n13 >= n3) continue;
                n7 = i;
                n3 = n13;
            }
            nArray2 = (int[])arrayList.get(n7);
            if (!n5.equals(hashMap.get(nArray2))) continue;
            hashMap.remove(nArray2);
        }
        n6 = linkedHashSet.size();
        if (n6 < 3) {
            return (int[][])linkedHashSet.toArray((T[])new int[0][]);
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        object = linkedHashSet.iterator();
        arrayList2.add(object.next());
        arrayList2.add(object.next());
        n4 = 1;
        while (object.hasNext()) {
            int[] nArray4 = (int[])object.next();
            n3 = nArray4[0];
            n2 = nArray4[1];
            nArray2 = (int[])arrayList2.get(n4);
            nArray3 = (int[])arrayList2.get(n4 - 1);
            if (n3 == nArray2[0] && n3 == nArray3[0]) {
                arrayList2.set(n4, nArray4);
                continue;
            }
            if (n2 == nArray2[1] && n2 == nArray3[1]) {
                arrayList2.set(n4, nArray4);
                continue;
            }
            arrayList2.add(nArray4);
            ++n4;
        }
        arrayList2.add(arrayList2.get(0));
        return (int[][])arrayList2.toArray((T[])new int[0][]);
    }

    public static String toString(double[] dArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < dArray.length; ++i) {
            stringBuilder.append(Numeric.encodeRounded(dArray[i], n));
            if (i >= dArray.length - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public static String toString(double[] dArray) {
        return Separatrix.toString(dArray, dfltDecimalPlaces);
    }

    public static String toString(double d) {
        if (Double.isNaN(d)) {
            return "nan";
        }
        return (String)Numeric.encodeRounded(d, dfltDecimalPlaces);
    }

    public static int[] matrixToVector(int n, int[][] nArray) {
        int[] nArray2 = new int[n * n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray2[n2++] = nArray[j][i];
            }
        }
        return nArray2;
    }

    public static int[][] ind2Sub(int n, int[] nArray) {
        int n2 = nArray.length;
        int[][] nArray2 = new int[n2][2];
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            int n4 = n3 % n;
            if (n4 == 0) {
                nArray2[i][1] = n3 / n;
                nArray2[i][0] = n;
                continue;
            }
            nArray2[i][1] = n3 / n + 1;
            nArray2[i][0] = n4;
        }
        return nArray2;
    }

    @Override
    public void run() {
        this.compute(this.numberOfTopScoresToKeep);
        this.latch.countDown();
    }

    class ContiguityChecker {
        int[] clues;
        int N1;
        final TreeSet<Integer> alreadyDone = new TreeSet();

        ContiguityChecker() {
        }

        boolean isContiguous(int[] nArray) {
            if (nArray.length == 1) {
                return true;
            }
            this.clues = nArray;
            this.N1 = nArray.length;
            int n = nArray[0];
            for (int i = 1; i < nArray.length; ++i) {
                this.alreadyDone.clear();
                int n2 = nArray[i];
                this.alreadyDone.add(n2);
                if (this.isContiguous(n, n2)) continue;
                return false;
            }
            return true;
        }

        boolean isContiguous(int n, int n2) {
            if (Separatrix.this.clueDistances[n - 1][n2 - 1] <= 1.0) {
                return true;
            }
            this.alreadyDone.add(n);
            if (this.N1 - this.alreadyDone.size() < 1) {
                return false;
            }
            for (int i = 0; i < this.N1; ++i) {
                int n3 = this.clues[i];
                if (!(Separatrix.this.clueDistances[n - 1][n3 - 1] <= 1.0) || this.alreadyDone.contains(n3) || !this.isContiguous(n3, n2)) continue;
                return true;
            }
            return false;
        }
    }

    public class Polygon {
        public final int[] clues;
        public final int[][] edgeXy;
        public final int[][] part1Xy;
        final int[] edgeInds;
        final int[] part1Ind;
        final Border border;
        final GridBoundary gb;

        public int[][] simplify(int[][] nArray, double d) {
            ArrayList<int[]> arrayList = CurveSimplifier.Run(nArray, d);
            return (int[][])arrayList.toArray((T[])new int[0][]);
        }

        Polygon(int[] nArray, double d) {
            this.clues = nArray;
            this.part1Ind = Separatrix.this.get1stPartInds(nArray);
            this.part1Xy = Separatrix.ind2Sub(Separatrix.this.M, this.part1Ind);
            this.edgeInds = Separatrix.this.findEdges(this.part1Ind, 2);
            this.edgeXy = Separatrix.ind2Sub(Separatrix.this.M, this.edgeInds);
            this.border = new Border(this.edgeXy);
            this.gb = new GridBoundary(this.part1Xy, this.edgeXy, Separatrix.this.M);
            this.gb.compute(this.border, d);
        }

        public boolean isGood() {
            return this.gb.isTruePolygon;
        }

        public void print(PrintStream printStream) {
            printStream.print("For clues:  [");
            for (int i = 0; i < this.clues.length; ++i) {
                printStream.print(this.clues[i]);
                if (i >= this.clues.length - 1) continue;
                printStream.print(",");
            }
            printStream.println("]");
            Basics.print(printStream, "xySplit=", this.edgeXy);
            Basics.print(printStream, "border edge=", this.border.edge);
            if (this.gb.isTruePolygon) {
                Basics.print(printStream, "polygonForPart1=", this.getPoints(true));
                printStream.println("Sptx.TestPolygon2(polygonForPart1, " + Separatrix.this.M + ")");
                Basics.print(printStream, "polygonForPart2=", this.getPoints(false));
                printStream.println("Sptx.TestPolygon2(polygonForPart2, " + Separatrix.this.M + ")");
            } else {
                Basics.print(printStream, "badPoly=", (int[][])this.gb.line.toArray((T[])new int[0][]));
                printStream.println("Sptx.TestPolygon2(badPoly, " + Separatrix.this.M + ")");
            }
            printStream.println();
        }

        public void print() {
            this.print(System.out);
        }

        public int[][] getPoints(boolean bl) {
            return this.gb.getPolygon(bl);
        }
    }

    static class GridBoundary {
        boolean isTruePolygon = false;
        final int meanX;
        final int meanY;
        final boolean[][] shouldDraw;
        final int[][] part1Xy;
        final int N;
        final int M;
        final int[][][][] directNeighbors;
        final int[][][][] indirectNeighbors;
        static final int[][] empty = new int[0][];
        final int[] closestToOrigin = new int[]{1, 1};
        ArrayList<int[]> line = new ArrayList();
        final ArrayList<int[]> part1Polygon = new ArrayList();
        final ArrayList<int[]> part2Polygon = new ArrayList();
        static final int NONE = 0;
        static final int LEFT = 1;
        static final int TOP = 2;
        static final int RIGHT = 3;
        static final int BOTTOM = 4;

        private void compute(Border border, double d) {
            if (this.line.size() == 0) {
                this.draw(border, d);
            }
        }

        GridBoundary(int[][] nArray, int[][] nArray2, int n) {
            this.part1Xy = nArray;
            this.meanX = (int)Math.round(Basics.mean(nArray, 0));
            this.meanY = (int)Math.round(Basics.mean(nArray, 1));
            this.N = nArray2.length;
            this.M = n;
            this.shouldDraw = new boolean[n + 1][n + 1];
            for (int i = 0; i < this.N; ++i) {
                this.shouldDraw[nArray2[i][0]][nArray2[i][1]] = true;
            }
            this.directNeighbors = new int[n + 1][n + 1][][];
            this.indirectNeighbors = new int[n + 1][n + 1][][];
            ArrayList<int[]> arrayList = new ArrayList<int[]>();
            ArrayList<int[]> arrayList2 = new ArrayList<int[]>();
            int n2 = Integer.MAX_VALUE;
            for (int i = 0; i < this.N; ++i) {
                arrayList.clear();
                arrayList2.clear();
                int n3 = nArray2[i][0];
                int n4 = nArray2[i][1];
                if (n3 + n4 < n2) {
                    n2 = n3 + n4;
                    this.closestToOrigin[0] = n3;
                    this.closestToOrigin[1] = n4;
                }
                Range range = new Range(n3);
                Range range2 = new Range(n4);
                for (int j = range.start; j < range.end; ++j) {
                    for (int k = range2.start; k < range2.end; ++k) {
                        int n5;
                        int n6;
                        if (k == 0 && j == 0 || !this.shouldDraw[n6 = n3 + j][n5 = n4 + k]) continue;
                        if (k == 0 || j == 0) {
                            arrayList.add(new int[]{n6, n5});
                            continue;
                        }
                        arrayList2.add(new int[]{n6, n5});
                    }
                }
                int[][] nArray3 = (int[][])arrayList.toArray((T[])empty);
                this.directNeighbors[n3][n4] = nArray3;
                nArray3 = (int[][])arrayList2.toArray((T[])empty);
                this.indirectNeighbors[n3][n4] = nArray3;
            }
        }

        int[] setDrawn(int[] nArray) {
            if (nArray != null) {
                this.shouldDraw[nArray[0]][nArray[1]] = false;
                this.line.add(nArray);
            }
            return nArray;
        }

        private void draw(Border border, double d) {
            int[] nArray = null;
            nArray = border == null || border.edge == null || border.edge.length == 0 ? this.setDrawn(this.closestToOrigin) : this.setDrawn(border.edge[0]);
            while (nArray != null) {
                int[] nArray2 = this.nextPoint(true, this.directNeighbors, nArray);
                if (nArray2 == null) {
                    nArray2 = this.nextPoint(false, this.indirectNeighbors, nArray);
                }
                nArray = this.setDrawn(nArray2);
            }
            this.line = CurveSimplifier.Run(this.line, d);
            this.isTruePolygon = this.addPolygonPointsForPart1(this.part1Polygon);
            if (this.isTruePolygon) {
                this.addPolygonPointsForPart2(this.part2Polygon);
            }
        }

        int[][] getPolygon(boolean bl) {
            if (this.isTruePolygon) {
                ArrayList<int[]> arrayList = new ArrayList<int[]>(this.line);
                if (bl) {
                    arrayList.addAll(this.part1Polygon);
                } else {
                    arrayList.addAll(this.part2Polygon);
                }
                return (int[][])arrayList.toArray((T[])empty);
            }
            return null;
        }

        int[] nextPoint(boolean bl, int[][][][] nArray, int[] nArray2) {
            int[] nArray3 = null;
            int n = nArray2[0];
            int n2 = nArray2[1];
            int n3 = Integer.MAX_VALUE;
            int n4 = 0;
            Range range = new Range(n);
            Range range2 = new Range(n2);
            for (int i = range.start; i < range.end; ++i) {
                for (int j = range2.start; j < range2.end; ++j) {
                    int n5;
                    int n6;
                    int n7;
                    boolean bl2;
                    if (j == 0 && i == 0) continue;
                    if (j == 0 || i == 0) {
                        bl2 = bl;
                    } else {
                        boolean bl3 = bl2 = !bl;
                    }
                    if (!bl2 || !this.shouldDraw[n7 = n + i][n6 = n2 + j] || (n5 = this.countUndrawnNeighbors(bl, nArray, n7, n6)) > n3) continue;
                    boolean bl4 = true;
                    int n8 = (n7 - this.meanX) * (n7 - this.meanX) + (n6 - this.meanY) * (n6 - this.meanY);
                    if (n5 == n3) {
                        int n9;
                        int n10;
                        if (n8 < n4) {
                            bl4 = false;
                        } else if (nArray3 != null && (n10 = this.countUndrawnNeighbors(bl, nArray, n7, n6, n7 - n, n6 - n2, n - nArray3[0], n2 - nArray3[1])) > (n9 = this.countUndrawnNeighbors(bl, nArray, nArray3[0], nArray3[1], nArray3[0] - n, nArray3[1] - n2, n - n7, n2 - n6))) {
                            bl4 = false;
                        }
                    }
                    if (!bl4) continue;
                    nArray3 = new int[]{n7, n6};
                    n4 = n8;
                    n3 = n5;
                }
            }
            return nArray3;
        }

        int countUndrawnNeighbors(boolean bl, int n, int n2) {
            int n3 = 0;
            Range range = new Range(n);
            Range range2 = new Range(n2);
            for (int i = range.start; i < range.end; ++i) {
                for (int j = range2.start; j < range2.end; ++j) {
                    int n4;
                    int n5;
                    if (j == 0 && i == 0 || !this.shouldDraw[n5 = n + i][n4 = n2 + j]) continue;
                    if (j == 0 || i == 0) {
                        if (!bl) continue;
                        ++n3;
                        continue;
                    }
                    if (bl) continue;
                    ++n3;
                }
            }
            return n3;
        }

        boolean isInsideBoundary(int n, int n2) {
            int n3 = this.part1Xy.length;
            for (int i = 0; i < n3; ++i) {
                if (this.part1Xy[i][0] != n || this.part1Xy[i][1] != n2) continue;
                return true;
            }
            return false;
        }

        int countUndrawnNeighbors(boolean bl, int[][][][] nArray, int n, int n2) {
            int[][] nArray2 = nArray[n][n2];
            if (nArray2 != null) {
                int n3 = 0;
                for (int i = 0; i < nArray2.length; ++i) {
                    if (!this.shouldDraw[nArray2[i][0]][nArray2[i][1]]) continue;
                    ++n3;
                }
                return n3;
            }
            if (this.isInsideBoundary(n, n2)) {
                return this.countUndrawnNeighbors(bl, n, n2);
            }
            return 0;
        }

        int countUndrawnNeighbors(boolean bl, int[][][][] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
            return this.countUndrawnNeighbors(bl, nArray, n, n2, n3, n4) + this.countUndrawnNeighbors(bl, nArray, n, n2, n5, n6);
        }

        int countUndrawnNeighbors(boolean bl, int[][][][] nArray, int n, int n2, int n3, int n4) {
            int n5 = n + n3;
            if (n5 < 1 || n5 > this.M) {
                return 0;
            }
            int n6 = n2 + n4;
            if (n6 < 1 || n6 > this.M) {
                return 0;
            }
            return this.countUndrawnNeighbors(bl, nArray, n5, n6);
        }

        static ArrayList<int[]> smoothen(ArrayList<int[]> arrayList) {
            ArrayList<int[]> arrayList2 = new ArrayList<int[]>();
            Iterator<int[]> iterator = arrayList.iterator();
            arrayList2.add(iterator.next());
            arrayList2.add(iterator.next());
            int n = 1;
            while (iterator.hasNext()) {
                int[] nArray = iterator.next();
                int n2 = nArray[0];
                int n3 = nArray[1];
                int[] nArray2 = arrayList2.get(n);
                int[] nArray3 = arrayList2.get(n - 1);
                if (n2 == nArray2[0] && n2 == nArray3[0]) {
                    arrayList2.set(n, nArray);
                    continue;
                }
                if (n3 == nArray2[1] && n3 == nArray3[1]) {
                    arrayList2.set(n, nArray);
                    continue;
                }
                arrayList2.add(nArray);
                ++n;
            }
            return arrayList2;
        }

        int getSide(int[] nArray) {
            if (nArray[1] == 1) {
                return 1;
            }
            if (nArray[0] == this.M) {
                return 2;
            }
            if (nArray[0] == 1) {
                return 4;
            }
            if (nArray[1] == this.M) {
                return 3;
            }
            return 0;
        }

        boolean addPolygonPointsForPart1(ArrayList<int[]> arrayList) {
            int[] nArray = this.line.get(0);
            int[] nArray2 = this.line.get(this.line.size() - 1);
            int n = this.getSide(nArray);
            int n2 = this.getSide(nArray2);
            if (n == 0 || n2 == 0) {
                return false;
            }
            int[] nArray3 = new int[]{this.M, 1};
            int[] nArray4 = new int[]{this.M, this.M};
            int[] nArray5 = new int[]{1, 1};
            int[] nArray6 = new int[]{1, this.M};
            if (n != n2) {
                if (n == 1 && n2 == 4 || n == 4 && n2 == 1) {
                    arrayList.add(nArray5);
                } else if (n == 1 && n2 == 2 || n == 2 && n2 == 1) {
                    arrayList.add(nArray3);
                } else if (n == 4 && n2 == 2) {
                    arrayList.add(nArray3);
                    arrayList.add(nArray5);
                } else if (n == 2 && n2 == 4) {
                    arrayList.add(nArray5);
                    arrayList.add(nArray3);
                } else if (n == 4 && n2 == 3 || n == 3 && n2 == 4) {
                    arrayList.add(nArray6);
                } else if (n == 1 && n2 == 3) {
                    arrayList.add(nArray4);
                    arrayList.add(nArray3);
                } else if (n == 3 && n2 == 1) {
                    arrayList.add(nArray3);
                    arrayList.add(nArray4);
                } else {
                    arrayList.add(nArray4);
                }
            }
            arrayList.add(nArray);
            return true;
        }

        boolean addPolygonPointsForPart2(ArrayList<int[]> arrayList) {
            int[] nArray = this.line.get(0);
            int[] nArray2 = this.line.get(this.line.size() - 1);
            int n = this.getSide(nArray);
            int n2 = this.getSide(nArray2);
            if (n == 0 || n2 == 0) {
                return false;
            }
            int[] nArray3 = new int[]{this.M, 1};
            int[] nArray4 = new int[]{this.M, this.M};
            int[] nArray5 = new int[]{1, 1};
            int[] nArray6 = new int[]{1, this.M};
            if (n == n2) {
                if (n == 1) {
                    if (nArray[0] < nArray2[0]) {
                        arrayList.add(nArray3);
                        arrayList.add(nArray4);
                        arrayList.add(nArray6);
                        arrayList.add(nArray5);
                    } else {
                        arrayList.add(nArray5);
                        arrayList.add(nArray6);
                        arrayList.add(nArray4);
                        arrayList.add(nArray3);
                    }
                } else if (n == 2) {
                    if (nArray[1] < nArray2[1]) {
                        arrayList.add(nArray4);
                        arrayList.add(nArray6);
                        arrayList.add(nArray5);
                        arrayList.add(nArray3);
                    } else {
                        arrayList.add(nArray3);
                        arrayList.add(nArray5);
                        arrayList.add(nArray6);
                        arrayList.add(nArray4);
                    }
                } else if (n == 4) {
                    if (nArray[1] < nArray2[1]) {
                        arrayList.add(nArray6);
                        arrayList.add(nArray4);
                        arrayList.add(nArray3);
                        arrayList.add(nArray5);
                    } else {
                        arrayList.add(nArray5);
                        arrayList.add(nArray3);
                        arrayList.add(nArray4);
                        arrayList.add(nArray6);
                    }
                } else if (nArray[0] < nArray2[0]) {
                    arrayList.add(nArray4);
                    arrayList.add(nArray3);
                    arrayList.add(nArray5);
                    arrayList.add(nArray6);
                } else {
                    arrayList.add(nArray6);
                    arrayList.add(nArray5);
                    arrayList.add(nArray3);
                    arrayList.add(nArray4);
                }
            } else if (n == 1 && n2 == 4) {
                arrayList.add(nArray6);
                arrayList.add(nArray4);
                arrayList.add(nArray3);
            } else if (n == 4 && n2 == 1) {
                arrayList.add(nArray3);
                arrayList.add(nArray4);
                arrayList.add(nArray6);
            } else if (n == 1 && n2 == 2) {
                arrayList.add(nArray4);
                arrayList.add(nArray6);
                arrayList.add(nArray5);
            } else if (n == 2 && n2 == 1) {
                arrayList.add(nArray5);
                arrayList.add(nArray6);
                arrayList.add(nArray4);
            } else if (n == 4 && n2 == 2) {
                arrayList.add(nArray4);
                arrayList.add(nArray6);
            } else if (n == 2 && n2 == 4) {
                arrayList.add(nArray6);
                arrayList.add(nArray4);
            } else if (n == 4 && n2 == 3) {
                arrayList.add(nArray4);
                arrayList.add(nArray3);
                arrayList.add(nArray5);
            } else if (n == 3 && n2 == 4) {
                arrayList.add(nArray5);
                arrayList.add(nArray3);
                arrayList.add(nArray4);
            } else if (n == 1 && n2 == 3) {
                arrayList.add(nArray6);
                arrayList.add(nArray5);
            } else if (n == 3 && n2 == 1) {
                arrayList.add(nArray5);
                arrayList.add(nArray6);
            } else if (n == 2 && n2 == 3) {
                arrayList.add(nArray6);
                arrayList.add(nArray5);
                arrayList.add(nArray3);
            } else if (n == 3 && n2 == 2) {
                arrayList.add(nArray3);
                arrayList.add(nArray5);
                arrayList.add(nArray6);
            }
            arrayList.add(nArray);
            return true;
        }

        class Range {
            final int start;
            final int end;

            Range(int n) {
                if (n <= 1) {
                    this.start = 0;
                    this.end = 2;
                } else if (n == GridBoundary.this.M) {
                    this.start = -1;
                    this.end = 1;
                } else {
                    this.start = -1;
                    this.end = 2;
                }
            }
        }
    }

    public class Border {
        public int[] least = new int[4];
        public int[] most = new int[4];
        public final ArrayList<int[]> c = new ArrayList();
        public final int[][] edge;

        Border(int[][] nArray) {
            for (int i = 0; i < 4; ++i) {
                this.least[i] = Separatrix.this.M + 1;
            }
            this.ranges(nArray);
            this.edge = this.add();
        }

        void ranges(int[][] nArray) {
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = nArray[i][0];
                int n3 = nArray[i][1];
                if (n2 == 1) {
                    this.range(0, n3);
                    continue;
                }
                if (n3 == Separatrix.this.M) {
                    this.range(1, n2);
                    continue;
                }
                if (n2 == Separatrix.this.M) {
                    this.range(2, n3);
                    continue;
                }
                if (n3 != 1) continue;
                this.range(3, n2);
            }
        }

        void range(int n, int n2) {
            if (n2 < this.least[n]) {
                this.least[n] = n2;
            }
            if (n2 > this.most[n]) {
                this.most[n] = n2;
            }
        }

        int[][] add() {
            this.add(0, 1, 0, 1);
            this.add(1, Separatrix.this.M, 1, 0);
            this.add(2, Separatrix.this.M, 0, 1);
            this.add(3, 1, 1, 0);
            return (int[][])this.c.toArray((T[])new int[0][]);
        }

        void add(int n, int n2, int n3, int n4) {
            if (this.least[n] < Separatrix.this.M + 1) {
                int[] nArray = new int[2];
                nArray[n3] = n2;
                nArray[n4] = this.least[n];
                this.c.add(nArray);
                if (this.most[n] != this.least[n]) {
                    nArray = new int[2];
                    nArray[n3] = n2;
                    nArray[n4] = this.most[n];
                    this.c.add(nArray);
                }
            }
        }

        boolean needToDelete(int[] nArray) {
            if (nArray[0] == 1 || nArray[0] == Separatrix.this.M || nArray[1] == 1 || nArray[1] == Separatrix.this.M) {
                for (int i = 0; i < this.edge.length; ++i) {
                    if (this.edge[i][0] != nArray[0] || this.edge[i][1] != nArray[1]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

