/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

import edu.stanford.facs.swing.CpuInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class StochasticGradientDescent {
    private static boolean DEBUGGING = false;
    private static int debugPrintLimit = 15;
    private static int[] debugWatch = new int[]{0, 1999};
    private boolean doDebug = false;
    private int debugPrints = 0;
    private int computes = 0;
    private final int COMPUTE1 = 2;
    private final int COMPUTE2 = 5;
    public final int n_components;
    public double[][] head_embedding;
    public double[][] tail_embedding;
    private final int[] head;
    private final int[] tail;
    private final int n_epochs;
    private final int n_vertices;
    private final double[] epochs_per_sample;
    private final double a;
    private final double b;
    private final double initial_alpha;
    public boolean move_other;
    public boolean[] move_point;
    private double alpha;
    private final double BG2S;
    private final double ABNEG2;
    private final double BNEG1;
    private Random r;
    private final int n_1_simplices;
    private final double[] epochs_per_negative_sample;
    private final double[] epoch_of_next_negative_sample;
    private final double[] epoch_of_next_sample;
    private double nTh;
    private int n_epoch;
    boolean testJavaPointerToArray = true;
    static final boolean DEBUG_RANDI = false;
    static final boolean DEBUG_STATIC_AND_INSTANCE = false;

    private static boolean IsDebugIdx(int n) {
        for (int i = 0; i < debugWatch.length; ++i) {
            if (debugWatch[i] != n) continue;
            return true;
        }
        return false;
    }

    private static void debug() {
        StochasticGradientDescent stochasticGradientDescent = StochasticGradientDescent.getInstance(StochasticGradientDescent.class.getResourceAsStream("sgdInput.txt"));
        stochasticGradientDescent.debugHeadTail1stLast(true);
        while (!stochasticGradientDescent.nextEpochs(null) && !DEBUGGING) {
            System.out.printf("%d/%d epochs\n", stochasticGradientDescent.n_epoch, stochasticGradientDescent.n_epochs);
            stochasticGradientDescent.debugHeadTail1stLast(stochasticGradientDescent.move_other);
        }
        stochasticGradientDescent.debugHeadTail1stLast(stochasticGradientDescent.move_other);
        System.out.println(stochasticGradientDescent.n_components);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stochasticGradientDescent.head_embedding.length; ++i) {
            stringBuilder.append(stochasticGradientDescent.head_embedding[i][0]);
            stringBuilder.append(", ");
            stringBuilder.append(stochasticGradientDescent.head_embedding[i][1]);
            stringBuilder.append("\n");
        }
        CpuInfo.saveTextFile("/Users/swmeehan/umap.txt", stringBuilder.toString());
    }

    private void debugHeadTail1stLast(boolean bl) {
        System.out.printf("%d/%d epochs:\thead 1st/end [%f %f]/[%f %f]\n", this.n_epoch, this.n_epochs, this.head_embedding[0][0], this.head_embedding[0][1], this.head_embedding[this.head_embedding.length - 1][0], this.head_embedding[this.head_embedding.length - 1][1]);
        if (!bl) {
            System.out.printf("\t\ttail 1st/end [%f %f]/[%f %f]\n", this.tail_embedding[0][0], this.tail_embedding[0][1], this.tail_embedding[this.tail_embedding.length - 1][0], this.tail_embedding[this.tail_embedding.length - 1][1]);
        }
    }

    public static void main(String[] stringArray) {
        StochasticGradientDescent.debug();
    }

    public static StochasticGradientDescent getInstance(String string) {
        File file = new File(string);
        if (!file.exists() || !file.isFile()) {
            System.out.println(string + " does not exist or not a file");
            return null;
        }
        try {
            return StochasticGradientDescent.getInstance(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StochasticGradientDescent getInstance(InputStream inputStream) {
        BufferedReader bufferedReader = null;
        try {
            int n;
            int n2;
            int n3;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            int n4 = Integer.parseInt(bufferedReader.readLine());
            int n5 = Integer.parseInt(bufferedReader.readLine());
            double[][] dArray = new double[n5][n4];
            for (int i = 0; i < n5; ++i) {
                for (n3 = 0; n3 < n4; ++n3) {
                    dArray[i][n3] = Double.parseDouble(bufferedReader.readLine());
                }
            }
            n5 = Integer.parseInt(bufferedReader.readLine());
            double[][] dArray2 = new double[n5][n4];
            if (n5 > 0) {
                for (n3 = 0; n3 < n5; ++n3) {
                    for (n2 = 0; n2 < n4; ++n2) {
                        dArray2[n3][n2] = Double.parseDouble(bufferedReader.readLine());
                    }
                }
            }
            n5 = Integer.parseInt(bufferedReader.readLine());
            int[] nArray = new int[n5];
            for (n2 = 0; n2 < n5; ++n2) {
                nArray[n2] = Integer.parseInt(bufferedReader.readLine());
            }
            n5 = Integer.parseInt(bufferedReader.readLine());
            int[] nArray2 = new int[n5];
            for (n = 0; n < n5; ++n) {
                nArray2[n] = Integer.parseInt(bufferedReader.readLine());
            }
            n5 = Integer.parseInt(bufferedReader.readLine());
            n = Integer.parseInt(bufferedReader.readLine());
            n5 = Integer.parseInt(bufferedReader.readLine());
            int n6 = Integer.parseInt(bufferedReader.readLine());
            n5 = Integer.parseInt(bufferedReader.readLine());
            double[] dArray3 = new double[n5];
            for (int i = 0; i < n5; ++i) {
                dArray3[i] = Double.parseDouble(bufferedReader.readLine());
            }
            n5 = Integer.parseInt(bufferedReader.readLine());
            double d = Double.parseDouble(bufferedReader.readLine());
            n5 = Integer.parseInt(bufferedReader.readLine());
            double d2 = Double.parseDouble(bufferedReader.readLine());
            n5 = Integer.parseInt(bufferedReader.readLine());
            double d3 = Double.parseDouble(bufferedReader.readLine());
            n5 = Integer.parseInt(bufferedReader.readLine());
            double d4 = Double.parseDouble(bufferedReader.readLine());
            n5 = Integer.parseInt(bufferedReader.readLine());
            int n7 = Integer.parseInt(bufferedReader.readLine());
            StochasticGradientDescent stochasticGradientDescent = new StochasticGradientDescent(dArray, dArray2, nArray, nArray2, n, n6, dArray3, d, d2, d3, d4, n7);
            stochasticGradientDescent.move_other = dArray2.length == 0;
            StochasticGradientDescent stochasticGradientDescent2 = stochasticGradientDescent;
            return stochasticGradientDescent2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Double[][] readfile(String string) {
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            String[] stringArray;
            if (string == null) {
                string = "D:\\temp\\sample10k.csv";
            }
            File file = new File(string);
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            bufferedReader = new BufferedReader(inputStreamReader);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            ArrayList<Double[]> arrayList2 = new ArrayList<Double[]>();
            Double[][] doubleArrayArray = new Double[][]{};
            Double[] doubleArray = new Double[]{};
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringArray = string2.split(",");
                try {
                    for (int i = 0; i < stringArray.length; ++i) {
                        arrayList.add(Double.parseDouble(stringArray[i]));
                    }
                    arrayList2.add(arrayList.toArray(doubleArray));
                    arrayList.clear();
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                }
            }
            stringArray = (Double[][])arrayList2.toArray((T[])doubleArrayArray);
            return stringArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return null;
    }

    public void randomize() {
        this.r = new Random();
    }

    public double setReports(double d) {
        this.nTh = (double)this.n_epochs / d;
        return this.nTh;
    }

    public double getReports() {
        return this.nTh;
    }

    public StochasticGradientDescent(double[][] dArray, double[][] dArray2, int[] nArray, int[] nArray2, int n, int n2, double[] dArray3, double d, double d2, double d3, double d4, int n3) {
        this.head_embedding = dArray;
        this.tail_embedding = dArray2;
        this.head = nArray;
        this.tail = nArray2;
        this.n_epochs = n;
        this.n_vertices = n2;
        this.epochs_per_sample = dArray3;
        this.a = d;
        this.b = d2;
        this.initial_alpha = d4;
        this.n_components = dArray.length > 0 ? dArray[0].length : 0;
        this.move_other = dArray.length == dArray2.length;
        this.alpha = d4;
        this.BG2S = 2.0 * d3 * d2;
        this.ABNEG2 = -2.0 * d * d2;
        this.BNEG1 = d2 - 1.0;
        this.r = new Random(503L);
        this.n_1_simplices = dArray3.length;
        this.epochs_per_negative_sample = new double[dArray3.length];
        for (int i = 0; i < this.n_1_simplices; ++i) {
            this.epochs_per_negative_sample[i] = dArray3[i] / (double)n3;
        }
        this.epoch_of_next_negative_sample = Arrays.copyOf(this.epochs_per_negative_sample, this.n_1_simplices);
        this.epoch_of_next_sample = Arrays.copyOf(dArray3, this.n_1_simplices);
        this.nTh = (double)n / (double)StochasticGradientDescent.EPOCH_REPORTS();
        this.n_epoch = 1;
    }

    public int getEpochsDone() {
        return this.n_epoch;
    }

    public int getEpochsToDo() {
        return this.n_epochs;
    }

    public boolean nextEpochs() {
        if (this.move_other) {
            return this.nextEpochsMoveOther();
        }
        if (this.move_point == null) {
            return this.nextEpochsNotMoveOther();
        }
        return this.nextEpochsMovePoint();
    }

    public boolean nextEpochsMoveOther() {
        int n = this.n_components;
        int n2 = this.n_1_simplices;
        int n3 = this.n_epochs;
        int n4 = this.n_vertices;
        int[] nArray = this.head;
        int[] nArray2 = this.tail;
        double[] dArray = this.epochs_per_sample;
        double d = this.a;
        double d2 = this.b;
        double d3 = this.initial_alpha;
        double d4 = this.BG2S;
        double d5 = this.ABNEG2;
        double d6 = this.BNEG1;
        double[] dArray2 = this.epochs_per_negative_sample;
        double[] dArray3 = this.epoch_of_next_negative_sample;
        double[] dArray4 = this.epoch_of_next_sample;
        boolean bl = false;
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        int n5 = 0;
        double[] dArray7 = new double[n];
        double[] dArray8 = new double[n];
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        this.tail_embedding = this.head_embedding;
        double d10 = this.alpha * 4.0;
        double d11 = this.alpha * -4.0;
        for (int i = this.n_epoch; i <= n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n6;
                if (dArray4[j] > (double)i) continue;
                int n7 = nArray[j] - 1;
                int n8 = nArray2[j] - 1;
                for (n6 = 0; n6 < n; ++n6) {
                    dArray5[n6] = this.head_embedding[n7][n6];
                    dArray6[n6] = this.tail_embedding[n8][n6];
                    dArray8[n6] = dArray5[n6] - dArray6[n6];
                }
                d8 = 0.0;
                for (n6 = 0; n6 < n; ++n6) {
                    d8 += dArray8[n6] * dArray8[n6];
                }
                if (d8 > 0.0) {
                    d7 = d5 * Math.pow(d8, d6) / (d * Math.pow(d8, d2) + 1.0);
                    for (n6 = 0; n6 < n; ++n6) {
                        d9 = d7 * dArray8[n6];
                        dArray7[n6] = d9 >= 4.0 ? d10 : (d9 <= -4.0 ? d11 : d9 * this.alpha);
                        dArray5[n6] = dArray5[n6] + dArray7[n6];
                    }
                    for (n6 = 0; n6 < n; ++n6) {
                        dArray6[n6] = dArray6[n6] - dArray7[n6];
                        this.tail_embedding[n8][n6] = dArray6[n6];
                    }
                } else {
                    for (n6 = 0; n6 < n; ++n6) {
                        dArray7[n6] = 0.0;
                    }
                }
                int n9 = j;
                dArray4[n9] = dArray4[n9] + dArray[j];
                n5 = (int)Math.floor(((double)i - dArray3[j]) / dArray2[j]);
                for (n6 = 0; n6 < n5; ++n6) {
                    int n10;
                    n8 = this.r.nextInt(n4);
                    if (n7 == n8) continue;
                    d8 = 0.0;
                    for (n10 = 0; n10 < n; ++n10) {
                        dArray6[n10] = this.tail_embedding[n8][n10];
                        dArray8[n10] = dArray5[n10] - dArray6[n10];
                        d8 += dArray8[n10] * dArray8[n10];
                    }
                    if (d8 > 0.0) {
                        d7 = d4 / (0.001 + d8) / (d * Math.pow(d8, d2) + 1.0);
                        for (n10 = 0; n10 < n; ++n10) {
                            d9 = d7 * dArray8[n10];
                            dArray7[n10] = d9 >= 4.0 ? d10 : (d9 <= -4.0 ? d11 : d9 * this.alpha);
                        }
                    } else {
                        for (n10 = 0; n10 < n; ++n10) {
                            dArray7[n10] = 4.0;
                        }
                    }
                    for (n10 = 0; n10 < n; ++n10) {
                        dArray5[n10] = dArray5[n10] + dArray7[n10];
                    }
                }
                for (n6 = 0; n6 < n; ++n6) {
                    this.head_embedding[n7][n6] = dArray5[n6];
                }
                int n11 = j;
                dArray3[n11] = dArray3[n11] + (double)n5 * dArray2[j];
            }
            this.alpha = d3 * (1.0 - (double)i / (double)n3);
            d10 = this.alpha * 4.0;
            d11 = this.alpha * -4.0;
            if (Math.floor((double)i % this.nTh) != 0.0) continue;
            this.n_epoch = i + 1;
            return this.n_epoch >= this.n_epochs;
        }
        return true;
    }

    public boolean nextEpochsNotMoveOther() {
        int n = this.n_components;
        int n2 = this.n_1_simplices;
        int n3 = this.n_epochs;
        int n4 = this.n_vertices;
        int[] nArray = this.head;
        int[] nArray2 = this.tail;
        double[] dArray = this.epochs_per_sample;
        double d = this.a;
        double d2 = this.b;
        double d3 = this.initial_alpha;
        double d4 = this.BG2S;
        double d5 = this.ABNEG2;
        double d6 = this.BNEG1;
        double[] dArray2 = this.epochs_per_negative_sample;
        double[] dArray3 = this.epoch_of_next_negative_sample;
        double[] dArray4 = this.epoch_of_next_sample;
        boolean bl = false;
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        int n5 = 0;
        double[] dArray7 = new double[n];
        double[] dArray8 = new double[n];
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = this.alpha * 4.0;
        double d11 = this.alpha * -4.0;
        for (int i = this.n_epoch; i <= n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n6;
                if (dArray4[j] > (double)i) continue;
                int n7 = nArray[j] - 1;
                int n8 = nArray2[j] - 1;
                for (n6 = 0; n6 < n; ++n6) {
                    dArray5[n6] = this.head_embedding[n7][n6];
                    dArray6[n6] = this.tail_embedding[n8][n6];
                    dArray8[n6] = dArray5[n6] - dArray6[n6];
                }
                d8 = 0.0;
                for (n6 = 0; n6 < n; ++n6) {
                    d8 += dArray8[n6] * dArray8[n6];
                }
                if (d8 > 0.0) {
                    d7 = d5 * Math.pow(d8, d6) / (d * Math.pow(d8, d2) + 1.0);
                    for (n6 = 0; n6 < n; ++n6) {
                        d9 = d7 * dArray8[n6];
                        dArray7[n6] = d9 >= 4.0 ? d10 : (d9 <= -4.0 ? d11 : d9 * this.alpha);
                        dArray5[n6] = dArray5[n6] + dArray7[n6];
                    }
                } else {
                    for (n6 = 0; n6 < n; ++n6) {
                        dArray7[n6] = 0.0;
                    }
                }
                int n9 = j;
                dArray4[n9] = dArray4[n9] + dArray[j];
                n5 = (int)Math.floor(((double)i - dArray3[j]) / dArray2[j]);
                for (n6 = 0; n6 < n5; ++n6) {
                    int n10;
                    n8 = this.r.nextInt(n4);
                    d8 = 0.0;
                    for (n10 = 0; n10 < n; ++n10) {
                        dArray6[n10] = this.tail_embedding[n8][n10];
                        dArray8[n10] = dArray5[n10] - dArray6[n10];
                        d8 += dArray8[n10] * dArray8[n10];
                    }
                    if (d8 > 0.0) {
                        d7 = d4 / (0.001 + d8) / (d * Math.pow(d8, d2) + 1.0);
                        for (n10 = 0; n10 < n; ++n10) {
                            d9 = d7 * dArray8[n10];
                            dArray7[n10] = d9 >= 4.0 ? d10 : (d9 <= -4.0 ? d11 : d9 * this.alpha);
                        }
                    } else {
                        for (n10 = 0; n10 < n; ++n10) {
                            dArray7[n10] = 4.0;
                        }
                    }
                    for (n10 = 0; n10 < n; ++n10) {
                        dArray5[n10] = dArray5[n10] + dArray7[n10];
                    }
                }
                for (n6 = 0; n6 < n; ++n6) {
                    this.head_embedding[n7][n6] = dArray5[n6];
                }
                int n11 = j;
                dArray3[n11] = dArray3[n11] + (double)n5 * dArray2[j];
            }
            this.alpha = d3 * (1.0 - (double)i / (double)n3);
            d10 = this.alpha * 4.0;
            d11 = this.alpha * -4.0;
            if (Math.floor((double)i % this.nTh) != 0.0) continue;
            this.n_epoch = i + 1;
            return this.n_epoch >= this.n_epochs;
        }
        return true;
    }

    public boolean nextEpochsMovePoint() {
        boolean[] blArray = this.move_point;
        int n = this.n_components;
        int n2 = this.n_1_simplices;
        int n3 = this.n_epochs;
        int n4 = this.n_vertices;
        int[] nArray = this.head;
        int[] nArray2 = this.tail;
        double[] dArray = this.epochs_per_sample;
        double d = this.a;
        double d2 = this.b;
        double d3 = this.initial_alpha;
        double d4 = this.BG2S;
        double d5 = this.ABNEG2;
        double d6 = this.BNEG1;
        double[] dArray2 = this.epochs_per_negative_sample;
        double[] dArray3 = this.epoch_of_next_negative_sample;
        double[] dArray4 = this.epoch_of_next_sample;
        boolean bl = false;
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        int n5 = 0;
        double[] dArray7 = new double[n];
        double[] dArray8 = new double[n];
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = this.alpha * 4.0;
        double d11 = this.alpha * -4.0;
        for (int i = this.n_epoch; i <= n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n6;
                if (dArray4[j] > (double)i) continue;
                int n7 = nArray[j] - 1;
                int n8 = nArray2[j] - 1;
                for (n6 = 0; n6 < n; ++n6) {
                    dArray5[n6] = this.head_embedding[n7][n6];
                    dArray6[n6] = this.tail_embedding[n8][n6];
                    dArray8[n6] = dArray5[n6] - dArray6[n6];
                }
                d8 = 0.0;
                for (n6 = 0; n6 < n; ++n6) {
                    d8 += dArray8[n6] * dArray8[n6];
                }
                if (d8 > 0.0) {
                    d7 = d5 * Math.pow(d8, d6) / (d * Math.pow(d8, d2) + 1.0);
                    for (n6 = 0; n6 < n; ++n6) {
                        d9 = d7 * dArray8[n6];
                        dArray7[n6] = d9 >= 4.0 ? d10 : (d9 <= -4.0 ? d11 : d9 * this.alpha);
                        dArray5[n6] = dArray5[n6] + dArray7[n6];
                    }
                    if (blArray[n8]) {
                        for (n6 = 0; n6 < n; ++n6) {
                            dArray6[n6] = dArray6[n6] - dArray7[n6];
                            this.head_embedding[n8][n6] = dArray6[n6];
                            this.tail_embedding[n8][n6] = dArray6[n6];
                        }
                    }
                } else {
                    for (n6 = 0; n6 < n; ++n6) {
                        dArray7[n6] = 0.0;
                    }
                }
                int n9 = j;
                dArray4[n9] = dArray4[n9] + dArray[j];
                n5 = (int)Math.floor(((double)i - dArray3[j]) / dArray2[j]);
                for (n6 = 0; n6 < n5; ++n6) {
                    int n10;
                    n8 = this.r.nextInt(n4);
                    if (blArray[n8] && n7 == n8) continue;
                    d8 = 0.0;
                    for (n10 = 0; n10 < n; ++n10) {
                        dArray6[n10] = this.tail_embedding[n8][n10];
                        dArray8[n10] = dArray5[n10] - dArray6[n10];
                        d8 += dArray8[n10] * dArray8[n10];
                    }
                    if (d8 > 0.0) {
                        d7 = d4 / (0.001 + d8) / (d * Math.pow(d8, d2) + 1.0);
                        for (n10 = 0; n10 < n; ++n10) {
                            d9 = d7 * dArray8[n10];
                            dArray7[n10] = d9 >= 4.0 ? d10 : (d9 <= -4.0 ? d11 : d9 * this.alpha);
                        }
                    } else {
                        for (n10 = 0; n10 < n; ++n10) {
                            dArray7[n10] = 4.0;
                        }
                    }
                    for (n10 = 0; n10 < n; ++n10) {
                        dArray5[n10] = dArray5[n10] + dArray7[n10];
                    }
                }
                for (n6 = 0; n6 < n; ++n6) {
                    this.head_embedding[n7][n6] = dArray5[n6];
                    if (!blArray[n7]) continue;
                    this.tail_embedding[n7][n6] = dArray5[n6];
                }
                int n11 = j;
                dArray3[n11] = dArray3[n11] + (double)n5 * dArray2[j];
            }
            this.alpha = d3 * (1.0 - (double)i / (double)n3);
            d10 = this.alpha * 4.0;
            d11 = this.alpha * -4.0;
            if (Math.floor((double)i % this.nTh) != 0.0) continue;
            this.n_epoch = i + 1;
            return this.n_epoch >= this.n_epochs;
        }
        return true;
    }

    public boolean nextEpochs(List<Integer> list) {
        if (DEBUGGING) {
            int[] nArray = null;
            nArray = new int[]{1069, 754, 674, 957, 46, 714, 415, 1083, 947, 1070, 298, 1864};
            if (list == null && nArray != null) {
                list = new ArrayList<Integer>();
                for (int i = 0; i < nArray.length; ++i) {
                    list.add(nArray[i]);
                }
            }
        }
        boolean bl = this.move_other;
        boolean[] blArray = this.move_point;
        int n = this.n_components;
        int n2 = this.n_1_simplices;
        int n3 = this.n_epochs;
        int n4 = this.n_vertices;
        int[] nArray = this.head;
        int[] nArray2 = this.tail;
        double[] dArray = this.epochs_per_sample;
        double d = this.a;
        double d2 = this.b;
        double d3 = this.initial_alpha;
        double d4 = this.BG2S;
        double d5 = this.ABNEG2;
        double d6 = this.BNEG1;
        double[] dArray2 = this.epochs_per_negative_sample;
        double[] dArray3 = this.epoch_of_next_negative_sample;
        double[] dArray4 = this.epoch_of_next_sample;
        int n5 = 0;
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        int n6 = 0;
        double[] dArray7 = new double[n];
        double[] dArray8 = new double[n];
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        if (bl && blArray == null) {
            this.tail_embedding = this.head_embedding;
        }
        double d10 = this.alpha * 4.0;
        double d11 = this.alpha * -4.0;
        for (int i = this.n_epoch; i <= n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n7;
                if (dArray4[j] > (double)i) continue;
                int n8 = nArray[j] - 1;
                int n9 = nArray2[j] - 1;
                for (n7 = 0; n7 < n; ++n7) {
                    dArray5[n7] = this.head_embedding[n8][n7];
                    dArray6[n7] = this.tail_embedding[n9][n7];
                    dArray8[n7] = dArray5[n7] - dArray6[n7];
                }
                d8 = 0.0;
                for (n7 = 0; n7 < n; ++n7) {
                    d8 += dArray8[n7] * dArray8[n7];
                }
                if (d8 > 0.0) {
                    if (DEBUGGING) {
                        boolean bl2 = this.doDebug = (StochasticGradientDescent.IsDebugIdx(n8) || StochasticGradientDescent.IsDebugIdx(n9)) && i > 5 && this.debugPrints < debugPrintLimit;
                        if (this.doDebug) {
                            ++this.debugPrints;
                            System.out.printf("debugPrint #%d:  n=%d, j=%d, k=%d, sub=[%f %f], current=[%f %f], other=[%f %f], dist_squared=%f \n ", this.debugPrints, i, n8, n9, dArray8[0], dArray8[1], dArray5[0], dArray5[1], dArray6[0], dArray6[1], d8);
                        }
                    }
                    d7 = d5 * Math.pow(d8, d6) / (d * Math.pow(d8, d2) + 1.0);
                    for (n7 = 0; n7 < n; ++n7) {
                        d9 = d7 * dArray8[n7];
                        dArray7[n7] = d9 >= 4.0 ? d10 : (d9 <= -4.0 ? d11 : d9 * this.alpha);
                        dArray5[n7] = dArray5[n7] + dArray7[n7];
                    }
                    if (DEBUGGING && this.doDebug) {
                        System.out.printf(" ... grad=[%f %f], current=[%f %f]\n ", dArray7[0], dArray7[1], dArray5[0], dArray5[1]);
                    }
                    if (bl) {
                        if (blArray == null) {
                            for (n7 = 0; n7 < n; ++n7) {
                                dArray6[n7] = dArray6[n7] - dArray7[n7];
                                this.tail_embedding[n9][n7] = dArray6[n7];
                            }
                        } else if (blArray[n9]) {
                            for (n7 = 0; n7 < n; ++n7) {
                                dArray6[n7] = dArray6[n7] - dArray7[n7];
                                this.head_embedding[n9][n7] = dArray6[n7];
                                this.tail_embedding[n9][n7] = dArray6[n7];
                            }
                        }
                    }
                } else {
                    for (n7 = 0; n7 < n; ++n7) {
                        dArray7[n7] = 0.0;
                    }
                }
                int n10 = j;
                dArray4[n10] = dArray4[n10] + dArray[j];
                n6 = (int)Math.floor(((double)i - dArray3[j]) / dArray2[j]);
                for (n7 = 0; n7 < n6; ++n7) {
                    int n11;
                    if (list == null) {
                        n9 = this.r.nextInt(n4);
                    } else {
                        if (n5 >= list.size()) {
                            n5 = 0;
                        }
                        n9 = list.get(n5++);
                    }
                    if (bl && (blArray == null || blArray[n9]) && n8 == n9) continue;
                    d8 = 0.0;
                    for (n11 = 0; n11 < n; ++n11) {
                        dArray6[n11] = this.tail_embedding[n9][n11];
                        dArray8[n11] = dArray5[n11] - dArray6[n11];
                        d8 += dArray8[n11] * dArray8[n11];
                    }
                    if (d8 > 0.0) {
                        d7 = d4 / (0.001 + d8) / (d * Math.pow(d8, d2) + 1.0);
                        for (n11 = 0; n11 < n; ++n11) {
                            d9 = d7 * dArray8[n11];
                            dArray7[n11] = d9 >= 4.0 ? d10 : (d9 <= -4.0 ? d11 : d9 * this.alpha);
                        }
                    } else {
                        for (n11 = 0; n11 < n; ++n11) {
                            dArray7[n11] = 4.0;
                        }
                    }
                    for (n11 = 0; n11 < n; ++n11) {
                        dArray5[n11] = dArray5[n11] + dArray7[n11];
                    }
                    if (!DEBUGGING || !this.doDebug) continue;
                    System.out.printf("\tp=%d, k=%d: dist_squared=%f, grad=[%f %f], \n\t\tcurrent=[%f %f]", n7, n9, d8, dArray7[0], dArray7[1], dArray5[0], dArray5[1]);
                    System.out.print("\n");
                }
                for (n7 = 0; n7 < n; ++n7) {
                    this.head_embedding[n8][n7] = dArray5[n7];
                    if (blArray == null || !blArray[n8]) continue;
                    this.tail_embedding[n8][n7] = dArray5[n7];
                }
                int n12 = j;
                dArray3[n12] = dArray3[n12] + (double)n6 * dArray2[j];
                if (!DEBUGGING) continue;
                ++this.computes;
            }
            this.alpha = d3 * (1.0 - (double)i / (double)n3);
            d10 = this.alpha * 4.0;
            d11 = this.alpha * -4.0;
            if (Math.floor((double)i % this.nTh) != 0.0) continue;
            this.n_epoch = i + 1;
            if (DEBUGGING) {
                this.debugHeadTail1stLast(bl);
                return true;
            }
            return this.n_epoch >= this.n_epochs;
        }
        return true;
    }

    public double[][] getEmbedding() {
        return this.head_embedding;
    }

    public boolean isFinished() {
        return this.n_epoch >= this.n_epochs;
    }

    public static final int EPOCH_REPORTS() {
        return 20;
    }

    public static double[][] Copy(double[][] dArray) {
        int n = dArray.length;
        double[][] dArrayArray = new double[dArray.length][];
        for (int i = 0; i < n; ++i) {
            int n2 = dArray[i].length;
            dArrayArray[i] = new double[n2];
            for (int j = 0; j < n2; ++j) {
                dArrayArray[i][j] = dArray[i][j];
            }
        }
        return dArrayArray;
    }
}

