/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

import edu.stanford.facs.swing.Basics;
import edu.stanford.facs.swing.CloseButs;
import edu.stanford.facs.swing.DndTrees;
import edu.stanford.facs.swing.ToolTipOnDemand;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class SwingUtil {
    private static Timer tm;

    public static MouseEar ListenToMouse(JFrame jFrame) {
        MouseEar mouseEar = new MouseEar();
        jFrame.addMouseListener(mouseEar);
        return mouseEar;
    }

    public static void Test() {
        System.out.println("Testing worked okay");
    }

    public static void echoAction(JComponent jComponent, AbstractButton abstractButton, ActionListener actionListener, KeyStroke keyStroke, char c) {
        Object var5_5 = null;
        if (abstractButton != null) {
            abstractButton.addActionListener(actionListener);
            abstractButton.setMnemonic(c);
        }
        if (keyStroke != null) {
            if (abstractButton instanceof JMenuItem) {
                ((JMenuItem)abstractButton).setAccelerator(keyStroke);
            }
            if (jComponent != null) {
                jComponent.registerKeyboardAction(actionListener, keyStroke, 0);
            }
        }
    }

    public static ImageIcon gif(String string) {
        return Basics.ResizeIfNeeded(SwingUtil.getImageGifIcon(string));
    }

    public static ImageIcon getImageGifIcon(String string) {
        ImageIcon imageIcon = null;
        URL uRL = SwingUtil.class.getResource("images/" + string + ".gif");
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL);
        }
        return imageIcon;
    }

    private static JPanel getMoreLessPanel(final JDialog jDialog, final String string, final String string2, int n) {
        final JPanel jPanel = new JPanel(new BorderLayout());
        final JLabel jLabel = new JLabel(string);
        final JPanel jPanel2 = new JPanel(new GridLayout(1, 1));
        JLabel jLabel2 = new JLabel(SwingUtil.getImageGifIcon("facs"));
        jPanel2.add(jLabel2);
        jPanel.add((Component)jPanel2, "West");
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jLabel);
        jPanel.add((Component)jPanel3, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        final JButton jButton = new JButton("<html><small><u>More</u></small></html>");
        jButton.setIcon(SwingUtil.getImageGifIcon("great"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object var2_2 = null;
                jPanel.removeAll();
                jPanel.add((Component)jPanel2, "West");
                if (jLabel.getText().equals(string)) {
                    jLabel.setText(string2);
                    Dimension dimension = jLabel.getPreferredSize();
                    Rectangle rectangle = SwingUtil.getScreen(jDialog);
                    int n = 0;
                    int n2 = 0;
                    float f = 0.85f;
                    if ((float)dimension.width > f * (float)rectangle.width) {
                        n = (int)(f * (float)rectangle.width);
                    }
                    if ((float)dimension.height > f * (float)rectangle.height) {
                        n2 = (int)(f * (float)rectangle.height);
                    }
                    if (n > 0 || n2 > 0) {
                        Dimension dimension2 = new Dimension();
                        dimension2.width = n > 0 ? n : dimension.width;
                        dimension2.height = n2 > 0 ? n2 : dimension.height;
                        JPanel jPanel3 = new JPanel();
                        jPanel3.add(jLabel);
                        JScrollPane jScrollPane = new JScrollPane(jPanel3);
                        jScrollPane.setPreferredSize(dimension2);
                        jPanel.add((Component)jScrollPane, "Center");
                    } else {
                        jPanel.add((Component)jLabel, "Center");
                    }
                    jButton.setText("<html><small><u>Less</u></small></html>");
                    jButton.setIcon(SwingUtil.getImageGifIcon("less"));
                } else {
                    jLabel.setText(string);
                    jButton.setText("<html><small><u>More</u></small></html>");
                    jButton.setIcon(SwingUtil.getImageGifIcon("great"));
                    jPanel.add((Component)jLabel, "Center");
                }
                SwingUtil.stylizeAsHyperLink(jButton);
                jPanel.add((Component)jButton, "East");
                jDialog.pack();
            }
        });
        jPanel.add((Component)jButton, "East");
        SwingUtil.stylizeAsHyperLink(jButton);
        jDialog.pack();
        return jPanel;
    }

    public static void alertWithMoreOrLess(final Window window, final String string, final String string2, final String string3, final String string4, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDialog jDialog = new JDialog(window);
                SwingUtil.show(window, string, false, jDialog, SwingUtil.getMoreLessPanel(jDialog, string2, string3, bl ? 0 : 1), string4);
            }
        });
    }

    public static void show(Window window, String string, boolean bl, final JDialog jDialog, JPanel jPanel, String string2) {
        ToolTipOnDemand.hideManagerWindow();
        JPanel jPanel2 = new JPanel();
        jDialog.getContentPane().add(jPanel2);
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton("Ok");
        jButton.setMnemonic('o');
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jPanel3.setLayout(new FlowLayout(1));
        jPanel3.add(jButton);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 4, 10, 10));
        if (!bl) {
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add((Component)jPanel3, "Center");
        } else {
            if (bl) {
                jPanel2.add((Component)new JScrollPane(jPanel), "Center");
                jDialog.getContentPane().setPreferredSize(new Dimension(500, 600));
            } else {
                jPanel2.add((Component)jPanel, "North");
            }
            jPanel2.add((Component)jPanel3, "South");
        }
        jDialog.setTitle(string2);
        jDialog.getRootPane().setDefaultButton(jButton);
        jDialog.setModal(true);
        jDialog.pack();
        jDialog.getRootPane().setDefaultButton(jButton);
        SwingUtil.position(window, jDialog, string);
        jDialog.setVisible(true);
    }

    public static void setTreeRowBorder(JTree jTree, int n) {
        SwingUtil.setTreeRowBorder(jTree, n, n, n, n);
    }

    public static void setTreeRowBorder(JTree jTree, final int n, final int n2, final int n3, final int n4) {
        final TreeCellRenderer treeCellRenderer = jTree.getCellRenderer();
        Font font = jTree.getFont();
        Font font2 = new Font(font.getName(), 0, font.getSize() - 1);
        jTree.setCellRenderer(new TreeCellRenderer(){
            private Border border;
            private Border noBorder;
            private Border folderBorder;
            private Border sampleGateBorder;
            {
                this.border = BorderFactory.createEmptyBorder(n, n2, n3, n4);
                this.noBorder = BorderFactory.createEmptyBorder(0, 0, 0, 0);
                this.folderBorder = BorderFactory.createEmptyBorder(n + 1, n2, n3, n4);
                this.sampleGateBorder = BorderFactory.createEmptyBorder(n + 2, n2, n3, n4);
            }

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n5, boolean bl4) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                JLabel jLabel = (JLabel)treeCellRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n5, bl4);
                String string = DndTrees.toTreeNodeUserObject(defaultMutableTreeNode);
                if (string == null) {
                    string = "";
                }
                if (string.startsWith("folder:")) {
                    jLabel.setBorder(this.folderBorder);
                } else if (string.startsWith("sample:")) {
                    String string2 = DndTrees.toTreeNodeUserObject(defaultMutableTreeNode.getPreviousNode());
                    if (string2.startsWith("gate:")) {
                        jLabel.setBorder(this.sampleGateBorder);
                    } else {
                        jLabel.setBorder(this.border);
                    }
                } else {
                    String string3 = defaultMutableTreeNode.toString();
                    if (string3.contains("<table")) {
                        jLabel.setBorder(this.noBorder);
                    } else {
                        jLabel.setBorder(this.border);
                    }
                }
                return jLabel;
            }
        });
    }

    public static void position(Window window, Window window2, String string) {
        Rectangle rectangle;
        Dimension dimension = window2.getSize();
        Dimension dimension2 = null;
        if (window == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            dimension2 = toolkit.getScreenSize();
            rectangle = new Rectangle(dimension2);
        } else {
            rectangle = SwingUtil.getScreen(window);
            dimension2 = window.getSize();
        }
        int n = dimension2.height / 2 - dimension.height / 2;
        int n2 = dimension2.width / 2 - dimension.width / 2;
        if (string != null) {
            if (string.contains("west+")) {
                n2 = 0 - dimension.width / 2;
            } else if (string.contains("west")) {
                n2 = 0;
            } else if (string.contains("east+")) {
                n2 = dimension2.width - dimension.width / 2;
            } else if (string.contains("east")) {
                n2 = dimension2.width - dimension.width;
            }
            if (string.contains("north+")) {
                n = 0 - dimension.height / 2;
            } else if (string.contains("north")) {
                n = 0;
            } else if (string.contains("south+")) {
                n = dimension2.height - dimension.height / 2;
            } else if (string.contains("south")) {
                n = dimension2.height - dimension.height;
            }
        }
        if (window != null) {
            Point point = window.getLocation();
            n += point.y;
            n2 += point.x;
        }
        if (n2 < rectangle.x) {
            n2 = rectangle.x;
        }
        if (n < rectangle.y) {
            n = rectangle.y;
        }
        window2.setLocation(n2, n);
    }

    public static Rectangle getScreen(Component component) {
        Rectangle rectangle;
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window == null) {
            Dimension dimension = component.getToolkit().getScreenSize();
            rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        } else {
            rectangle = SwingUtil.getScreen(window);
        }
        return rectangle;
    }

    public static Rectangle getScreen(Window window) {
        Cloneable cloneable;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        TreeMap<Integer, Rectangle> treeMap = new TreeMap<Integer, Rectangle>();
        if (graphicsDeviceArray.length > 1) {
            cloneable = window.getBounds();
            for (int i = 0; i < graphicsDeviceArray.length; ++i) {
                GraphicsConfiguration graphicsConfiguration = graphicsDeviceArray[i].getDefaultConfiguration();
                Rectangle rectangle = graphicsConfiguration.getBounds();
                if (rectangle == null) continue;
                int n = SwingUtil.getPortion(cloneable, rectangle);
                treeMap.put(n, rectangle);
            }
        }
        if (treeMap.size() > 0) {
            int n = (Integer)treeMap.lastKey();
            Rectangle rectangle = (Rectangle)treeMap.get(n);
            return rectangle;
        }
        cloneable = Toolkit.getDefaultToolkit().getScreenSize();
        return new Rectangle(0, 0, ((Dimension)cloneable).width, ((Dimension)cloneable).height);
    }

    private static int getPortion(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = n + n2;
        int n7 = n3 + n4;
        if (n < n3) {
            if (n6 > n3) {
                n5 = n7 > n6 ? n6 - n3 : n4;
            }
        } else if (n < n7) {
            n5 = n6 < n7 ? n2 : n7 - n;
        }
        return n5;
    }

    private static int getPortion(Rectangle rectangle, Rectangle rectangle2) {
        int n = SwingUtil.getPortion(rectangle.x, rectangle.width, rectangle2.x, rectangle2.width);
        int n2 = SwingUtil.getPortion(rectangle.y, rectangle.height, rectangle2.y, rectangle2.height);
        return n * n2;
    }

    private static void stylizeAsHyperLink(AbstractButton abstractButton) {
        String string = abstractButton.getText();
        SwingUtil.setToolBarStyle(abstractButton);
        abstractButton.setText("<html><u>" + string + "</u></html>");
        abstractButton.setForeground(Color.blue);
    }

    private static AbstractButton setToolBarStyle(AbstractButton abstractButton) {
        abstractButton.setMargin(new Insets(0, 0, 0, 0));
        abstractButton.setIconTextGap(0);
        abstractButton.setBorderPainted(false);
        abstractButton.setBorder(null);
        abstractButton.setText(null);
        abstractButton.setOpaque(false);
        abstractButton.setBackground(UIManager.getColor("Panel.background"));
        abstractButton.setFocusPainted(false);
        return abstractButton;
    }

    public static TreeMap SortedMap() {
        return new TreeMap(new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)object;
                String string2 = (String)object2;
                return string.toLowerCase().compareTo(string2.toLowerCase());
            }
        });
    }

    public static TreeMap<String, List<String>> SortedStringMapOfMany() {
        return new TreeMap<String, List<String>>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                String string3 = string;
                String string4 = string2;
                return string3.toLowerCase().compareTo(string4.toLowerCase());
            }
        });
    }

    public static void addItem(Map<String, List> map, String string, String string2) {
        if (string != null && !string.trim().equals("")) {
            ArrayList<String> arrayList = map.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                map.put(string, arrayList);
            }
            arrayList.add(string2);
        }
    }

    public static JLabel TitleLabel(JLabel jLabel) {
        Font font = jLabel.getFont();
        font = new Font(font.getName(), 1, font.getSize());
        jLabel.setFont(font);
        return jLabel;
    }

    public static void FocusLabel(final JComponent jComponent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                jComponent.requestFocus();
                            }
                        });
                    }
                });
            }
        });
    }

    public static int getChoice(Window window, String string, String string2, Object object, String[] stringArray, int n, ImageIcon imageIcon) {
        return SwingUtil.getChoice(window, string, string2, object, stringArray, n, imageIcon, null);
    }

    public static int getChoice(Window window, String string, String string2, Object object, String[] stringArray, int n, ImageIcon imageIcon, JComponent jComponent) {
        JComponent jComponent2;
        JComponent jComponent3;
        int n2 = stringArray.length;
        final JDialog jDialog = new JDialog(window, string2);
        JPanel jPanel = new JPanel(new BorderLayout());
        if (object instanceof String) {
            jComponent3 = new JLabel((String)object);
            ((JLabel)jComponent3).setHorizontalAlignment(0);
            jPanel.add((Component)jComponent3, "North");
        } else {
            jPanel.add((Component)object, "North");
        }
        jComponent3 = new JPanel(new GridLayout(n2, 1, 0, 4));
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createEmptyBorder(8, 8, 8, 8));
        jComponent3.setBorder(compoundBorder);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(8, 20, 8, 20));
        jPanel2.add(jComponent3);
        jPanel.add((Component)jPanel2, "Center");
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton[] jRadioButtonArray = new JRadioButton[n2];
        for (int i = 0; i < n2; ++i) {
            jRadioButtonArray[i] = jComponent2 = new JRadioButton(stringArray[i], n == i);
            buttonGroup.add((AbstractButton)jComponent2);
            jComponent3.add(jComponent2);
        }
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel3, "South");
        jComponent2 = new JPanel();
        jPanel3.add((Component)jComponent2, "East");
        if (jComponent != null) {
            jPanel3.add((Component)jComponent, "West");
        }
        CloseButs closeButs = new CloseButs(jDialog, (JPanel)jComponent2);
        if (imageIcon != null) {
            JPanel jPanel4 = new JPanel(new BorderLayout(14, 0));
            jPanel4.add((Component)new JLabel(imageIcon), "West");
            jPanel4.add((Component)jPanel, "Center");
            jPanel4.setBorder(BorderFactory.createEmptyBorder(8, 12, 5, 8));
            jDialog.getContentPane().add(jPanel4);
        } else {
            jDialog.getContentPane().add(jPanel);
            jPanel.setBorder(BorderFactory.createEmptyBorder(8, 12, 5, 8));
        }
        jDialog.pack();
        jDialog.setModal(true);
        jDialog.setAlwaysOnTop(true);
        SwingUtil.position(window, jDialog, string);
        tm = new Timer(1200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setAlwaysOnTop(false);
            }
        });
        jDialog.setVisible(true);
        if (!closeButs.cancelled) {
            for (int i = 0; i < n2; ++i) {
                if (!jRadioButtonArray[i].isSelected()) continue;
                return i;
            }
        }
        return -1;
    }

    public static void setAcceleratorsLater(final JMenu jMenu, int n, final String[] stringArray) {
        tm = new Timer(n, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = jMenu.getMenuComponentCount();
                for (int i = 0; i < stringArray.length; i += 2) {
                    String string = stringArray[i];
                    String string2 = stringArray[i + 1];
                    for (int j = 0; j < n; ++j) {
                        JMenuItem jMenuItem;
                        String string3;
                        Component component = jMenu.getMenuComponent(j);
                        if (!(component instanceof JMenuItem) || !SwingUtil.equals(string3 = (jMenuItem = (JMenuItem)component).getText(), string)) continue;
                        KeyStroke keyStroke = KeyStroke.getKeyStroke(string2);
                        jMenuItem.setAccelerator(keyStroke);
                    }
                }
                tm.stop();
                jMenu.invalidate();
                jMenu.repaint(100L);
            }
        });
        tm.setRepeats(false);
        tm.start();
    }

    public static String[] getItems(JComboBox<String> jComboBox) {
        String[] stringArray = new String[jComboBox.getItemCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = jComboBox.getItemAt(i).toString();
        }
        return stringArray;
    }

    public static JComboBox<String> setItems(JComboBox<String> jComboBox, String[] stringArray) {
        if (jComboBox == null) {
            jComboBox = new JComboBox();
        }
        jComboBox.removeAllItems();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            jComboBox.addItem(stringArray[i]);
        }
        return jComboBox;
    }

    public static int[] findOrder(Object[] objectArray, Object[] objectArray2) {
        int n = objectArray.length;
        int n2 = objectArray2.length;
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            int n3 = -1;
            for (int j = 0; j < n2; ++j) {
                if (!SwingUtil.equals(object, objectArray2[j])) continue;
                n3 = j;
                break;
            }
            nArray[i] = n3;
        }
        return nArray;
    }

    public static boolean sort(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length < 2) {
            return false;
        }
        TreeMap treeMap = new TreeMap();
        Map.Entry entry = treeMap.floorEntry("foo");
        boolean bl = false;
        if (objectArray2 != null && objectArray2.length > 0) {
            int n;
            HashSet<Object> hashSet = new HashSet<Object>();
            Object[] objectArray3 = new Object[objectArray.length];
            int n2 = 0;
            for (n = 0; n < objectArray2.length; ++n) {
                Object object = objectArray2[n];
                if (hashSet.contains(object)) continue;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!SwingUtil.equals(objectArray[i], object)) continue;
                    if (i != n2) {
                        bl = true;
                    }
                    objectArray3[n2++] = objectArray[i];
                }
                hashSet.add(object);
            }
            for (n = 0; n < objectArray.length; ++n) {
                if (SwingUtil.equalsAny(objectArray2, objectArray[n])) continue;
                objectArray3[n2++] = objectArray[n];
            }
            for (n = 0; n < objectArray.length; ++n) {
                objectArray[n] = objectArray3[n];
            }
        }
        return bl;
    }

    public static boolean equalsAny(Object[] objectArray, Object object) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!SwingUtil.equals(object, objectArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object2 != null) {
            return object2.equals(object);
        }
        return object.equals(object2);
    }

    public static void adjustFontSize(String string, double d) {
        Font font = UIManager.getFont(string);
        int n = font.getSize();
        int n2 = (int)((double)n * d);
        UIManager.put(string, new Font(font.getFontName(), 0, n2));
    }

    public static void adjustFontSizes(double d) {
        String[] stringArray = new String[]{"Button.font", "ToggleButton.font", "RadioButton.font", "CheckBox.font", "ColorChooser.font", "ComboBox.font", "Label.font", "List.font", "MenuBar.font", "MenuItem.font", "RadioButtonMenuItem.font", "CheckBoxMenuItem.font", "Menu.font", "PopupMenu.font", "OptionPane.font", "Panel.font", "ProgressBar.font", "ScrollPane.font", "Viewport.font", "TabbedPane.font", "Table.font", "TableHeader.font", "TextField.font", "PasswordField.font", "TextArea.font", "TextPane.font", "EditorPane.font", "TitledBorder.font", "ToolBar.font", "ToolTip.font", "Tree.font"};
        for (int i = 0; i < stringArray.length; ++i) {
            SwingUtil.adjustFontSize(stringArray[i], d);
        }
    }

    public static void setUIFont(FontUIResource fontUIResource) {
        Enumeration enumeration = UIManager.getDefaults().keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = UIManager.get(k);
            if (object == null || !(object instanceof FontUIResource)) continue;
            UIManager.put(k, fontUIResource);
        }
    }

    public static DecimalFormatSymbols getDecimalFormatSymbols() {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.getDefault());
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormatSymbols.setGroupingSeparator(',');
        return decimalFormatSymbols;
    }

    public static class MouseEar
    extends MouseAdapter {
        public boolean shift;
        public boolean meta;
        public boolean control;
        public boolean alt;
        public boolean doubleClick;
        public boolean rightClick;
        public int releaseCount;

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            ++this.releaseCount;
            this.shift = mouseEvent.isShiftDown();
            this.alt = mouseEvent.isAltDown();
            this.meta = mouseEvent.isMetaDown();
            this.control = mouseEvent.isControlDown();
            this.doubleClick = mouseEvent.getClickCount() == 2;
            this.rightClick = mouseEvent.isPopupTrigger();
            System.out.println("shift=" + this.shift + ", meta=" + this.meta + ", control=" + this.control + ", alt=" + this.alt + ", doubleClick=" + this.doubleClick + ", rightClick=" + this.rightClick);
        }
    }
}

