/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.TreeMap;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class SwingUtil2 {
    public static Rectangle getScreen(Component component) {
        Rectangle rectangle;
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window == null) {
            Dimension dimension = component.getToolkit().getScreenSize();
            rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        } else {
            rectangle = SwingUtil2.getScreen(window);
        }
        return rectangle;
    }

    public static Rectangle getScreen(Window window) {
        Cloneable cloneable;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        TreeMap<Integer, Rectangle> treeMap = new TreeMap<Integer, Rectangle>();
        if (graphicsDeviceArray.length > 1) {
            cloneable = window.getBounds();
            for (int i = 0; i < graphicsDeviceArray.length; ++i) {
                GraphicsConfiguration graphicsConfiguration = graphicsDeviceArray[i].getDefaultConfiguration();
                Rectangle rectangle = graphicsConfiguration.getBounds();
                if (rectangle == null) continue;
                int n = SwingUtil2.getPortion(cloneable, rectangle);
                treeMap.put(n, rectangle);
            }
        }
        if (treeMap.size() > 0) {
            int n = (Integer)treeMap.lastKey();
            Rectangle rectangle = (Rectangle)treeMap.get(n);
            return rectangle;
        }
        cloneable = Toolkit.getDefaultToolkit().getScreenSize();
        return new Rectangle(0, 0, ((Dimension)cloneable).width, ((Dimension)cloneable).height);
    }

    private static int getPortion(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = n + n2;
        int n7 = n3 + n4;
        if (n < n3) {
            if (n6 > n3) {
                n5 = n7 > n6 ? n6 - n3 : n4;
            }
        } else if (n < n7) {
            n5 = n6 < n7 ? n2 : n7 - n;
        }
        return n5;
    }

    private static int getPortion(Rectangle rectangle, Rectangle rectangle2) {
        int n = SwingUtil2.getPortion(rectangle.x, rectangle.width, rectangle2.x, rectangle2.width);
        int n2 = SwingUtil2.getPortion(rectangle.y, rectangle.height, rectangle2.y, rectangle2.height);
        return n * n2;
    }

    public static void updateTable(JTable jTable, String[][] stringArray, int[] nArray, int[] nArray2) throws Exception {
        int n;
        int n2 = stringArray.length;
        if (n2 != nArray2.length) {
            throw new Exception("Must have as many modelRows as data rows: " + n2 + "!");
        }
        if (n2 != jTable.getRowCount()) {
            throw new Exception("JTable must have as many rows as data rows: " + n2 + "!");
        }
        int n3 = nArray.length;
        int[] nArray3 = new int[n3];
        for (n = 0; n < n3; ++n) {
            nArray3[n] = jTable.convertColumnIndexToView(nArray[n]);
        }
        for (n = 0; n < n2; ++n) {
            int n4 = nArray2[n];
            for (int i = 0; i < n3; ++i) {
                int n5 = nArray3[i];
                String string = stringArray[n4][nArray[i]];
                if (string == null) {
                    jTable.setValueAt("", n, n5);
                    continue;
                }
                jTable.setValueAt(string, n, n5);
            }
        }
    }
}

