/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

import edu.stanford.facs.swing.ImageButton;
import edu.stanford.facs.swing.SwingUtil2;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ToolTipUI;

public class ToolTipOnDemand
extends MouseAdapter {
    static Border BORDER_EMPTY = BorderFactory.createEmptyBorder();
    static Border BORDER_MAJOR = new BevelBorder(0, Color.WHITE, Color.BLACK){
        private static final long serialVersionUID = 1L;

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(3, 3, 6, 6);
        }
    };
    private Timer insideTimer = new Timer(4000, new stillInsideTimerAction());
    private JComponent insideComponent;
    private static final ToolTipOnDemand singleton = new ToolTipOnDemand();
    transient Popup tipWindow;
    private Window window;
    private MyToolTip tip;
    private Rectangle popupRect = null;
    private Rectangle popupFrameRect = null;
    private boolean enabled = true;
    private FocusListener focusChangeListener = null;
    private Point alternateLocation = null;
    private static Border empty = BorderFactory.createEmptyBorder(1, 0, 0, 0);
    public boolean left2Right = false;
    private JButton cancel;
    private JComponent northCentralComponent;
    private ActionListener closeListener = null;
    public boolean hideOnMouseExitIfComponentIsInvisible = true;
    private static JPanel westPanel;

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static final JButton getButton(String string, int n, ActionListener actionListener, String string2) {
        JButton jButton = new JButton(string);
        jButton.setMnemonic(n);
        if (string2 != null) {
            jButton.setToolTipText(string2);
        }
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public void turnOffTimer() {
        if (this.insideTimer != null && this.insideTimer.isRunning()) {
            this.insideTimer.stop();
        }
    }

    public void turnOnTimer() {
        if (this.insideTimer != null && !this.insideTimer.isRunning()) {
            this.insideTimer.restart();
        }
    }

    private ToolTipOnDemand() {
        this.insideTimer.setRepeats(false);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setDismissDelay(int n) {
        this.insideTimer.setInitialDelay(n);
    }

    public int getDismissDelay() {
        return this.insideTimer.getInitialDelay();
    }

    public void showLater(JComponent jComponent) {
        this.showLater(jComponent, false, null);
    }

    public void showLater(JComponent jComponent, String string) {
        this.showLater(jComponent, false, null, jComponent.getWidth() - 5, jComponent.getHeight(), false, string);
    }

    public void showLater(JComponent jComponent, boolean bl, Component component) {
        this.showLater(jComponent, bl, component, jComponent.getWidth() - 5, jComponent.getHeight());
    }

    public void showLater(JComponent jComponent, boolean bl, Component component, int n, int n2) {
        this.showLater(jComponent, bl, component, n, n2, false);
    }

    public void showLater(final JComponent jComponent, final boolean bl, final Component component, final int n, final int n2, final boolean bl2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JButton jButton = ToolTipOnDemand.this.cancel;
                if (bl2) {
                    ToolTipOnDemand.this.cancel = null;
                }
                ToolTipOnDemand.this.show(jComponent, bl, n, n2, component, null);
                ToolTipOnDemand.this.cancel = jButton;
            }
        });
    }

    public void showLater(final JComponent jComponent, final boolean bl, final Component component, final int n, final int n2, final boolean bl2, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JButton jButton = ToolTipOnDemand.this.cancel;
                if (bl2) {
                    ToolTipOnDemand.this.cancel = null;
                }
                ToolTipOnDemand.this.show(jComponent, bl, n, n2, component, string);
                ToolTipOnDemand.this.cancel = jButton;
            }
        });
    }

    public void show(JComponent jComponent, boolean bl) {
        this.show(jComponent, bl, jComponent.getWidth() - 5, jComponent.getHeight() - 5);
    }

    public void showWithCloseButton(JComponent jComponent) {
        this.show(jComponent, false, jComponent.getWidth() - 5, jComponent.getHeight() - 5, true);
    }

    public void show(JComponent jComponent, boolean bl, int n, int n2) {
        this.show(jComponent, bl, n, n2, false);
    }

    public void show(JComponent jComponent, boolean bl, int n, int n2, boolean bl2) {
        this.show(jComponent, bl, n, n2, bl2, true);
    }

    public void show(JComponent jComponent, boolean bl, int n, int n2, boolean bl2, boolean bl3) {
        JButton jButton = this.cancel;
        if (!bl3 || bl2) {
            this.cancel = null;
        }
        this.show(jComponent, bl, n, n2, bl2 ? ToolTipOnDemand.getButton("Close", 99, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToolTipOnDemand.this.hideTipWindow();
            }
        }, null) : null, null);
        this.cancel = jButton;
    }

    public void setAlternateLocation(Point point) {
        this.alternateLocation = point;
    }

    public static void popup(final JComboBox jComboBox) {
        jComboBox.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        jComboBox.setPopupVisible(true);
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    public void show(JComponent jComponent, boolean bl, int n, int n2, Component component, String string) {
        this.hideOnMouseExitIfComponentIsInvisible = true;
        if (jComponent == null || !jComponent.isShowing() || jComponent == this.insideComponent) {
            return;
        }
        this.close();
        if (component == null) {
            jComponent.addMouseListener(this);
        }
        this.insideComponent = jComponent;
        if (string == null && (string = jComponent.getToolTipText()) == null && component == null) {
            return;
        }
        boolean bl2 = string.equals("<html></html>");
        Point point = new Point(n, n2);
        if (this.enabled) {
            Serializable serializable;
            JPanel jPanel;
            Window window = SwingUtilities.windowForComponent(this.insideComponent);
            Rectangle rectangle = SwingUtil2.getScreen(this.insideComponent);
            boolean bl3 = this.insideComponent.getComponentOrientation().isLeftToRight();
            this.hideTipWindow();
            this.tip = new MyToolTip();
            this.tip.setComponent(this.insideComponent);
            this.tip.setTipText(string);
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
            if (this.northCentralComponent == null || this.cancel != null) {
                if (string == null || !string.startsWith("<html>")) {
                    this.tip.setBorder(empty);
                } else {
                    this.tip.setBorder(BORDER_EMPTY);
                }
            } else {
                this.tip.setBorder(BORDER_EMPTY);
            }
            if (!bl2) {
                jPanel2.add((Component)this.tip, "Center");
            }
            jPanel2.setBackground(this.tip.getBackground());
            if (component != null) {
                if (westPanel != null) {
                    westPanel.setBackground(this.tip.getBackground());
                    westPanel.setOpaque(true);
                    jPanel2.add((Component)westPanel, "East");
                }
                jPanel = new JPanel(new FlowLayout(0, 0, 0));
                if (!bl2) {
                    jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
                }
                if (!(component instanceof JButton)) {
                    component.setBackground(this.tip.getBackground());
                    if (component instanceof JComponent) {
                        ((JComponent)component).setOpaque(true);
                    }
                }
                jPanel.add(component);
                jPanel.setBackground(this.tip.getBackground());
                jPanel.setOpaque(true);
                if (bl2) {
                    jPanel2.add((Component)jPanel, "Center");
                } else {
                    jPanel2.add((Component)jPanel, "South");
                }
            }
            jPanel = new JPanel(new BorderLayout(0, 0));
            jPanel.setBackground(this.tip.getBackground());
            jPanel.setOpaque(true);
            if (this.northCentralComponent != null) {
                jPanel.add(this.northCentralComponent);
                this.northCentralComponent.setBackground(this.tip.getBackground());
                this.northCentralComponent.setOpaque(true);
            }
            if (this.cancel != null) {
                jPanel.add((Component)this.cancel, "East");
                this.cancel.setBackground(this.tip.getBackground());
                this.cancel.setOpaque(true);
            }
            if (this.northCentralComponent != null || this.cancel != null) {
                if (this.northCentralComponent == null) {
                    jPanel2.add((Component)jPanel, "North");
                } else {
                    serializable = new JPanel(new BorderLayout(0, 0));
                    ((JComponent)serializable).setBackground(this.tip.getBackground());
                    ((JComponent)serializable).setOpaque(true);
                    ((Container)serializable).add(jPanel, "East");
                    jPanel2.add((Component)serializable, "North");
                }
            }
            ToolTipManager.sharedInstance().setEnabled(false);
            Point point2 = this.insideComponent.isShowing() ? this.insideComponent.getLocationOnScreen() : this.alternateLocation;
            Point point3 = new Point();
            serializable = jPanel2.getPreferredSize();
            point3.x = point2.x + point.x;
            point3.y = point2.y + point.y;
            if (!bl3 || this.left2Right) {
                point3.x -= ((Dimension)serializable).width;
            }
            if (this.popupRect == null) {
                this.popupRect = new Rectangle();
            }
            this.popupRect.setBounds(point3.x, point3.y, ((Dimension)serializable).width, ((Dimension)serializable).height);
            int n3 = this.getPopupFitHeight(this.popupRect, this.insideComponent);
            int n4 = this.getPopupFitWidth(this.popupRect, this.insideComponent);
            if (n3 > 0 && n2 == 0) {
                point3.y -= n3;
            }
            if (n4 > 0 && n == 0) {
                point3.x -= n4;
            }
            if (point3.x < rectangle.x) {
                point3.x = rectangle.x;
            } else if (point3.x - rectangle.x + ((Dimension)serializable).width > rectangle.width) {
                point3.x = rectangle.x + Math.max(0, rectangle.width - ((Dimension)serializable).width);
            }
            if (point3.y < rectangle.y) {
                point3.y = rectangle.y;
            } else if (point3.y - rectangle.y + ((Dimension)serializable).height > rectangle.height) {
                point3.y = rectangle.y + Math.max(0, rectangle.height - ((Dimension)serializable).height);
            }
            this.tipWindow = popupFactory.getPopup(this.insideComponent, jPanel2, point3.x, point3.y);
            this.tipWindow.show();
            this.window = SwingUtilities.windowForComponent(this.tip);
            if (this.window != null && this.window != window) {
                if (component == null) {
                    this.window.addMouseListener(this);
                }
            } else {
                this.window = null;
            }
            this.insideTimer.start();
            if (component == null && bl) {
                if (this.focusChangeListener == null) {
                    this.focusChangeListener = this.createFocusChangeListener();
                }
                this.insideComponent.addFocusListener(this.focusChangeListener);
            }
        }
    }

    public static void hideManagerWindow() {
        if (ToolTipManager.sharedInstance() != null) {
            ToolTipManager.sharedInstance().setEnabled(false);
            ToolTipManager.sharedInstance().setEnabled(true);
        }
    }

    public void setNorthCentralComponent(JComponent jComponent) {
        this.northCentralComponent = jComponent;
    }

    public JButton setCancel(String string) {
        JButton jButton = this.cancel;
        this.cancel = new ImageButton(string, null);
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToolTipOnDemand.getSingleton().hideTipWindow();
            }
        });
        return jButton;
    }

    public void addOneTimeCloseListener(ActionListener actionListener) {
        this.closeListener = actionListener;
    }

    public void hideTipWindow() {
        if (this.tipWindow != null) {
            if (this.window != null) {
                this.window.removeMouseListener(this);
                this.window = null;
            }
            this.tipWindow.hide();
            ToolTipManager.sharedInstance().setEnabled(true);
            this.tipWindow = null;
            this.tip.getUI().uninstallUI(this.tip);
            this.tip = null;
            this.insideTimer.stop();
        }
        if (this.closeListener != null) {
            this.closeListener.actionPerformed(new ActionEvent(this, 0, "close"));
            this.closeListener = null;
        }
    }

    public static ToolTipOnDemand getSingleton() {
        return singleton;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        boolean bl = true;
        if (this.insideComponent != null) {
            Point point;
            Window window;
            if (this.window != null && mouseEvent.getSource() == this.window) {
                Container container = this.insideComponent.getTopLevelAncestor();
                Point point2 = mouseEvent.getPoint();
                if (point2 != null && container != null) {
                    SwingUtilities.convertPointToScreen(point2, this.window);
                    point2.x -= container.getX();
                    point2.y -= container.getY();
                    point2 = SwingUtilities.convertPoint(null, point2, this.insideComponent);
                    bl = point2.x < 0 || point2.x >= this.insideComponent.getWidth() || point2.y < 0 || point2.y >= this.insideComponent.getHeight();
                }
            } else if (mouseEvent.getSource() == this.insideComponent && this.tipWindow != null && (window = SwingUtilities.getWindowAncestor(this.insideComponent)) != null && (point = SwingUtilities.convertPoint(this.insideComponent, mouseEvent.getPoint(), window)) != null) {
                Rectangle rectangle = this.insideComponent.getTopLevelAncestor().getBounds();
                point.x += rectangle.x;
                point.y += rectangle.y;
                Point point3 = new Point(0, 0);
                SwingUtilities.convertPointToScreen(point3, this.tip);
                rectangle.x = point3.x;
                rectangle.y = point3.y;
                rectangle.width = this.tip.getWidth();
                rectangle.height = this.tip.getHeight();
                bl = point.x < rectangle.x || point.x >= rectangle.x + rectangle.width || point.y < rectangle.y || point.y >= rectangle.y + rectangle.height;
            }
        }
        if (bl && this.hideOnMouseExitIfComponentIsInvisible) {
            this.close();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.close();
    }

    public void close() {
        this.hideTipWindow();
        if (this.insideComponent != null) {
            this.insideComponent.removeMouseListener(this);
            this.insideComponent = null;
        }
    }

    static Frame frameForComponent(Component component) {
        while (!(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    private FocusListener createFocusChangeListener() {
        return new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ToolTipOnDemand.this.close();
                JComponent jComponent = (JComponent)focusEvent.getSource();
                jComponent.removeFocusListener(ToolTipOnDemand.this.focusChangeListener);
            }
        };
    }

    private int getPopupFitWidth(Rectangle rectangle, Component component) {
        if (component != null) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (container instanceof JFrame || container instanceof JDialog || container instanceof JWindow) {
                    return this.getWidthAdjust(container.getBounds(), rectangle);
                }
                if (!(container instanceof JApplet) && !(container instanceof JInternalFrame)) continue;
                if (this.popupFrameRect == null) {
                    this.popupFrameRect = new Rectangle();
                }
                Point point = container.getLocationOnScreen();
                this.popupFrameRect.setBounds(point.x, point.y, container.getBounds().width, container.getBounds().height);
                return this.getWidthAdjust(this.popupFrameRect, rectangle);
            }
        }
        return 0;
    }

    private int getPopupFitHeight(Rectangle rectangle, Component component) {
        if (component != null) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (container instanceof JFrame || container instanceof JDialog || container instanceof JWindow) {
                    return this.getHeightAdjust(container.getBounds(), rectangle);
                }
                if (!(container instanceof JApplet) && !(container instanceof JInternalFrame)) continue;
                if (this.popupFrameRect == null) {
                    this.popupFrameRect = new Rectangle();
                }
                Point point = container.getLocationOnScreen();
                this.popupFrameRect.setBounds(point.x, point.y, container.getBounds().width, container.getBounds().height);
                return this.getHeightAdjust(this.popupFrameRect, rectangle);
            }
        }
        return 0;
    }

    private int getHeightAdjust(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2.y >= rectangle.y && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height) {
            return 0;
        }
        return rectangle2.y + rectangle2.height - (rectangle.y + rectangle.height) + 5;
    }

    private int getWidthAdjust(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2.x >= rectangle.x && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width) {
            return 0;
        }
        return rectangle2.x + rectangle2.width - (rectangle.x + rectangle.width) + 5;
    }

    public static void setWestPanel(JComponent jComponent) {
        westPanel = new JPanel();
        westPanel.add(jComponent);
        westPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 0, 0));
    }

    public static void doNotShowOnEntry(MenuElement[] menuElementArray) {
        for (MenuElement menuElement : menuElementArray) {
            MouseListener[] mouseListenerArray;
            Component component = menuElement.getComponent();
            for (MouseListener mouseListener : mouseListenerArray = component.getMouseListeners()) {
                if (!(mouseListener instanceof ShowOnEntry)) continue;
                component.removeMouseListener(mouseListener);
            }
            ToolTipOnDemand.doNotShowOnEntry(menuElement.getSubElements());
        }
    }

    public void showOnEntry(MenuElement[] menuElementArray) {
        for (MenuElement menuElement : menuElementArray) {
            if (menuElement.getComponent() instanceof JComponent) {
                JComponent jComponent = (JComponent)menuElement.getComponent();
                jComponent.addMouseListener(new ShowOnEntry(jComponent));
            }
            this.showOnEntry(menuElement.getSubElements());
        }
    }

    public boolean isMouseOver() {
        if (this.window != null) {
            Point point = this.window.getMousePosition();
            return point != null;
        }
        return false;
    }

    public void showWithoutCancelButton(JComponent jComponent, boolean bl, int n, int n2) {
        JButton jButton = this.cancel;
        this.cancel = null;
        this.show(jComponent, bl, n, n2);
        this.cancel = jButton;
    }

    public void shutOffCloseTimer() {
        this.insideTimer.stop();
    }

    protected class stillInsideTimerAction
    implements ActionListener {
        protected stillInsideTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ToolTipOnDemand.this.close();
        }
    }

    class MyToolTip
    extends JToolTip {
        private static final long serialVersionUID = 1L;

        MyToolTip() {
        }

        public void set(ToolTipUI toolTipUI) {
            super.setUI(toolTipUI);
            this.setOpaque(true);
        }
    }

    private class ShowOnEntry
    extends MouseAdapter {
        private final JComponent c;

        private ShowOnEntry(JComponent jComponent) {
            this.c = jComponent;
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!ToolTipOnDemand.isEmpty(this.c.getToolTipText())) {
                ToolTipOnDemand.this.hideTipWindow();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (!ToolTipOnDemand.isEmpty(this.c.getToolTipText())) {
                ToolTipOnDemand.this.showWithoutCancelButton(this.c, true, this.c.getWidth(), this.c.getHeight());
            }
        }
    }
}

