/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

import edu.stanford.facs.swing.Numeric;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class WebDownload {
    private static String DefaultGoogleDirUrl = "https://drive.google.com/file/d/1r_ByRnrq7SWvfLa2uGdwE31IY1ClXVdy/view?usp=sharing";
    public String googleDirUrl = null;
    public boolean allowCancel = true;
    public boolean waitWhenDone = true;
    public JProgressBar progressBar;
    public final JPanel panel;
    public final JLabel north;
    public final JLabel south;
    public final JButton close;
    public final JButton cancel;
    public JDialog dlg = null;
    final int readSize = 8192;
    public boolean cancelled = false;
    public boolean done = false;
    public int bad = 0;
    public Map<String, ArrayList<Con>> tooBigLocalFolderByRemoteFile = new HashMap<String, ArrayList<Con>>();
    public Map<String, HashSet<String>> tooBigLocalFolderByRemoteFolder = new HashMap<String, HashSet<String>>();
    public Collection<String> tooBigFiles = new ArrayList<String>();
    public final Collection<String> problems = new ArrayList<String>();
    public static Exception lastReachableException = null;

    public static String SetDefaultGoogleDirUrl(String string) {
        String string2 = DefaultGoogleDirUrl;
        DefaultGoogleDirUrl = string;
        return string2;
    }

    public static String SetDefaultGoogleDirFile(String string, Collection<String> collection) {
        String string2 = GoogleDriveDir.DefaultGoogleDirLocalFile;
        GoogleDriveDir.DefaultGoogleDirLocalFile = string;
        GoogleDriveDir.props = null;
        GoogleDriveDir.DownloadProps(null, collection);
        return string2;
    }

    public static String GetDefaultGoogleDirFile() {
        return GoogleDriveDir.DefaultGoogleDirLocalFile;
    }

    public static void main(String[] stringArray) {
        Test.main(stringArray);
    }

    public WebDownload() {
        this.googleDirUrl = DefaultGoogleDirUrl;
        this.progressBar = new JProgressBar();
        this.progressBar.setMaximum(100000);
        this.panel = new JPanel(new BorderLayout(10, 10));
        this.panel.add((Component)this.progressBar, "Center");
        this.panel.setBorder(BorderFactory.createEmptyBorder(15, 15, 2, 20));
        this.north = new JLabel();
        this.panel.add((Component)this.north, "North");
        this.south = new JLabel();
        this.panel.add((Component)this.south, "South");
        this.dlg = new JDialog();
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        this.dlg.setContentPane(jPanel);
        jPanel.add((Component)this.panel, "Center");
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebDownload.this.cancelled = true;
                WebDownload.this.dlg.setVisible(false);
            }
        });
        this.close = new JButton("Done");
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebDownload.this.dlg.setVisible(false);
            }
        });
        this.close.setEnabled(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.cancel);
        jPanel2.add(this.close);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "East");
        jPanel.add((Component)jPanel3, "South");
        this.dlg.setLocation(55, 200);
        this.dlg.setModal(true);
    }

    public String getProblemHtml() {
        return "<html><h3>Download problems encountered:</h3>" + WebDownload.HtmlList(this.problems) + "</html>";
    }

    void whine(String string) {
        WebDownload.Whine(this.problems, string);
    }

    static void Whine(Collection<String> collection, String string, Exception exception) {
        WebDownload.Whine(collection, string + ":  " + exception.getMessage());
    }

    static void Whine(Collection<String> collection, String string) {
        System.err.println(string);
        if (collection != null) {
            collection.add(string);
        }
    }

    public boolean go(final String[] stringArray, final String[] stringArray2, final boolean bl) {
        int n;
        this.problems.clear();
        this.cancelled = false;
        this.done = false;
        this.bad = 0;
        final int n2 = stringArray.length;
        if (n2 == 0) {
            this.whine("No file urls provided!");
            return false;
        }
        if (n2 != stringArray2.length) {
            this.whine(n2 + " file urls BUT " + stringArray2.length + " local files?");
            return false;
        }
        this.close.setEnabled(false);
        final String[] stringArray3 = new String[n2];
        for (int i = 0; i < n2; ++i) {
            n = stringArray[i].lastIndexOf(47);
            stringArray3[i] = n > 0 ? stringArray[i].substring(n + 1) : stringArray[i];
        }
        final String string = n2 > 1 ? n2 + " files" : "1 file";
        n = 0;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (stringArray3[i].length() <= n) continue;
            n = stringArray3[i].length();
            n3 = i;
        }
        this.north.setText("<html><b>Downloading " + (n3 + 1) + "/" + n2 + ": <font color='#008866['><i>" + stringArray3[n3] + "</i></font></b></html>");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                long l = 0L;
                byte[] byArray = new byte[8192];
                final Con[] conArray = new Con[n2];
                for (int i = 0; i < n2; ++i) {
                    String string4 = stringArray2[i];
                    File file = new File(string4);
                    File file2 = file.getParentFile();
                    if (file2 != null && !file2.getAbsoluteFile().exists()) {
                        final String string2 = "Local folder does not exist \"" + file.getParentFile().getPath() + "\"";
                        WebDownload.this.whine(string2);
                        WebDownload.this.cancelled = true;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                WebDownload.this.south.setText("<html><font color='red'>" + string2 + "</font></htmnl>");
                                if (bl) {
                                    WebDownload.this.dlg.pack();
                                }
                            }
                        });
                        return;
                    }
                    conArray[i] = WebDownload.this.connect(stringArray[i], WebDownload.this.problems);
                    if (conArray[i].http == null) continue;
                    l += conArray[i].size;
                    conArray[i].disconnect();
                }
                final long l2 = l;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WebDownload.this.south.setText(string + ", " + Numeric.encodeMb(l2));
                        if (bl) {
                            WebDownload.this.dlg.pack();
                        }
                    }
                });
                boolean bl3 = false;
                long l3 = 0L;
                for (int i = 0; i < n2; ++i) {
                    if (conArray[i].http == null) continue;
                    Con con = WebDownload.this.connect(stringArray[i], WebDownload.this.problems);
                    if (con.http == null) {
                        conArray[i].http = null;
                        continue;
                    }
                    String string5 = stringArray2[i];
                    boolean bl2 = true;
                    int n = 0;
                    try {
                        final int n22 = i;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (n2 == 1) {
                                    WebDownload.this.north.setText("<html><b>Downloading: <font color='#008866['><i>" + stringArray3[n22].replace("%20", " ") + "</i></font></b></html>");
                                } else {
                                    WebDownload.this.north.setText("<html><b>Downloading " + (n22 + 1) + "/" + n2 + ": <font color='#008866['><i>" + stringArray3[n22].replace("%20", " ") + "</i></font></b></html>");
                                }
                            }
                        });
                        long l4 = con.size;
                        InputStream inputStream = con.http.getInputStream();
                        try {
                            FileOutputStream fileOutputStream = new FileOutputStream(string5);
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 8192);
                            int n3 = 0;
                            while ((n3 = inputStream.read(byArray)) >= 0) {
                                final int n4 = (int)((double)(l3 += (long)n3) / (double)l2 * 100000.0);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        WebDownload.this.progressBar.setValue(n4);
                                    }
                                });
                                if (WebDownload.this.cancelled) {
                                    bl2 = false;
                                    break;
                                }
                                bufferedOutputStream.write(byArray, 0, n3);
                                n += n3;
                            }
                            if ((long)n != l4 && con.size > 0L) {
                                if (con.url.startsWith("https://drive.google.com/")) {
                                    bl3 = true;
                                }
                                if ((long)n < 10000L && con.size > 100352L && stringArray[i].startsWith("https://drive.google.com/")) {
                                    String string3 = new File(string5).getParent();
                                    AbstractCollection abstractCollection = WebDownload.this.tooBigLocalFolderByRemoteFile.get(string3);
                                    if (abstractCollection == null) {
                                        abstractCollection = new ArrayList();
                                        WebDownload.this.tooBigLocalFolderByRemoteFile.put(string3, (ArrayList<Con>)abstractCollection);
                                    }
                                    abstractCollection.add(con);
                                    if (con.folderUrl != null) {
                                        abstractCollection = WebDownload.this.tooBigLocalFolderByRemoteFolder.get(string3);
                                        if (abstractCollection == null) {
                                            abstractCollection = new HashSet();
                                            WebDownload.this.tooBigLocalFolderByRemoteFolder.put(string3, (HashSet<String>)abstractCollection);
                                        }
                                        ((HashSet)abstractCollection).add((Con)((Object)con.folderUrl));
                                    }
                                    WebDownload.this.tooBigFiles.add(string5);
                                }
                                System.err.println("" + n + " of " + l4 + " bytes downloaded!");
                            }
                            bufferedOutputStream.close();
                        }
                        catch (Exception exception) {
                            con.disconnect();
                            conArray[i].http = null;
                            bl2 = false;
                            WebDownload.this.whine("File output stream exception \"" + exception.getMessage() + "\"");
                        }
                        inputStream.close();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        WebDownload.this.whine("File not found: \"" + fileNotFoundException.getMessage() + "\"");
                        con.disconnect();
                        conArray[i].http = null;
                        bl2 = false;
                    }
                    catch (IOException iOException) {
                        WebDownload.this.whine("IO exception \"" + iOException.getMessage() + "\"");
                        con.disconnect();
                        conArray[i].http = null;
                        bl2 = false;
                    }
                    if (!bl2) {
                        File file = new File(string5);
                        if (file.exists()) {
                            file.delete();
                            System.err.println("Download incomplete, removed \"" + file.getAbsolutePath() + "\"");
                        }
                        conArray[i].http = null;
                    } else {
                        System.out.println("Download complete \"" + string5 + "\" " + Numeric.encodeK(n) + " bytes");
                    }
                    if (conArray[i] == null) continue;
                    con.disconnect();
                    if (WebDownload.this.cancelled) break;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!WebDownload.this.cancelled) {
                            WebDownload.this.done = true;
                        }
                        int n = 0;
                        for (int i = 0; i < n2; ++i) {
                            if (conArray[i].http != null) continue;
                            ++WebDownload.this.bad;
                            n = i;
                        }
                        if (WebDownload.this.bad > 0) {
                            if (WebDownload.this.bad == 1) {
                                WebDownload.this.south.setText("<html><font color='red'>Did <i><u>not</u></i> download \"<b>" + stringArray3[n] + "</b>\"</font>  ...</html>");
                            } else {
                                WebDownload.this.south.setText("<html><font color='red'>Could <i><u>not</u></i> download <b>" + WebDownload.this.bad + " files</b></font> ...</html>");
                            }
                            WebDownload.this.north.setText("<html><b>Downloaded</b>: <font color='#FF0088'><b>only " + (n2 - WebDownload.this.bad) + "</b></font>/" + n2 + " file(s)!</html>");
                            if (bl) {
                                WebDownload.this.dlg.pack();
                            }
                            String string = WebDownload.this.getProblemHtml();
                            WebDownload.this.north.setToolTipText(string);
                            WebDownload.this.progressBar.setToolTipText(string);
                            WebDownload.this.south.setToolTipText(string);
                            WebDownload.this.close.setToolTipText(string);
                        } else if (n2 == 1) {
                            WebDownload.this.north.setText("<html><b>Downloaded</b>: <font color='blue'>" + stringArray3[0] + "</font>!</html>");
                        } else {
                            WebDownload.this.north.setText("<html><b>Downloaded</b>: <font color='blue'>" + string + "</font>!</html>");
                        }
                        WebDownload.this.close.setEnabled(true);
                        WebDownload.this.cancel.setEnabled(false);
                        WebDownload.this.cancel.setVisible(false);
                        if (bl) {
                            WebDownload.this.dlg.getRootPane().setDefaultButton(WebDownload.this.close);
                            if (!WebDownload.this.waitWhenDone) {
                                WebDownload.this.close.doClick(900);
                            }
                        }
                    }
                });
                if (bl3) {
                    GoogleDriveDir.DownloadProps(WebDownload.this.googleDirUrl, WebDownload.this.problems);
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        if (bl) {
            this.cancel.setVisible(this.allowCancel);
            this.dlg.pack();
            this.dlg.setVisible(true);
            System.out.println("All done");
            return !this.cancelled;
        }
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return true;
    }

    public Con connect(String string, Collection<String> collection) {
        return GoogleDriveDir.Connect(string, this.googleDirUrl, collection);
    }

    public static HttpURLConnection GetConnection(String string, Collection<String> collection) {
        HttpURLConnection httpURLConnection = null;
        int n = 404;
        try {
            URL uRL = new URL(string);
            if (WebDownload.CanReachHost(uRL, collection)) {
                try {
                    httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setDoOutput(false);
                    httpURLConnection.setUseCaches(false);
                    httpURLConnection.setConnectTimeout(7000);
                    httpURLConnection.setReadTimeout(7000);
                    n = httpURLConnection.getResponseCode();
                }
                catch (IOException iOException) {
                    httpURLConnection = null;
                    WebDownload.Whine(collection, "IO exception: \"" + iOException.getMessage() + "\"");
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            WebDownload.Whine(collection, "Badly formed URL: \"" + string + "\"");
        }
        if (n != 200) {
            if (collection != null) {
                collection.add("Http response code " + n + " received!");
            }
            httpURLConnection = null;
        }
        return httpURLConnection;
    }

    public static boolean FileExists(String string) {
        return WebDownload.FileExists(string, null);
    }

    public static boolean FileExists(String string, Collection<String> collection) {
        boolean bl = false;
        HttpURLConnection httpURLConnection = WebDownload.GetConnection(string, collection);
        if (httpURLConnection != null) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
                bufferedInputStream.close();
                bl = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                WebDownload.Whine(collection, "File not found: \"" + fileNotFoundException.getMessage() + "\"");
            }
            catch (IOException iOException) {
                WebDownload.Whine(collection, "IO exception: \"" + iOException.getMessage() + "\"");
            }
            httpURLConnection.disconnect();
        }
        return bl;
    }

    public static boolean CanReachHost(URL uRL, Collection<String> collection) {
        boolean bl;
        String string = uRL.getHost();
        if (string == null || string.trim().length() == 0) {
            bl = false;
            WebDownload.Whine(collection, "Can not parse host name from \"" + uRL.toExternalForm() + "\"");
        } else {
            bl = WebDownload.CanReachHost(string, uRL.getPort(), 4500, collection);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean CanReachHost(String string, int n, int n2, Collection<String> collection) {
        if (n < 0) {
            n = 80;
        }
        lastReachableException = null;
        Socket socket = new Socket();
        boolean bl = true;
        if (n2 == 0) {
            n2 = 9000;
        }
        String string2 = "Can not reach host \"" + string + ":" + n + "  because \"";
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            socket.connect(inetSocketAddress, n2);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            bl = false;
            lastReachableException = socketTimeoutException;
            WebDownload.Whine(collection, string2, socketTimeoutException);
        }
        catch (IOException iOException) {
            bl = false;
            lastReachableException = iOException;
            WebDownload.Whine(collection, string2, iOException);
        }
        catch (RuntimeException runtimeException) {
            bl = false;
            lastReachableException = runtimeException;
            WebDownload.Whine(collection, string2, runtimeException);
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                WebDownload.Whine(collection, string2, iOException);
            }
        }
        return bl;
    }

    static String HtmlList(Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<ol>");
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append("<li>");
            stringBuilder.append(iterator.next());
        }
        stringBuilder.append("</ol>");
        return stringBuilder.toString();
    }

    public static Object ConvertToGoogleDirectDownloadIfNecessary(String string) {
        return GoogleDriveDir.ConvertSharingToExportIfNecessary(string);
    }

    public static Object GoogleDirectDownloadLink(String string) {
        return WebDownload.GoogleDirectDownloadLink(string, DefaultGoogleDirUrl);
    }

    public static Object GoogleDirectDownloadLink(String string, String string2) {
        return GoogleDriveDir.GetDirectDownloadLink(string, string2);
    }

    public static class GoogleDriveDir {
        final String url;
        final long size;
        public static Properties props;
        public static String DefaultGoogleDirLocalFile;
        public static final String export = "https://drive.google.com/uc?export=download&id=";
        public static final String drive = "https://drive.google.com/";
        public static final String sharingStart = "https://drive.google.com/file/d/";
        public static final String sharingEnd = "/view?usp=sharing";
        static int warned;

        GoogleDriveDir(String string) {
            this(string, -1L);
        }

        GoogleDriveDir(String string, long l) {
            this.url = string;
            this.size = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean ReadProps() {
            if (props == null) {
                props = new Properties();
            } else {
                props.clear();
            }
            FileInputStream fileInputStream = null;
            String string = GoogleDriveDir.GetPropsFileName();
            try {
                fileInputStream = new FileInputStream(new File(string));
                props.load(fileInputStream);
                System.out.println("Loaded \"" + string + "\"");
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Problem loading \"" + string + "\"");
                boolean bl = false;
                return bl;
            }
            catch (IOException iOException) {
                System.err.println("Problem loading \"" + string + "\"");
                boolean bl = false;
                return bl;
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                System.err.println("Problem loading \"" + string + "\"");
                boolean bl = false;
                return bl;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            return true;
        }

        public static String GetPropsFileName() {
            if (DefaultGoogleDirLocalFile == null) {
                String string;
                String string2 = System.getProperty("user.home");
                DefaultGoogleDirLocalFile = string = string2 + File.separator + ".googleDriveDir.properties";
            }
            return DefaultGoogleDirLocalFile;
        }

        public static boolean DownloadProps(String string, Collection<String> collection) {
            if (string == null) {
                string = DefaultGoogleDirUrl;
            }
            WebDownload webDownload = new WebDownload();
            webDownload.allowCancel = false;
            webDownload.waitWhenDone = true;
            boolean bl = webDownload.go(new String[]{string}, new String[]{GoogleDriveDir.GetPropsFileName()}, false);
            if (collection != null) {
                collection.addAll(webDownload.problems);
            }
            if (bl) {
                return GoogleDriveDir.ReadProps();
            }
            return false;
        }

        public static Con Connect(String string, String string2, Collection<String> collection) {
            Con con = null;
            if (string.startsWith(drive)) {
                int n = string.indexOf(63);
                if (n <= 0) {
                    String string3 = string.substring(drive.length());
                    boolean bl = false;
                    if (props == null && !GoogleDriveDir.ReadProps()) {
                        bl = true;
                        if (!GoogleDriveDir.DownloadProps(string2, collection)) {
                            System.err.println("Can not read/download " + GoogleDriveDir.GetPropsFileName());
                        }
                    }
                    if (!props.containsKey(string3) && !bl) {
                        bl = true;
                        GoogleDriveDir.DownloadProps(string2, collection);
                    }
                    if (props.containsKey(string3)) {
                        String string4 = props.getProperty(string3).trim();
                        int n2 = string4.indexOf(32);
                        if (n2 < 1 && !bl) {
                            System.err.println("Redownloading corrupt-ish googleDir file");
                            GoogleDriveDir.DownloadProps(string2, collection);
                        }
                        if ((n2 = (string4 = props.getProperty(string3).trim()).indexOf(32)) > 0) {
                            String string5 = string4.substring(0, n2);
                            String string6 = string4.substring(n2 + 1).trim();
                            String string7 = GoogleDriveDir.ConvertSharingToExportIfNecessary(string6);
                            try {
                                int n3;
                                long l = Long.parseLong(string5);
                                con = new Con(string7, l, collection);
                                con.sharingUrl = string6;
                                con.driveKey = string;
                                String string8 = new File(string3).getParent();
                                string8 = props.getProperty(string8);
                                if (string8 != null && (n3 = string8.indexOf(32)) > 0) {
                                    con.folderUrl = string8.substring(n3 + 1).trim();
                                }
                            }
                            catch (Exception exception) {}
                        } else {
                            System.err.println("The Google Drive key\"" + string3 + "\" has malformed value \"" + string4 + "\"");
                        }
                    }
                    if (con == null) {
                        con = new Con("bad", -1L, collection);
                    }
                } else {
                    con = new Con(GoogleDriveDir.ConvertSharingToExportIfNecessary(string), -1L, collection);
                }
            }
            if (con == null) {
                con = new Con(string, -1L, collection);
            }
            return con;
        }

        public static String ConvertSharingToExportIfNecessary(String string) {
            int n;
            if (string.startsWith(sharingStart) && (n = string.indexOf(sharingEnd)) > 0) {
                String string2 = string.substring(sharingStart.length(), n);
                String string3 = export + string2;
                if (warned++ < 3) {
                    System.out.println("Changed url to internal Google Drive export format... ");
                    System.out.println("... NOTE that both file and parent folder must ALSO be shared to everyone!!");
                }
                return string3;
            }
            return string;
        }

        public static String GetDirectDownloadLink(String string, String string2) {
            int n;
            if (string.startsWith(drive) && (n = string.indexOf(63)) <= 0) {
                String string3 = string.substring(drive.length());
                boolean bl = false;
                Collection<String> collection = null;
                if (props == null && !GoogleDriveDir.ReadProps()) {
                    bl = true;
                    if (!GoogleDriveDir.DownloadProps(string2, collection)) {
                        System.err.println("Can not read/download " + GoogleDriveDir.GetPropsFileName());
                    }
                }
                if (!props.containsKey(string3) && !bl) {
                    bl = true;
                    GoogleDriveDir.DownloadProps(string2, collection);
                }
                if (props.containsKey(string3)) {
                    String string4 = props.getProperty(string3).trim();
                    int n2 = string4.indexOf(32);
                    if (n2 < 1 && !bl) {
                        System.err.println("Redownloading corrupt-ish googleDir file");
                        GoogleDriveDir.DownloadProps(string2, collection);
                    }
                    if ((n2 = (string4 = props.getProperty(string3).trim()).indexOf(32)) > 0) {
                        String string5 = string4.substring(0, n2);
                        return GoogleDriveDir.ConvertSharingToExportIfNecessary(string4.substring(n2 + 1));
                    }
                    System.err.println("The Google Drive key\"" + string3 + "\" has malformed value \"" + string4 + "\"");
                }
            }
            return string;
        }

        static {
            DefaultGoogleDirLocalFile = null;
            warned = 0;
        }
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            String[] stringArray2;
            String[] stringArray3;
            WebDownload.SetDefaultGoogleDirUrl("https://drive.google.com/file/d/1r_ByRnrq7SWvfLa2uGdwE31IY1ClXVdy/view?usp=sharing");
            ArrayList<String> arrayList = new ArrayList<String>();
            WebDownload.SetDefaultGoogleDirFile("/Users/swmeehan/myGoogleDir.properties", arrayList);
            Object object = WebDownload.GoogleDirectDownloadLink("http://cgworkspace.cytogenie.org/GetDown2/domains/FACS/AutoGate2020a.tar");
            WebDownload webDownload = new WebDownload();
            webDownload.allowCancel = false;
            webDownload.waitWhenDone = true;
            String string = "https://drive.google.com/Samples/OMIP40Color/MC%203015036.fcs";
            String string2 = "https://drive.google.com/Samples/OMIP40Color/MC%20303444.fcs";
            WebDownload.SetDefaultGoogleDirUrl("https://drive.google.com/file/d/duh/view?usp=sharing");
            String string3 = WebDownload.SetDefaultGoogleDirFile("/Users/swmeehan/foobar.properties", new ArrayList<String>());
            webDownload.go(new String[]{string2}, new String[]{"/Users/swmeehan/omip40_2nd.fcs"}, true);
            webDownload.go(new String[]{string}, new String[]{"/Users/swmeehan/omip40_1st.fcs"}, true);
            WebDownload.SetDefaultGoogleDirFile(string3, new ArrayList<String>());
            string = "https://drive.google.com/uc?export=download&id=189nZplhvj804H2M4KPBz6vjU2JOTvHCk";
            webDownload.go(new String[]{"https://drive.google.com/run_umap/examples/ust_s1_samusikImported_29D_30nn_2D.mat"}, new String[]{"/Users/swmeehan/s10.csv"}, true);
            string2 = "https://filetransfer.io/data-package/GGamU3ZY?do=download";
            webDownload.connect("https://drive.google.com/file/d/189nZplhvj804H2M4KPBz6vjU2JOTvHCk/view?usp=sharing", null);
            if (stringArray.length < 3) {
                int n;
                System.out.println("Demo download from http://54.39.2.45/run_umap/examples/...");
                String string4 = System.getProperty("user.home");
                String[] stringArray4 = new String[]{"s3_samusikManual_19D", "s4_samusikManual_19D", "s5_samusikManual_s19D"};
                stringArray3 = new String[stringArray4.length * 2];
                String string5 = string4 + File.separator + "Documents" + File.separator + "run_umap" + File.separator + "examples" + File.separator;
                stringArray2 = new String[stringArray4.length * 2];
                for (n = 0; n < stringArray4.length; ++n) {
                    stringArray3[n] = "http://54.39.2.45/run_umap/examples/" + stringArray4[n] + ".csv";
                    stringArray2[n] = string5 + stringArray4[n] + ".csv";
                }
                for (n = 0; n < stringArray4.length; ++n) {
                    stringArray3[stringArray4.length + n] = "http://54.39.2.45/run_umap/examples/" + stringArray4[n] + ".properties";
                    stringArray2[stringArray4.length + n] = string5 + stringArray4[n] + ".properties";
                }
            } else {
                if (stringArray.length % 2 != 1) {
                    System.err.println("USAGE:  " + stringArray[0] + " 1 or more pairs of URL source and local file destintation");
                    return;
                }
                int n = (stringArray.length - 1) / 2;
                stringArray3 = new String[n];
                stringArray2 = new String[n];
                for (int i = 1; i < n; i += 2) {
                    stringArray3[i] = stringArray[i];
                    stringArray2[i] = stringArray[i + 1];
                }
            }
            System.out.println("Checking main arguments first");
            for (int i = 0; i < stringArray3.length; ++i) {
                if (WebDownload.FileExists(stringArray3[i])) continue;
                System.out.println("Downloading looks unlikely for \"" + stringArray3[i] + "\"");
            }
            webDownload.go(stringArray3, stringArray2, true);
        }
    }

    public static class Con {
        public HttpURLConnection http;
        public final String url;
        public String driveKey;
        public String sharingUrl;
        public String folderUrl;
        public final long size;

        Con(String string) {
            this(string, -1L);
        }

        Con(String string, long l) {
            this(string, l, null);
        }

        Con(String string, long l, Collection<String> collection) {
            int n;
            this.url = string;
            if (this.url.equals("bad")) {
                this.size = -1L;
                return;
            }
            this.http = WebDownload.GetConnection(string, collection);
            this.size = this.http != null && l < 0L ? (long)this.http.getContentLength() : (this.http != null ? ((n = this.http.getContentLength()) > 0 && (long)n != l ? (long)n : l) : -1L);
        }

        public void disconnect() {
            if (this.http != null) {
                this.http.disconnect();
            }
        }
    }
}

