/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.facs.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class XYLayout
implements LayoutManager {
    Dimension originalMinimumSize;
    public Vector<Component> components = new Vector(10, 10);
    public Vector<Point> constraints = new Vector(10, 10);
    final JPanel originalPanel;

    public XYLayout(Dimension dimension, JPanel jPanel) {
        this.originalMinimumSize = dimension;
        this.originalPanel = jPanel;
        jPanel.setLayout(this);
    }

    public void add(JComponent jComponent, int n, int n2, int n3, int n4) {
        this.originalPanel.add(jComponent);
        this.components.addElement(jComponent);
        this.constraints.addElement(new Point(n, n2));
        jComponent.setPreferredSize(new Dimension(n3, n4));
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.components.addElement(component);
        this.constraints.addElement(null);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        int n = this.components.indexOf(component);
        if (n != -1) {
            this.components.removeElementAt(n);
            this.constraints.removeElementAt(n);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.originalMinimumSize;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.originalMinimumSize;
    }

    public void setConstraint(Component component, int n, int n2) {
        int n3 = this.components.indexOf(component);
        if (n3 != -1) {
            Point point = new Point(n, n2);
            this.constraints.setElementAt(point, n3);
            this.reshape(n3);
        }
    }

    public void debug() {
        Enumeration<Component> enumeration = this.components.elements();
        int n = -1;
        while (enumeration.hasMoreElements()) {
            Point point = this.constraints.elementAt(++n);
            Component component = enumeration.nextElement();
            Dimension dimension = component instanceof JComponent ? ((JComponent)component).getPreferredSize() : component.preferredSize();
            System.out.println(" constr=" + point + ", component=" + component);
        }
    }

    @Override
    public void layoutContainer(Container container) {
        System.out.println("TARGET " + container.bounds() + " " + container.getLocation() + " " + container.getSize());
        Container container2 = container.getParent();
        System.out.println("PARENT " + container2.bounds() + " " + container2.getLocation() + " " + container2.getSize());
        for (int i = 0; i < this.components.size(); ++i) {
            this.reshape(i);
        }
    }

    private void reshape(int n) {
        Point point = this.constraints.elementAt(n);
        Component component = this.components.elementAt(n);
        Dimension dimension = ((JComponent)component).getPreferredSize();
        System.out.println(" constr=" + point + ", d=" + dimension + ", component=" + component);
        component.reshape(point.x, point.y, dimension.width, dimension.height);
    }

    public static XYLayout layoutAutoComplete(JPanel jPanel, JComponent jComponent, JComboBox jComboBox) {
        return XYLayout.layoutAutoComplete(jPanel, jComponent, jComboBox, 0, 0);
    }

    public static XYLayout layoutAutoComplete(JPanel jPanel, JComponent jComponent, JComboBox jComboBox, int n, int n2) {
        return XYLayout.layoutAutoComplete(jPanel, jComponent, jComboBox, 0, 0, n, n2);
    }

    public static XYLayout layoutAutoComplete(JPanel jPanel, JComponent jComponent, JComboBox jComboBox, int n, int n2, int n3, int n4) {
        Dimension dimension = jComponent.getPreferredSize();
        return XYLayout.layoutAutoComplete(jPanel, jComponent, jComboBox, n, n2, dimension.width, dimension.height, n3, n4);
    }

    public static XYLayout layoutAutoComplete(JPanel jPanel, JComponent jComponent, JComboBox jComboBox, int n, int n2, int n3, int n4, int n5, int n6) {
        XYLayout xYLayout = new XYLayout(new Dimension(n3, n4), jPanel);
        xYLayout.add(jComponent, n, n2, n3, n4);
        xYLayout.add(jComboBox, n + n5 / 2, n2 + n6, n3 - n5, n4);
        return xYLayout;
    }
}

