
function add_GFP_label_MR(fname)
% load basecalled soma data and filt_neurons-bc, add soma bc data.
% this should run after adding non-soma bc data, but also has the option of
% running without callin bc rolonies.
if ~exist('fname','var')
    fname='filt_neurons.mat';
end
try
    S=load(fname);
    filt_neurons=S.filt_neurons;
catch ME
    fprintf('Can\''t load filt_neurons, abort.\n' );
    rethrow(ME);
end
try
    T=load('all_cells_GFP_intensity.mat');
    sig=T.sig';
    cellid=(T.cellid');
catch ME
    fprintf('Can\''t load GFP information, abort.\n' );
    rethrow(ME);
end

for n=1:numel(cellid)
    cellid{n}=double(cellid{n})+n*10000;%restore id in filt_neurons
end
cellid_ex=cell2mat(cellid(~cellfun(@isempty,cellid)));
sig_ex=cell2mat(sig(~cellfun(@isempty,cellid)));

[~,I]=ismember(filt_neurons.id,cellid_ex);
if sum(I==0)>0
    error('Some filt_neuron ids don\''t match soma cellid, check for errors.\n');
else
    filt_neurons.soma_GFP_sig=sig_ex(I,:,:);
end

save('filt_neurons-GFPcalled.mat','filt_neurons','-v7.3');
end
