
function add_singlebc(count_thresh,err_corr_thresh,filtneuron_fname)

if ~exist('filtneuron_fname','var')
    filtneuron_fname='filt_neurons.mat';
end

load(filtneuron_fname,'filt_neurons');


folders=get_folders();
dom_bc=cell(numel(folders),1);
all_bc=cell(numel(folders),1);
all_bc_count=cell(numel(folders),1);
dom_bc_count=cell(numel(folders),1);

load('allsegmentation.mat','celllist');
load('bccellid.mat','bccellid');
load('bc.mat','bcseq','bcscore','bcint','bcsig','bclroi')


parfor i=1:numel(folders)
    
    dom_bc{i}={};
    dom_bc_count{i}=zeros(numel(celllist{i}),1);
    all_bc{i}={};
    all_bc_count{i}={};

    for n=1:numel(celllist{i})

        if ~isnan(count_thresh)&&sum(bccellid{i}==celllist{i}(n))>count_thresh % if more than threshold number of bc, then count bc molecules
            
            bc=bcseq{i}(bccellid{i}==celllist{i}(n),:); %all barcode sequences in that cell.
            %collapse simialr barcodes.

            [uniqbc,~,ic]=unique(bc,'rows');
            c1=histcounts(ic,[0;unique(ic)]+0.5);
            [sortedc1,I]=sort(c1,'descend');
            uniqbc=uniqbc(I,:); %sorted by abundunce within the cell

            bclist=uniqbc(1,:);bccount=sortedc1(1);
            
            if size(uniqbc,1)>0
                for m=2:size(uniqbc,1)
                    [min_d,I]=min(pdist2(bclist,uniqbc(m,:),'hamming')*size(uniqbc,2));
                    if min_d<=err_corr_thresh
                        bccount(I)=bccount(I)+sortedc1(m);
                    else
                        bclist(end+1,:)=uniqbc(m,:);
                        bccount(end+1)=sortedc1(m);
                    end
                end
            end
            
            [~,I]=max(bccount);
            bclist=int8(bclist);

            if bccount(I)>count_thresh
                dom_bc{i}{n}=bclist(I,:);
                dom_bc_count{i}(n)=bccount(I);
                all_bc{i}{n}=bclist;
                all_bc_count{i}{n}=bccount;
            else
                dom_bc{i}{n}=[];
                dom_bc_count{i}(n)=0;
                all_bc{i}{n}=[];
                all_bc_count{i}{n}=0;
            end
        else
                dom_bc{i}{n}=[];
                dom_bc_count{i}(n)=0;
                all_bc{i}{n}=[];
                all_bc_count{i}{n}=0;
        end

    end

end
save('cellbc.mat','dom_bc','all_bc');

% combine barcode information with neurons
if ~isnan(count_thresh)
    
    filt_neurons.dom_bc=cell(numel(filt_neurons.id),1);
    filt_neurons.dom_bc_count=zeros(numel(filt_neurons.id),1);
    filt_neurons.all_bc=cell(numel(filt_neurons.id),1);
    filt_neurons.all_bc_count=cell(numel(filt_neurons.id),1);
    
    for i=1:numel(dom_bc)
        [~,I]=ismember(double(celllist{i})+i*10000,filt_neurons.id);
        filt_neurons.dom_bc(I(I>0))=dom_bc{i}(I>0);
        filt_neurons.dom_bc_count(I(I>0))=dom_bc_count{i}(I>0);
        filt_neurons.all_bc(I(I>0))=all_bc{i}(I>0);
        filt_neurons.all_bc_count(I(I>0))=all_bc_count{i}(I>0);
    end
else % if count_thresh is nan, then assign soma_bc to dom_bc and all_bc
    filt_neurons.dom_bc=soma_bc;
    filt_neurons.all_bc=soma_bc;
    filt_neurons.dom_bc_count=ones(numel(filt_neurons.id),1);
    filt_neurons.all_bc_count=ones(numel(filt_neurons.id),1);
        
end
filt_neurons=lean_neurons(filt_neurons);
filt_neurons=add_uid(filt_neurons);

save('filt_neurons-bc-somas.mat','filt_neurons','-v7.3');

end
