function [cellid,sig]=basecall_GFP_somas_mr(thread_num)
%using segmented images, call barcodes from cells based on INTENSITY. 
if ~exist('thread_num','var')
    thread_num=18;
end

folders=get_folders();
cellid={}; sig={};
parfor(i=1:numel(folders),thread_num)
%for i=1:numel(folders)
    %load cell mask
    original_dir=cd(fullfile(folders{i},'aligned'));
    S=load('cellmask.mat');
    maski=S.maski;
    [cellid1,sig1]=GFPcallcells_mr('hyb',maski); % this is based on mean signal in segmented somas
    m=matfile('GFPsoma.mat','Writable',true)
    m.cellid1=cellid1;
    m.sig1=sig1;

    cellid{i}=cellid1;
    sig{i}=sig1;
    
    cd(original_dir)
end

save('all_cells_GFP_intensity.mat', ...
    'cellid', ...
    'sig');



