function [cellid,seq,seqC,sig,score,seq_hd,seqC_hd,sig_hd,score_hd]=basecall_somas_xt(thread_num)
%using segmented images, call barcodes from cells based on INTENSITY. 
if ~exist('thread_num','var')
    thread_num=18;
end

folders=get_folders();
cellid={}; seq={};seqC={};sig={};score={};
seq_hd={};seqC_hd={};sig_hd={};score_hd={};
parfor(i=1:numel(folders),thread_num)
%for i=1:numel(folders)
    %load cell mask
    original_dir=cd(fullfile(folders{i},'aligned'));
    S=load('cellmask.mat');
    maski=S.maski;
    [cellid1,seq1,seqC1,sig1,score1,seq2,seqC2,sig2,score2]=mmbasecallcells_xt('bcseq',maski); % this is based on mean signal in segmented somas
    m=matfile('bcsoma.mat','Writable',true)
    m.cellid1=cellid1;
    m.seq1=seq1;
    m.sig1=sig1;
    m.seqC1=seqC1;
    m.score1=score1;
    m.seq2=seq2;
    m.seqC2=seqC2;
    m.sig2=sig2;
    m.score2=score2;

    cellid{i}=cellid1;
    seq{i}=seq1;
    seqC{i}=seqC1;
    sig{i}=sig1;
    score{i}=score1;
    seq_hd{i}=seq2;
    seqC_hd{i}=seqC2;
    sig_hd{i}=sig2;
    score_hd{i}=score2;
    
    cd(original_dir)
end

save('all_bccells_intensity.mat', ...
    'cellid', ...
    'seq','seqC','sig','score', ...
    'seq_hd','seqC_hd','sig_hd','score_hd');



