
function generate_stitched_image(fname,tformfname,scaling)
[folders,pos]=get_folders();
if ~exist('scaling','var')
    scaling=1;
end

if ~exist('tformfname','var')
    tformfname='40xto10x.mat';
end

load(tformfname,'tform40xto10x');
reg_folder_name='checkregistration';
mkdir(reg_folder_name)
uniqpos=sort_nat(unique(pos));
[~,posidx]=ismember(pos,uniqpos);
%
f=dir([folders{1},'/',fname,'.tif']);
f={f.name};

fileinfo=imfinfo(fullfile(folders{1},f{1}));

%check if the 10x folder is present
for i=1:numel(uniqpos)
    %get image size
    %%
    subfolders=find(posidx==i);

    T=zeros(numel(subfolders),2);
    for n=1:numel(subfolders)
        %calculate the expected 10x image size using the tforms.
        T(n,:)=tform40xto10x{subfolders(n)}.T(3,1:2);
    end
    max_T=max(T,[],1);%max translations, always positive
    uniq_x=numel(unique(floor(T(:,1)/1000))); % count number of tiles on x and y
    uniq_y=numel(unique(floor(T(:,2)/1000)));
    T_step=max_T./[uniq_x-1,uniq_y-1];%mean per tile translation
    im=repmat({zeros(ceil(T_step(2)*uniq_y+1),ceil(T_step(1)*uniq_x+1),numel(fileinfo),'uint16')},numel(f),1);% make this tile num +1 so to accomodate the edge of the last image.

    %%
    for n=1:numel(subfolders)

        imgfiles=dir([folders{subfolders(n)},'/',fname,'.tif']);

        imgfiles={imgfiles.name};
        for m=1:numel(imgfiles)

            im1=imread([folders{subfolders(n)},'/',imgfiles{m}]);
            if numel(fileinfo)>1
                for nn=2:numel(fileinfo)
                    im1(:,:,nn)=imread([folders{subfolders(n)},'/',imgfiles{m}],nn);
                end
            im1=imwarp(im1,tform40xto10x{subfolders(n)},'OutputView',imref2d([size(im{m},1),size(im{m},2)]));
            im1(1:10,1:10,:)=150;%add a border so that it's easy to count
            im{m}=max(im{m},im1);
        end
    end
    
    %%
    for m=1:numel(im)

        im_small=imresize(uint16(im{m}*scaling),0.2);
        if numel(fileinfo)==1
        imwrite(im_small,[reg_folder_name,'/',uniqpos{i},f{m}(1:end-4),'.tif']);
        else
            imwrite(im_small(:,:,1),[reg_folder_name,'/',uniqpos{i},f{m}(1:end-4),'.tif']);
            for nn=2:numel(fileinfo)
                imwrite(im_small(:,:,nn), ...
                    [reg_folder_name,'/',uniqpos{i},f{m}(1:end-4),'.tif'], ...
                    'WriteMode','Append');
            end
        end
    end
end

    fprintf('Stitched images in folder: checkregistration. Visually check to make sure they are registered correctly.\n')

end