
function organize_bc_rolonies()

% if ~exist('filtneuron_fname','var')
%     filtneuron_fname='filt_neurons.mat';
% end
% 
% load(filtneuron_fname,'filt_neurons');


[folders,pos]=get_folders();

load('bclroi10x.mat','bclroi10x');
load('bc.mat','bcseq','bcscore','bcint','bcsig','bclroi')
load('slice_num_list.mat','slice_num_list');
load('batches.mat','batches');
% bc
bc=struct;
bc.pos40x=cell2mat(bclroi');
bc.pos=cell2mat(bclroi10x');
bc.slice=[];
bc.seq=cell2mat(bcseq');
bc.qual=cell2mat(bcscore');
bc.int=cell2mat(bcint');
bc.sig=cell2mat(bcsig');
%

% startingsliceidx=min(filt_neurons.slice);

%uniqpos=sort_nat(unique(pos));
[~,posidx]=ismember(pos,slice_num_list.uniqpos);
bcslice={};
bcfov={};
parfor i=1:numel(bclroi)
    bcslice{i}=double(ones(size(bclroi{i},1),1))*double(slice_num_list.slice_num(posidx(i))); %bcslice is numbered incrementally from the smallest slice number in filt_neurons.
    bcfov{i}=double(ones(size(bclroi{i},1),1))*(i);
end

bc.slice=cell2mat(bcslice');

[~,~,idx]=unique(bc.slice);
bc.batch_num=batches(idx);
if size(bc.batch_num,1)<size(bc.batch_num,2)
    bc.batch_num=bc.batch_num';
end

% if exist('slice_num','var') %update slice_num if provided
%     orig_slice_num=sort(unique(bc.slice),'ascend');
%     if numel(slice_num)==numel(orig_slice_num)
%         [~,I]=ismember(bc.slice,orig_slice_num);%get the index in the original set of slice numbers
%         bc.slice=slice_num(I);%index to the new set of slice numbers
%     else
%         warning('Provided slice_num do not match the number of slices, using default slice_num.\n');
%     end
% end
    
bc.fov=cell2mat(bcfov');
bc.fov_names=folders;

bc=lean_bc(bc);
bc=add_uid(bc);

save('bc-rolonies.mat','bc','-v7.3');

end
