function quickstitch(cycle_names,ch,cam_width,overlap)
% "stitch" tiles based on relative positions without doing registration
% cycle_names: which cycles to stitch, cell array with folder names
% ch: channels to stitch, array of numbers.
% cam_width: width of the camera. This is 3200 on all microscopes except
% 2048 on the small scope. Default to 3200.
% overlap: fraction of overlap between adjacent tiles. Default 0.23.
if ~exist('cam_width','var')
    cam_width=3200;
end

if ~exist('overlap','var')
    overlap=0.1;
end

javaaddpath('C:\barseq_envs\FIJI_jar\mij.jar')
if ~exist('cycle_names','var')
    % if no folder names, then get all folders
    cycle_names=dir('*');
    cycle_names={cycle_names([cycle_names.isdir]).name};
    cycle_names=cycle_names(~contains(cycle_names,'.'));
elseif isempty(cycle_names)
    cycle_names=dir('*');
    cycle_names={cycle_names([cycle_names.isdir]).name};
    cycle_names=cycle_names(~contains(cycle_names,'.'));

end

if ~exist('ch','var')
    ch=[];
end

if contains(cycle_names{1},{'seq','hyb'})
for nn=1:numel(cycle_names)
    cd(cycle_names{nn})
    stitch_manual(ch,cam_width,overlap);
    cd ..
end
elseif contains(cycle_names{1},'MAX')
    
    cd(cycle_names{1})
    imfnames=dir('*.tif');
    imfnames={imfnames.name};
    cd ..
    for nn=1:numel(imfnames)
        refch=4;
        niestitch_mist(imfnames{nn}(1:end-4),refch,overlap);
        read_mist_results(imfnames{nn}(1:end-4),0.5);
        generate_stitched_image(imfnames{nn}(1:end-4));
    end
end


%%
end

function stitch_manual(ch,cam_width,overlap)
output_dir=fullfile('stitched');
mkdir(output_dir)
%%
fnames=dir('Max*.tif');
fnames={fnames.name};
%% get x y pos
pos=zeros(numel(fnames),1);
x=pos;y=pos;
translations=zeros(numel(fnames),2);

for i=1:numel(fnames)
    idx1=regexp(fnames{i},'_|_Pos|\.');
    pos(i)=str2double(fnames{i}((idx1(1)+4):(idx1(2)-1)));
    x(i)=str2double(fnames{i}((idx1(2)+1):(idx1(3)-1)));
    y(i)=str2double(fnames{i}((idx1(3)+1):(idx1(4)-1)));
    %translations(i,:)=[-x(i)*2463.5-6*y(i),2471*y(i)+5*x(i)];
    translations(i,:)=[-x(i)*cam_width*(1-overlap)-6*y(i),cam_width*(1-overlap)*y(i)+5*x(i)];

end
uniq_pos=unique(pos);
for i=1:numel(uniq_pos)
    translations(pos==uniq_pos(i),:)=translations(pos==uniq_pos(i),:)-min(translations(pos==uniq_pos(i),:));
end
tforms={};
for i=1:numel(fnames)
    tforms{i}=affine2d([1 0 0;0 1 0;translations(i,:),1]);
end


save('tforms.mat','tforms','pos','x','y')
% change all transformations to positives


trim=200;

if ~isempty(ch)
    all_ch=ch;
else
    imfiles=dir('*.tif');
    imfiles={imfiles.name};
    iminfo=imfinfo(imfiles{1});
    all_ch=1:(numel(iminfo));
end

for mm=1:numel(all_ch)
    ch=all_ch(mm);
    parfor i=1:numel(uniq_pos)
        in_slice=find(pos==uniq_pos(i));
        max_tform=max(translations(in_slice,:));

        stitched_img=zeros([round(max_tform(2)+3200),round(max_tform(1)+3200)],'uint16');
        RA=imref2d(size(stitched_img));
        for n=1:numel(in_slice)
            im=imread(fnames{in_slice(n)},ch);
            im([1:trim,end-trim:end],:)=0;
            im(:,[1:trim,end-trim:end])=0;

            stitched_img=max(stitched_img,imwarp(im,tforms{in_slice(n)},'OutputView',RA));
        end
        try
            imwrite(stitched_img,fullfile(output_dir,['Pos',num2str(uniq_pos(i)),'ch',num2str(ch),'.tif']));
        catch
            imwrite_big(stitched_img,fullfile(output_dir,['Pos',num2str(uniq_pos(i)),'ch',num2str(ch),'.tif']));
        end

    end
end
end
%


%%
