function restore_manual_files()
% run this in processed to restore original files to folders in the format
% of a manual run
cd ..
root_folder=pwd;
cd processed

folders=get_folders();
for nn=1:numel(folders)
    cd(folders{nn});
    gene_fnames=dir('geneseq*.tif');
    gene_fnames={gene_fnames.name};
    hyb_fnames=dir('hyb*.tif');
    hyb_fnames={hyb_fnames.name};
    
    bc_fnames=dir('bcseq*.tif');
    bc_fnames={bc_fnames.name};

    for mm=1:numel(gene_fnames)
        if nn==1
            mkdir(fullfile(root_folder,gene_fnames{mm}(1:end-4)))
        end
        movefile(gene_fnames{mm},fullfile('..','..',gene_fnames{mm}(1:end-4),folders{nn}+".tif"));
    end
    for mm=1:numel(hyb_fnames)
        if nn==1
            mkdir(fullfile(root_folder,hyb_fnames{mm}(1:end-4)))
        end
        movefile(hyb_fnames{mm},fullfile('..','..',hyb_fnames{mm}(1:end-4),folders{nn}+".tif"));
    end
    for mm=1:numel(bc_fnames)
        if nn==1
            mkdir(fullfile(root_folder,bc_fnames{mm}(1:end-4)))
        end
        movefile(bc_fnames{mm},fullfile('..','..',bc_fnames{mm}(1:end-4),folders{nn}+".tif"));
    end
    cd ..
end

end
    