function cmdout=run_cellpose(script_name)
    if ~exist('script_name','var')
        script_name='Cellsegmentation-v065.py';
    end

    % is the script provided? If not, using default script
    if ~isfile(script_name)&&~isfile(fullfile('..',script_name)) % if the script is not provided in the current data folder
        if exist(script_name,'file') % but, we can find the script in the matlab path (i.e., a default script)

            fprintf('No custom cellpose script provided. Using default %s for processing.\n', script_name);
            script_name=['"',which(script_name),'"'];

        else
            error([script_name,' does not exist.']);
        end
    else
        warning('%s is provided in the current folder, overriding default %s.\n',script_name,script_name); % if the script is provided in the current folder, then just use that.
    end

%should work for BARseq_envs 
    py_root_n2v = fileparts("C:\BARseq_envs\cellpose\python.exe");
    ENV = getenv('PATH');
    oldpath=ENV;
    ENV = strsplit(ENV, ';');
    items_to_add_to_path = {
        char(fullfile(py_root_n2v, 'Library', 'mingw-w64', 'bin'))
        char(fullfile(py_root_n2v, 'Library', 'usr', 'bin'))
        char(fullfile(py_root_n2v, 'Library', 'bin'))
        char(fullfile(py_root_n2v, 'Scripts'))
        char(py_root_n2v)
        };
    ENV = [items_to_add_to_path(:); ENV(:)];
    ENV = unique(ENV, 'stable');
    ENV = strjoin(ENV, ';');
    
    fprintf('Starting cellpose in python ...')
    cd ..
    setenv('PATH', ENV);
    [status,cmdout]=system(['python ',script_name],'-echo');
    setenv('PATH',oldpath);
    cd processed
    if status==0
        fprintf('Cellpose finished successfully')
    else
        warning('Cellpose has a warning. Please check cmdout.')
    end
end