function filt_neurons=split_slices(filt_neurons,rpc_thresh,gpc_thresh)
if ~exist('rpc_thresh','var')
    rpc_thresh=20;
end
if ~exist('gpc_thresh','var')
    gpc_thresh=5;
end

rpc=full(sum(filt_neurons.expmat,2));
gpc=full(sum(filt_neurons.expmat>0,2));

uniq_slices=unique(filt_neurons.slice);
qc=rpc>=rpc_thresh&gpc>=gpc_thresh;

slicenum_all=cell(numel(uniq_slices),1);
new_slice=nan(size(filt_neurons.slice));
slice_boundaries=cell(numel(uniq_slices),1);
for nn=1:numel(uniq_slices)
    slice_boundaries{nn}={};
    slicenum_all{nn}={};
    in_slice=filt_neurons.slice==uniq_slices(nn);
    h1=figure;
    scatter(filt_neurons.pos(in_slice&qc,1), ...
        filt_neurons.pos(in_slice&qc,2), ...
        20, ...
        rpc(in_slice&qc),...
        'filled');
    set(gca,'ydir','reverse');
    xl=xlim;yl=ylim;

    xlim([xl(1)-1000,xl(2)+1000]);
    ylim([yl(1)-1000,yl(2)+1000]);

    pbaspect([range(xlim),range(ylim),1])
    colorbar;
    title(sprintf(['Old slice number %u\n'...
        'Draw each slice, then press Enter after each slice.\n' ...
        'When finished, press Enter without drawing.\n' ...
        'If only a single slice, press Enter directly'], ...
        uniq_slices(nn)));
    in_any=zeros(size(filt_neurons.slice),'logical');
    hold on;
    while 1 %all slices in the same "slice"
        ptx=[];pty=[];
        while 1 % for a single slice
            [x,y]=ginput(1);
            % if pressed enter directly, then skip
            if isempty(x)&&isempty(ptx)
                break
            elseif isempty(x)&&~isempty(ptx)
                plot(ptx([1 end]),pty([1 end]),...
                    'r-',...
                    'LineWidth',1);
                while 1 % loop for making sure that a good slice number is selected
                    slicenum=uint16(str2double(inputdlg('Enter slice number:')));
                    
                    if ismember(slicenum,unique(new_slice))
                        doublecheck=inputdlg('Warning! the slice number entered was not unique, reselect? (y/n)');
                        if contains(doublecheck,'n')
                            break
                        end
                    else
                        break
                    end

                end


                break;

            else
                %add points
                ptx=[ptx;x];
                pty=[pty;y];
                %draw points
                scatter(x,y,30,'xr');
                if numel(ptx)>1
                    plot(ptx(end-1:end),pty(end-1:end),...
                        'r-',...
                        'LineWidth',1);
                end

            end
        end
        % was there at least one point selected?
        if ~isempty(ptx)
            % which cells are in polygon?
            in = inpolygon(filt_neurons.pos(:,1), ...
                filt_neurons.pos(:,2),...
                ptx, ...
                pty);
            in_any=in_any|in;
            new_slice(in&in_slice)=slicenum;
            slice_boundaries{nn}=[slice_boundaries{nn};{ptx,pty}];
            slicenum_all{nn}=[slicenum_all{nn};slicenum];
        elseif sum(in_any)==0 % if no point selected, and if no slice was selected
            new_slice(in_slice)=filt_neurons.slice(in_slice); % directly copy over old slice number
            slicenum_all{nn}=uniq_slices(nn);
            break
        else % no point selected, and some slice was selected, just end this slice
            break
        end

    end
    close(h1)

end

filt_neurons.orig_slice=filt_neurons.slice;
filt_neurons.slice=new_slice;
filt_neurons.slice_boundaries=slice_boundaries;
filt_neurons.uniq_slice=slicenum_all;


% zero the positions
uniq_slices=unique(filt_neurons.slice);
% only process cells in split slices
uniq_slices(isnan(uniq_slices))=[];
uniq_slices(uniq_slices==0)=[];

for mm=1:numel(uniq_slices)
    in_slice=filt_neurons.slice==uniq_slices(mm);
    filt_neurons.pos(in_slice,:)=filt_neurons.pos(in_slice,:)-min(filt_neurons.pos(in_slice,:),[],1)+1;
end


end


