function stitched2jpg(pos_num,varargin)
% Set default values
resize_factor = 0.2;
cmap = [0 1 1; 1 1 0; 1 0 1; 0 0 1];
bp = 100;
wp = 800;

% Parse varargin
for i = 1:2:length(varargin)
    if i+1 > length(varargin)
        error('Parameter name without corresponding value');
    end
    
    param_name = varargin{i};
    param_value = varargin{i+1};
    
    switch lower(param_name)
        case 'resizefactor'
            resize_factor = param_value;
        case 'colormap'
            cmap = param_value;
        case 'blackpoint'
            bp = param_value;
        case 'whitepoint'
            wp = param_value;
        otherwise
            warning('Unknown parameter: %s', param_name);
    end
end

for nn=1:numel(pos_num)
    im=double(imresize(imread("Pos"+pos_num(nn)+"ch1.tif"),resize_factor));
    for mm=2:4
        im(:,:,mm)=double(imresize(imread("Pos"+pos_num(nn)+"ch"+mm+".tif"),resize_factor));


    end
    im=(im-bp)/(wp-bp);
    imrgb=reshape(reshape(im,[],4)*cmap,size(im,1),size(im,2),3);
    % imrgb=(imrgb-bp)/(wp-bp);
    imrgb=min(imrgb,1);
    imrgb=max(imrgb,0);
    imwrite(imrgb,"Pos"+pos_num(nn)+".jpg")



end