function update_slice_number(filt_neuron_filename,batch_num,slice_num,brain_name)
% update a filt_neurons.mat file by adding batch number and slice number to
% each cell

S=load(filt_neuron_filename);
filt_neurons=S.filt_neurons;

[~,pos]=get_folders();
uniqpos=unique(pos,'stable');

filt_neurons.batch_num=ones(size(filt_neurons.id))*batch_num;
%orig_slice_num=sort(unique(filt_neurons.slice),'ascend');
orig_slice_num=unique(filt_neurons.slice,'stable');% keep original pos sequence
if numel(orig_slice_num)==numel(slice_num)
    %make slice_num vertical
    if size(slice_num,2)>size(slice_num,1)
        slice_num=slice_num';
    end
    slice_num_list=struct;
    slice_num_list.uniqpos=uniqpos;
    slice_num_list.slice_num=slice_num;
    [~,I]=ismember(filt_neurons.slice,orig_slice_num);%get the index in the original set of slice numbers

    filt_neurons.slice=slice_num(I);%index to the new set of slice numbers
else
    slice_num_list=struct;
    slice_num_list.uniqpos=uniqpos;
    slice_num_list.slice_num=orig_slice_num;
    warning('Provided slice_num do not match the number of slices, using default slice_num.\n');
end

filt_neurons=lean_neurons(filt_neurons);
filt_neurons=add_uid(filt_neurons);
if exist('brain_name','var')
    filt_neurons.brain_name=repmat(string(brain_name),numel(filt_neurons.id),1);
end

save('slice_num_list.mat','slice_num_list');
save('filt_neurons.mat','filt_neurons','-v7.3');
end
