%%Plot barcoded cell images and matching axon rolony snapshots to 
%check for fidelity

clc
clearvars
 B = load('alldata20221116-bc.mat');
 bc = B.bc;
F = load('filt_neurons-Feb7.mat');
filt_neurons_proj = F.filt_neurons;
%% 

img_folder = 'F:\YW080_30_33\processed';
analysis_folder=cd(img_folder);
folders=get_folders();

output_folder=fullfile(analysis_folder,'bc_analysis');
mkdir(output_folder);

%% plotting section
% for each starter cell, make crops
% neuron_id=[360822];

is_barcoded = filt_neurons_proj.is_barcoded == 1;
bc_idx = find(is_barcoded);
%neuron_id=[10270421] %%neuron id you want to check

neuron_idx = 404895;

for i=1:numel(neuron_idx)
%     if filit_neurons.batch(inx) ==1
%         analysis_folder = (['....']);
%     else filt... ==2
%             analysis_folder = 
%     end


    %soma folder
    folder_idx=floor(filt_neurons.id(neuron_idx(i))/10000);
   
    hyb_filename='alignedhyb01.tif';
    geneseq1_filename='alignedfixedn2vgeneseq01.tif';
    cellmask_filename='cellmask.mat';

    extract_aligned_img_2(folders{folder_idx},hyb_filename);
    extract_aligned_img_2(folders{folder_idx},geneseq1_filename);
    extract_aligned_img_2(folders{folder_idx},cellmask_filename);
 
    bcseq_filename={};
    for n=1:15
        bcseq_filename{n}=['alignedfixedregn2vbcseq',num2str(n,'%.2u'),'.tif'];
        extract_aligned_img_2(folders{folder_idx},bcseq_filename{n});
    end

    posx=filt_neurons_proj.pos40x(neuron_idx(i),1);
    posy=filt_neurons_proj.pos40x(neuron_idx(i),2);
    sz=100;
 
    for n=1:15
        bcseq_im{n}=make_crop_RGB(fullfile(folders{folder_idx},'aligned',bcseq_filename{n}),posx,posy,sz);
    end
    %geneseq images
    geneseq1_im=make_crop_RGB(fullfile(folders{folder_idx},'aligned',geneseq1_filename),posx,posy,sz);
    %
    %hybrid image
    hyb_im=expand_hyb_RGB(fullfile(folders{folder_idx},'aligned',hyb_filename),posx,posy,sz);
    cellmask_im=make_cellmask_RGB(fullfile(folders{folder_idx},'aligned',cellmask_filename),posx,posy,sz);
    %

    %compile barseq images
    comp_bcseq_img=[];     
    for n=1:numel(bcseq_im)
        comp_bcseq_img=[comp_bcseq_img,ones(sz,3,3),bcseq_im{n}];
    end


    %now plot a subset of axons matching this neuron
    %find a subset of axon ids for that neuron
%     ax = filt_neurons_proj.axonalbc_id{neuron_idx(i)};
%      ax_s = ax(randsample(find(~isnan(ax)),5));
ax_s = [105673,2093362,2097423,104303, 113957, 574224, 586152] ;
    ax_sz=20;
bc_comp_bcseq_img_full = [];
    for j = 1:length(ax_s)
        ax_id = ax_s(j);     
        bcfolder_idx= bc.fov(ax_id);
%         if folder_idx == bcfolder_idx
%             count_over = count_over+1;
%         end
%         
        hyb_filename='alignedhyb01.tif';
        geneseq1_filename='alignedfixedn2vgeneseq01.tif';
        cellmask_filename='cellmask.mat';
    
        extract_aligned_img_2(folders{bcfolder_idx},hyb_filename);
        extract_aligned_img_2(folders{bcfolder_idx},geneseq1_filename);
        extract_aligned_img_2(folders{bcfolder_idx},cellmask_filename);
     
        bcseq_filename={};
        for n=1:15
            bcseq_filename{n}=['alignedfixedregn2vbcseq',num2str(n,'%.2u'),'.tif'];
            extract_aligned_img_2(folders{bcfolder_idx},bcseq_filename{n});
        end
    
        posx=bc.pos40x(ax_id,1);
        posy=bc.pos40x(ax_id,2);
        sz=100;
     
        for n=1:15
            bcseq_im{n}=make_crop_bc_RGB(fullfile(folders{bcfolder_idx},'aligned',bcseq_filename{n}),posx,posy,ax_sz);
            bcseq_im{n} = imresize(bcseq_im{n},5);
        end
        bc_geneseq1_im{j}=make_crop_RGB(fullfile(folders{bcfolder_idx},'aligned',geneseq1_filename),posx,posy,ax_sz);
        bc_geneseq1_im{j} = imresize(bc_geneseq1_im{j},5);
        %
        bc_hyb_im{j}=expand_hyb_RGB(fullfile(folders{bcfolder_idx},'aligned',hyb_filename),posx,posy,ax_sz);
        bc_hyb_im{j} = imresize(bc_hyb_im{j},5);
        
        %instead of cell mask image, make this a dot or cross at the site
        %of the axon I am plotting... 
        bc_cellmask_im{j}=make_bcim_RGB(fullfile(folders{bcfolder_idx},'aligned',cellmask_filename),posx,posy,ax_sz);
        bc_cellmask_im{j} = imresize(bc_cellmask_im{j},5);
        
        bc_comp_bcseq_img{j}=[];     
        for n=1:numel(bcseq_im)
            bc_comp_bcseq_img{j}=[bc_comp_bcseq_img{j},ones(sz,3,3),bcseq_im{n}];
        end
           numel_img = 17;
        im_width = (numel_img*sz)+(3*numel_img);
       bc_comp_bcseq_img{j}=[bc_comp_bcseq_img{j},ones(sz,3,3),bc_geneseq1_im{j},ones(sz,3,3),bc_cellmask_im{j};ones(3,im_width,3)];
       bc_comp_bcseq_img_full=[bc_comp_bcseq_img_full; bc_comp_bcseq_img{j}];
    end

    
   numel_img = 17;
   im_width = (numel_img*sz)+(3*numel_img);
   close all;
        comp_img=([comp_bcseq_img,ones(sz,3,3),geneseq1_im,ones(sz,3,3),cellmask_im;ones(3,im_width,3);...
            bc_comp_bcseq_img_full]);
       
        F=figure;
        imshow(comp_img);
        %title(['Axons IDs: ',num2str(ax_s(1)),', ',num2str(ax_s(2)),', ',num2str(ax_s(3)),', ',num2str(ax_s(4)), ', ',num2str(ax_s(5))]);
        frame = getframe(F);
        full_image = frame2im(frame);
        img_file=append(output_folder,'\',['Neuron',num2str(filt_neurons_proj.id(neuron_idx(i))),'.jpg']);
        imwrite(full_image,img_file);

end

%% Functions

function extract_aligned_img_2(folder,filename)
warning('off', 'MATLAB:MKDIR:DirectoryExists');

zip_name=fullfile(folder,'aligned.zip');
file_name=fullfile(folder,'aligned',filename);
output_file_name=file_name;

if ~exist(output_file_name,'file')
    mkdir(fullfile(folder,'aligned'));
    unzip_file(zip_name,file_name,output_file_name)
end
warning('on', 'MATLAB:MKDIR:DirectoryExists');

end

function crop_im=make_crop_RGB(seqfilename,posx,posy,sz)
max_perct=99.9;

%generate RGB crops of cells for sequencing images
im=double(imread(seqfilename));
for n=2:4
    im(:,:,n)=double(imread(seqfilename,n));
end
%pad image in case it's at the edgedom_bc
im=padarray(im,[sz,sz],'both');%dom_bc
posx=posx+sz;
posy=posy+sz;

cmap=[0 1 1;
    1 1 0;
    1 0 1;
    0 0 1];

im_rgb=reshape(reshape(im,[],4)*double(cmap),size(im,1),size(im,2),[]);

crop_im=im_rgb(round(posy-sz/2):round(posy-sz/2)+sz-1,round(posx-sz/2):round(posx-sz/2)+sz-1,:);
max_thresh=sort(crop_im(:),'ascend');
max_thresh=max_thresh(round(numel(crop_im)*max_perct/100));
crop_im=min(crop_im/max_thresh,1);
end

function crop_im=make_crop_bc_RGB(seqfilename,posx,posy,sz)
max_perct=99.9;

%generate RGB crops of cells for sequencing images
im=double(imread(seqfilename));
for n=2:4
    im(:,:,n)=double(imread(seqfilename,n));
end
%pad image in case it's at the edgedom_bc
im=padarray(im,[sz,sz],'both');%dom_bc
posx=posx+sz;
posy=posy+sz;

cmap=[0 1 1;
    1 1 0;
    1 0 1;
    0 0 1];

im_rgb=reshape(reshape(im,[],4)*double(cmap),size(im,1),size(im,2),[]);

crop_im=im_rgb(round(posy-sz/2):round(posy-sz/2)+sz-1,round(posx-sz/2):round(posx-sz/2)+sz-1,:);
 max_thresh=sort(crop_im(:),'ascend');
 max_thresh=max_thresh(round(numel(crop_im)*max_perct/100));
 crop_im=min(crop_im/(0.5*max_thresh),1);
end

function hyb_im=expand_hyb_RGB(seqfilename,posx,posy,sz)
max_perct=99.8;
im=double(imread(seqfilename));
im(:,:,2)=double(imread(seqfilename,2));
im(:,:,3)=double(imread(seqfilename,4));
im(:,:,4)=double(imread(seqfilename,5));
%pad image in case it's at the edge
im=padarray(im,[sz,sz],'both');
posx=posx+sz;
posy=posy+sz;

crop_im=im(round(posy-sz/2):round(posy-sz/2)+sz-1,round(posx-sz/2):round(posx-sz/2)+sz-1,:);
for i=1:size(crop_im,3)
    max_thresh=sort(reshape(crop_im(:,:,i),[],1),'ascend');
    max_thresh=max_thresh(round(numel(crop_im(:,:,i))*max_perct/100));
    crop_im(:,:,i)=min(crop_im(:,:,i)/max_thresh,1);
end

cmap=[0 1 1;
    1 1 0;
    1 0 1;
    0 0 1];

hyb_im=repmat([crop_im(:,:,1),ones(sz,3),crop_im(:,:,2),ones(sz,3),crop_im(:,:,3),ones(sz,3),crop_im(:,:,4)],1,1,3);

end

function cellmask_im=make_cellmask_RGB(seqfilename,posx,posy,sz)
S=load(seqfilename);
im=S.maski;
im=padarray(im,[sz,sz],'both');
posx=posx+sz;
posy=posy+sz;

crop_im=im(round(posy-sz/2):round(posy-sz/2)+sz-1,round(posx-sz/2):round(posx-sz/2)+sz-1,:);
cellmask_im=double(label2rgb(crop_im,'jet','k','shuffle'))/255;

end

function bc_loc_im = make_bcim_RGB(seqfilename,posx,posy,sz)
S = load(seqfilename);
im=S.maski;
% im(posx-2:posx+2,posy-2:posy+2,:) = 1;
posx=posx+sz;
posy=posy+sz;

try crop_im=im(round(posy-sz/2):round(posy-sz/2)+sz-1,round(posx-sz/2):round(posx-sz/2)+sz-1,:);
catch
    crop_im = zeros(100,100);
end
bc_loc_im=double(label2rgb(crop_im,'jet','k','shuffle'))/255;
end













