%bar plots, Fraction of positive cells by (1) area, (2) H3 type

clc
clearvars

load('filt_neurons.mat')

%genes to plot
gene_code = [18, 107:130];

%set this cutoff for if you count a cell as "positive" for the gene
cutoff = 1;

%%

output_dir=fullfile('figs','H3_bar_plots');
mkdir(output_dir)

H3_types = unique(filt_neurons.clustname);

%for each type, find pct cells positive for the gene

for g = 1:numel(gene_code)

    pos_for_gene_counts = filt_neurons.expmat(:,gene_code(g))>= cutoff;
    has_gene = full(pos_for_gene_counts);


    for h=1:numel(H3_types)
        in_H3 = ismember(filt_neurons.clustname,H3_types(h));
        total_H3 = sum(in_H3);
        pos_in_H3 = sum(in_H3 & has_gene);
        total_positive = sum(pos_in_H3);
        pct_pos(h) = (pos_in_H3/total_H3)*100;
    end

    figure('Position',[1600 10 1400 400]); hold on;
    hold on;
    bar(pct_pos,'FaceColor',[0.3 .5 .5],'LineWidth',0.25);
    title(filt_neurons.genes(gene_code(g)))
    prettyFig_thin();
    ylabel('% H3 type + for gene')
    set(gca,'xtick',1:numel(H3_types));
    set(gca, 'TickLabelInterpreter', 'none');
    set(gca,'xticklabels',H3_types)
    xAX = get(gca,'XAxis');
    set(xAX,'FontSize', 8)

    exportgraphics(gcf,fullfile(output_dir,[filt_neurons.genes{gene_code(g)} '.pdf']),'ContentType','Image','Resolution',300);
    close all;
end

%% 
output_dir=fullfile('figs','H2_bar_plots');
mkdir(output_dir)

H2_types = unique(filt_neurons.subclass);

%for each type, find pct cells positive for the gene

for g = 1:numel(gene_code)

    pos_for_gene_counts = filt_neurons.expmat(:,gene_code(g))>= cutoff;
    has_gene = full(pos_for_gene_counts);


    for h=1:numel(H2_types)
        in_H2 = ismember(filt_neurons.clustname,H2_types(h));
        total_H2 = sum(in_H2);
        pos_in_H2 = sum(in_H2 & has_gene);
        total_positive = sum(pos_in_H2);
        pct_pos(h) = (pos_in_H2/total_H2)*100;
    end

    figure('Position',[1600 10 1400 400]); hold on;
    hold on;
    bar(pct_pos,'FaceColor',[0.3 .5 .5],'LineWidth',0.25);
    title(filt_neurons.genes(gene_code(g)))
    prettyFig_thin();
    ylabel('% H2 type + for gene')
    set(gca,'xtick',1:numel(H2_types));
    set(gca, 'TickLabelInterpreter', 'none');
    set(gca,'xticklabels',H2_types)
    xAX = get(gca,'XAxis');
    set(xAX,'FontSize', 8)

    exportgraphics(gcf,fullfile(output_dir,[filt_neurons.genes{gene_code(g)} '.pdf']),'ContentType','Image','Resolution',300);
    close all;
end

