function cleanup_filt_neurons(fname)

%% clean up and make filt_neurons files smaller and easier to use

F = load(fname);
filt_neurons = F.filt_neurons;

fields = fieldnames(filt_neurons);

%remove depth field
if any(strcmp(fields,'depth'))
    filt_neurons = rmfield(filt_neurons,'depth');
end

%remove angle field
if any(strcmp(fields,'angle'))
    filt_neurons = rmfield(filt_neurons,'angle');
end

%remove dom_bc if soma_bc fields exist
if any(strcmp(fields,'soma_bc')) 
    if  any(strcmp(fields,'dom_bc')) 
        filt_neurons = rmfield(filt_neurons,'dom_bc');
    end
    if  any(strcmp(fields,'dom_bc_count')) 
        filt_neurons = rmfield(filt_neurons,'dom_bc_count');
    end
    if  any(strcmp(fields,'all_bc')) 
        filt_neurons = rmfield(filt_neurons,'all_bc');
    end
    if  any(strcmp(fields,'all_bc_count')) 
        filt_neurons = rmfield(filt_neurons,'all_bc_count');
    end
    if  any(strcmp(fields,'repeat_bc')) 
        filt_neurons = rmfield(filt_neurons,'repeat_bc');
    end
end

% remove redundant clustid
if any(strcmp(fields,'clustid')) 
    filt_neurons = rmfield(filt_neurons,'clustid');
end

% if ~any(strcmp(fields,'subclass')) 
%     subclass_code = unique(filt_neurons.subclass);
% end

 save(fname,'filt_neurons','-v7.3');