%%Plot barcoded cell images and matching axon rolony snapshots (not in soma fov) to 
%check for fidelity
function images_bccell_and_rolonies(bc,filt_neurons,neuron_idx,img_folder,output_folder,ax_id)

%% 
analysis_folder=cd(img_folder);
folders=get_folders();
mkdir(output_folder);

%if no rolonies are specified, plot all axonal rolonies
if nargin == 5
    ax_id = cell2mat(filt_neurons.axonalbc_id(neuron_idx));
end

ax_slice = cell2mat(filt_neurons.axonalbc_slice(neuron_idx));

soma_slice = filt_neurons.slice(neuron_idx);

%don't plot rolonies in the soma slice
for i = 1:length(ax_id)
    if soma_slice ~= ax_slice(i)
        ax_id_nosoma(i) = ax_id(i);
    end
end

ax_id = nonzeros(ax_id_nosoma);
%% plotting section
%soma folder

    folder_idx=floor(filt_neurons.id(neuron_idx)/10000);
   
    hyb_filename='alignedhyb01.tif';
    geneseq1_filename='alignedfixedn2vgeneseq01.tif';
    cellmask_filename='cellmask.mat';

    extract_aligned_img_2(folders{folder_idx},hyb_filename);
    extract_aligned_img_2(folders{folder_idx},geneseq1_filename);
    extract_aligned_img_2(folders{folder_idx},cellmask_filename);
 
    bcseq_filename={};
    for n=1:15
        bcseq_filename{n}=['alignedfixedregn2vbcseq',num2str(n,'%.2u'),'.tif'];
        extract_aligned_img_2(folders{folder_idx},bcseq_filename{n});
    end

    posx=filt_neurons.pos40x(neuron_idx,1);
    posy=filt_neurons.pos40x(neuron_idx,2);
    sz=100;
 
    for n=1:15
        bcseq_im{n}=make_crop_RGB(fullfile(folders{folder_idx},'aligned',bcseq_filename{n}),posx,posy,sz);
    end
    %geneseq images
    geneseq1_im=make_crop_RGB(fullfile(folders{folder_idx},'aligned',geneseq1_filename),posx,posy,sz);
    %
    %hybrid image
    hyb_im=expand_hyb_RGB(fullfile(folders{folder_idx},'aligned',hyb_filename),posx,posy,sz);
    cellmask_im=make_cellmask_RGB(fullfile(folders{folder_idx},'aligned',cellmask_filename),posx,posy,sz);
    %

    %compile barseq images
    comp_bcseq_img=[];     
    for n=1:numel(bcseq_im)
        comp_bcseq_img=[comp_bcseq_img,ones(sz,3,3),bcseq_im{n}];
    end


    %now plot a subset of axons matching this neuron
    ax_sz=20;
    bc_comp_bcseq_img_full = [];

    for j = 1:length(ax_id)
        this_ax_id = ax_id(j);     
        bcfolder_idx= bc.fov(this_ax_id);
    
        hyb_filename='alignedhyb01.tif';
        geneseq1_filename='alignedfixedn2vgeneseq01.tif';
        cellmask_filename='cellmask.mat';
    
        extract_aligned_img_2(folders{bcfolder_idx},hyb_filename);
        extract_aligned_img_2(folders{bcfolder_idx},geneseq1_filename);
        extract_aligned_img_2(folders{bcfolder_idx},cellmask_filename);
     
        bcseq_filename={};
        for n=1:15
            bcseq_filename{n}=['alignedfixedregn2vbcseq',num2str(n,'%.2u'),'.tif'];
            extract_aligned_img_2(folders{bcfolder_idx},bcseq_filename{n});
        end
    
        posx=bc.pos40x(this_ax_id,1);
        posy=bc.pos40x(this_ax_id,2);
        sz=100;
     
        for n=1:15
            bcseq_im{n}=make_crop_bc_RGB(fullfile(folders{bcfolder_idx},'aligned',bcseq_filename{n}),posx,posy,ax_sz);
            bcseq_im{n} = imresize(bcseq_im{n},5);
        end
        bc_geneseq1_im{j}=make_crop_RGB(fullfile(folders{bcfolder_idx},'aligned',geneseq1_filename),posx,posy,ax_sz);
        bc_geneseq1_im{j} = imresize(bc_geneseq1_im{j},5);
        %
        bc_hyb_im{j}=expand_hyb_RGB(fullfile(folders{bcfolder_idx},'aligned',hyb_filename),posx,posy,ax_sz);
        bc_hyb_im{j} = imresize(bc_hyb_im{j},5);
        
        %instead of cell mask image, make this a dot or cross at the site
        %of the axon I am plotting... 
        bc_cellmask_im{j}=make_bcim_RGB(fullfile(folders{bcfolder_idx},'aligned',cellmask_filename),posx,posy,ax_sz);
        bc_cellmask_im{j} = imresize(bc_cellmask_im{j},5);
        
        bc_comp_bcseq_img{j}=[];     
        for n=1:numel(bcseq_im)
            bc_comp_bcseq_img{j}=[bc_comp_bcseq_img{j},ones(sz,3,3),bcseq_im{n}];
        end
           numel_img = 17;
        im_width = (numel_img*sz)+(3*numel_img);
       bc_comp_bcseq_img{j}=[bc_comp_bcseq_img{j},ones(sz,3,3),bc_geneseq1_im{j},ones(sz,3,3),bc_cellmask_im{j};ones(3,im_width,3)];
       bc_comp_bcseq_img_full=[bc_comp_bcseq_img_full; bc_comp_bcseq_img{j}];
    end

    
   numel_img = 17;
   im_width = (numel_img*sz)+(3*numel_img);
   close all;
        comp_img=([comp_bcseq_img,ones(sz,3,3),geneseq1_im,ones(sz,3,3),cellmask_im;ones(3,im_width,3);...
            bc_comp_bcseq_img_full]);
       
        F=figure;
        imshow(comp_img);

        frame = getframe(F);
        full_image = frame2im(frame);
        img_file=append(output_folder,'\',['Neuron',num2str(filt_neurons.id(neuron_idx)),'.jpg']);
        imwrite(full_image,img_file);

end

%% Functions

function extract_aligned_img_2(folder,filename)
warning('off', 'MATLAB:MKDIR:DirectoryExists');

zip_name=fullfile(folder,'aligned.zip');
file_name=fullfile(folder,'aligned',filename);
output_file_name=file_name;

if ~exist(output_file_name,'file')
    mkdir(fullfile(folder,'aligned'));
    unzip_file(zip_name,file_name,output_file_name)
end
warning('on', 'MATLAB:MKDIR:DirectoryExists');

end

function crop_im=make_crop_RGB(seqfilename,posx,posy,sz)
max_perct=99.9;

%generate RGB crops of cells for sequencing images
im=double(imread(seqfilename));
for n=2:4
    im(:,:,n)=double(imread(seqfilename,n));
end
%pad image in case it's at the edgedom_bc
im=padarray(im,[sz,sz],'both');%dom_bc
posx=posx+sz;
posy=posy+sz;

cmap=[0 1 1;
    1 1 0;
    1 0 1;
    0 0 1];

im_rgb=reshape(reshape(im,[],4)*double(cmap),size(im,1),size(im,2),[]);

crop_im=im_rgb(round(posy-sz/2):round(posy-sz/2)+sz-1,round(posx-sz/2):round(posx-sz/2)+sz-1,:);
max_thresh=sort(crop_im(:),'ascend');
max_thresh=max_thresh(round(numel(crop_im)*max_perct/100));
crop_im=min(crop_im/max_thresh,1);
end

function crop_im=make_crop_bc_RGB(seqfilename,posx,posy,sz)
max_perct=99.9;

%generate RGB crops of cells for sequencing images
im=double(imread(seqfilename));
for n=2:4
    im(:,:,n)=double(imread(seqfilename,n));
end
%pad image in case it's at the edgedom_bc
im=padarray(im,[sz,sz],'both');%dom_bc
posx=posx+sz;
posy=posy+sz;

cmap=[0 1 1;
    1 1 0;
    1 0 1;
    0 0 1];

im_rgb=reshape(reshape(im,[],4)*double(cmap),size(im,1),size(im,2),[]);

crop_im=im_rgb(round(posy-sz/2):round(posy-sz/2)+sz-1,round(posx-sz/2):round(posx-sz/2)+sz-1,:);
 max_thresh=sort(crop_im(:),'ascend');
 max_thresh=max_thresh(round(numel(crop_im)*max_perct/100));
 crop_im=min(crop_im/(0.5*max_thresh),1);
end

function hyb_im=expand_hyb_RGB(seqfilename,posx,posy,sz)
max_perct=99.8;
im=double(imread(seqfilename));
im(:,:,2)=double(imread(seqfilename,2));
im(:,:,3)=double(imread(seqfilename,4));
im(:,:,4)=double(imread(seqfilename,5));
%pad image in case it's at the edge
im=padarray(im,[sz,sz],'both');
posx=posx+sz;
posy=posy+sz;

crop_im=im(round(posy-sz/2):round(posy-sz/2)+sz-1,round(posx-sz/2):round(posx-sz/2)+sz-1,:);
for i=1:size(crop_im,3)
    max_thresh=sort(reshape(crop_im(:,:,i),[],1),'ascend');
    max_thresh=max_thresh(round(numel(crop_im(:,:,i))*max_perct/100));
    crop_im(:,:,i)=min(crop_im(:,:,i)/max_thresh,1);
end

cmap=[0 1 1;
    1 1 0;
    1 0 1;
    0 0 1];

hyb_im=repmat([crop_im(:,:,1),ones(sz,3),crop_im(:,:,2),ones(sz,3),crop_im(:,:,3),ones(sz,3),crop_im(:,:,4)],1,1,3);

end

function cellmask_im=make_cellmask_RGB(seqfilename,posx,posy,sz)
S=load(seqfilename);
im=S.maski;
im=padarray(im,[sz,sz],'both');
posx=posx+sz;
posy=posy+sz;

crop_im=im(round(posy-sz/2):round(posy-sz/2)+sz-1,round(posx-sz/2):round(posx-sz/2)+sz-1,:);
cellmask_im=double(label2rgb(crop_im,'jet','k','shuffle'))/255;

end

function bc_loc_im = make_bcim_RGB(seqfilename,posx,posy,sz)
S = load(seqfilename);
im=S.maski;
% im(posx-2:posx+2,posy-2:posy+2,:) = 1;
posx=posx+sz;
posy=posy+sz;

try crop_im=im(round(posy-sz/2):round(posy-sz/2)+sz-1,round(posx-sz/2):round(posx-sz/2)+sz-1,:);
catch
    crop_im = zeros(100,100);
end
bc_loc_im=double(label2rgb(crop_im,'jet','k','shuffle'))/255;
end













