%linear regression code
%x and y must not have NaN and be the same length

function [R,p,Rsq] = linear_regression(x,y)

%plot figure
figure;
plot(x,y, 'bo');

%calculate correlation coefficients
[R,p] = corrcoef(x,y);
C = cov(x,y);
Rsq = R(1,2)^2;


if p(1,2) < 0.05 %if significant, plot regression line
    m = R(1,2)*sqrt(C(2,2)/C(1,1));
    b = mean(y) - m*mean(x);
    X = [min(x) - 1, max(x) + 1];
    Y = m * X + b;
    hold on
    plot(X,Y,'k');
    
end