function plot_bc_neuron_CCF(filt_neurons,idx,output_dir)
%% takes inputs: filt_neurons, indexes of all neurons you want to plot, and
% output directory to store the plots. 
%plots individual barcoded neuron and all associated axons
%run this only on CCF registered experiments, will plot all projecitons on
%a 2D coronal setcion CCF projection. Modify if you want in 3D


%% Plot each neuron cell body (circle) and all axonal bc matching that soma

 for i=1:length(idx)
    figure('Position',[1800 200 600 600]);

    hold on;

    scatter(filt_neurons.posCCF(:,3), ...
    filt_neurons.posCCF(:,2), ...
    1, ...
    [0.8,0.8,0.8],...
    'filled' ...
    );
    xl=xlim;
    yl=ylim;
    set(gca, ...
        'ydir','reverse' ...
        );
    axis off
    pbaspect([range(xl),range(yl),1]);

    soma_slice = filt_neurons.slice(idx(i));
        ax_CCF = cell2mat(filt_neurons.axonalbc_posCCF(idx(i)));
        ax_slice = cell2mat(filt_neurons.axonalbc_slice(idx(i)));
        not_near_soma = ax_slice~= soma_slice &...
            ax_slice~= (soma_slice-1) &...
            ax_slice~= (soma_slice+1)& ax_slice~=17;

        %plot all the axonal points
        scatter(ax_CCF(not_near_soma,3), ...
        ax_CCF(not_near_soma,2), ...
        5, ...
        [0.5,0,1],...
        'filled', ...
        'MarkerFaceAlpha',0.9,...
        'MarkerEdgeAlpha',0.9 ...
        );

        %plot cell body, cross
        scatter(filt_neurons.posCCF(idx(i),3), ...
        filt_neurons.posCCF(idx(i),2), ...
        5, ...
        [0,0,0],...
        '*' ...
        );
    
    sgtitle(['Neuron ', num2str(filt_neurons.id(idx(i)))])
    title(['Read counts= ', num2str(sum(filt_neurons.expmat(idx(i),:))),' Subtype= ',filt_neurons.subclass(idx(i))],'Interpreter','none')
     exportgraphics(gcf,fullfile(output_dir,['Neuron_', num2str(filt_neurons.id(idx(i))), '_CCF_projs_1','.pdf']),'ContentType','Image','Resolution',300);
     close all;
end












