function plot_bc_neuron_indslices(filt_neurons,idx,output_dir)
%this funciton will plot all slices and a barcoded neuron with associated 
%axonal rolonies
%takes as input filt_neurons with cell positions and axonal positions,
%indexes of all neurons you want to plot and an output directory. 


%% Plot each neuron cell body (circle) and all axonal bc matching that soma
slices = unique(filt_neurons.slice);
x_subplot = 4;
y_subplot = ceil(length(slices)/4);

for i=1:length(idx)

    figure('Position',[1800 0 800 800]);
    hold on;
    soma_slice = filt_neurons.slice(idx(i));
    axonal_pos = filt_neurons.axonalbc_pos{idx(i)};
    axonal_slice = filt_neurons.axonalbc_slice{idx(i)};
    
    %remove axonal projections on soma slice
    try
    ax_soma_slice = axonal_slice ~= [1+soma_slice,soma_slice,soma_slice-1];
    ax_soma_slice = prod(ax_soma_slice,2);
    catch
        ax_soma_slice = axonal_slice ~= soma_slice;
    end

for s=1:length(slices)
    plot_slice = slices(s);

    subplot(x_subplot,y_subplot,s);
    hold on;

    in_slice = filt_neurons.slice == slices(s);
    scatter(filt_neurons.pos(in_slice,1), ...
    filt_neurons.pos(in_slice,2), ...
    2, ...
    [0.8,0.8,0.8],...
    'filled' ...
    );
    xl=xlim;
    yl=ylim;
    set(gca, ...
        'ydir','reverse' ...
        );
    axis off
    pbaspect([range(xl),range(yl),1]);


    in_slice_ax=axonal_slice==slices(s);
    
    if soma_slice~=slices(s)
    %plot all axonal points
    scatter(axonal_pos(in_slice_ax,1), ...
    axonal_pos(in_slice_ax,2), ...
    8, ...
    [1,0,0],...
    'filled' ...
    );
     end

    %plot cell body location
    if soma_slice==slices(s)
        scatter(filt_neurons.pos(idx(i),1), ...
        filt_neurons.pos(idx(i),2), ...
        50, ...
        [1,0,0],...
        'o', 'linewidth',2,'MarkerEdgeColor','flat'...,
        );
    end
end

    sgtitle(['Neuron ', num2str(filt_neurons.id(idx(i))),'Read counts= ', num2str(sum(filt_neurons.expmat(idx(i),:))),' Subtype= ',filt_neurons.subclass(idx(i))],'Interpreter','none')
     exportgraphics(gcf,fullfile(output_dir,['Neuron_', num2str(filt_neurons.id(idx(i))), '_CCF_projs','.pdf']),'ContentType','Image','Resolution',300);
     close all;

end


end








