%% check stuff, look at one cell type on one slice

function plot_single_gene(filt_neurons,plot_slice,plot_gene,cmap)
    slices = unique(filt_neurons.slice);
    % example inputs
    % plot_slice = 37;
    %plot_slice = [68,	59,	53,	46,	38,	31,	23,	16];
    % plot_type = 'L6_CT';
    % plot_class = 'subclass';
    %plot_color = [0, 0, 0.3];

    %plot_single_type(filt_neurons,plot_slice,'TH_ML','subclass',[0,0,0.3])

    if isfield(filt_neurons,'CCF')
        pos_type = 'CCF';
        x_coor = 3;
        y_coor = 2;
        my_ydir = 'reverse';
    else
        pos_type = 'pos';
        x_coor = 1;
        y_coor = 2;
        my_ydir = 'reverse';
    end
    
    n_gene = find(ismember(filt_neurons.genes(:,1),plot_gene));

    counts = sum(filt_neurons.expmat(:,n_gene),2);

    if numel(plot_slice) == 1
        in_slice = filt_neurons.slice == plot_slice;
        
        figure;
        hold on;
        
         %all cells grey
        scatter(filt_neurons.(pos_type)(in_slice,x_coor), ...
        filt_neurons.(pos_type)(in_slice,y_coor), ...
        2, ...
        [0.8,0.8,0.8],...
        'filled' ...
        );
        
        %cells positive for gene
        scatter(filt_neurons.(pos_type)(in_slice & counts>0,x_coor), ...
        filt_neurons.(pos_type)(in_slice & counts>0,y_coor), ...
        2, ...
        counts(in_slice & counts>0),...
        'filled' ...
        );
        colormap(cmap);

        xl=xlim;
        yl=ylim;
        axis off
        set(gca,'ydir',my_ydir)
        pbaspect([range(xl),range(yl),1]);
        sgtitle(plot_gene,'Interpreter','None')

        %colorlimit
        mean_counts = round(mean(counts(in_slice&counts>0)));

        clim([0 mean_counts + 1]);
        colorbar

    else %plotting more than 1 slice
        slices = plot_slice;
        figure; hold on;
        for s=1:numel(slices)
            in_slice = filt_neurons.slice == slices(s);

            if numel(slices)<=4
                subtightplot(1,numel(slices),s); hold on;
            elseif numel(slices)<=8
                subtightplot(2,ceil(numel(slices)/2),s); hold on;
            elseif numel(slices)<=12
                subtightplot(3,ceil(numel(slices)/3),s); hold on;
            else
                subtightplot(4,ceil(numel(slices)/4),s); hold on;
            end

         %all cells grey
        scatter(filt_neurons.(pos_type)(in_slice&counts>0,x_coor), ...
        filt_neurons.(pos_type)(in_slice&counts>0,y_coor), ...
        2, ...
        [0.8,0.8,0.8],...
        'filled' ...
        );
        
        %cells positive for gene
        scatter(filt_neurons.(pos_type)(in_slice & counts>1,x_coor), ...
        filt_neurons.(pos_type)(in_slice & counts>1,y_coor), ...
        2, ...
        counts(in_slice & counts>1),...
        'filled' ...
        );
        colormap(cmap);

        
        xl=xlim;
        yl=ylim;
        axis off
        set(gca,'ydir',my_ydir)
        pbaspect([range(xl),range(yl),1]);
        mean_counts = round(mean(counts(in_slice&counts>0)));

        clim([0 mean_counts + 1]);
        colorbar
        end
        sgtitle(plot_gene,'Interpreter','None')
                %colorlimit

    end

end