%% check stuff, look at one cell type on one slice

function plot_single_type(filt_neurons,plot_slice,plot_type,plot_class,plot_color)
    slices = unique(filt_neurons.slice);
    % example inputs
    % plot_slice = 37;
    %plot_slice = [68,	59,	53,	46,	38,	31,	23,	16];
    % plot_type = 'L6_CT';
    % plot_class = 'subclass';
    %plot_color = [0, 0, 0.3];

    %plot_single_type(filt_neurons,plot_slice,'TH_ML','subclass',[0,0,0.3])

    if isfield(filt_neurons,'CCF')
        pos_type = 'CCF';
        x_coor = 3;
        y_coor = 2;
        my_ydir = 'reverse';
    else
        pos_type = 'pos';
        x_coor = 1;
        y_coor = 2;
        my_ydir = 'normal';
    end


    in_type = ismember(filt_neurons.(plot_class),plot_type);

    if numel(plot_slice) == 1
        in_slice = filt_neurons.slice == plot_slice;
        
        figure;
        hold on;
        
         %all cells grey
        scatter(filt_neurons.(pos_type)(in_slice,x_coor), ...
        filt_neurons.(pos_type)(in_slice,y_coor), ...
        2, ...
        [0.8,0.8,0.8],...
        'filled' ...
        );
        
        %cells in type
        scatter(filt_neurons.(pos_type)(in_slice & in_type,x_coor), ...
        filt_neurons.(pos_type)(in_slice & in_type,y_coor), ...
        2, ...
        plot_color,...
        'filled' ...
        );
        
        xl=xlim;
        yl=ylim;
        axis off
        set(gca,'ydir',my_ydir)
        pbaspect([range(xl),range(yl),1]);
        sgtitle(plot_type,'Interpreter','None')

    else %plotting more than 1 slice
        slices = plot_slice;
        figure; hold on;
        for s=1:numel(slices)
            in_slice = filt_neurons.slice == slices(s);

            if numel(slices)<=4
                subtightplot(1,numel(slices),s); hold on;
            elseif numel(slices)<=8
                subtightplot(2,ceil(numel(slices)/2),s); hold on;
            elseif numel(slices)<=12
                subtightplot(3,ceil(numel(slices)/3),s); hold on;
            else
                subtightplot(4,ceil(numel(slices)/4),s); hold on;
            end

         %all cells grey
        scatter(filt_neurons.(pos_type)(in_slice,x_coor), ...
        filt_neurons.(pos_type)(in_slice,y_coor), ...
        2, ...
        [0.8,0.8,0.8],...
        'filled' ...
        );
        
        %cells in type
        scatter(filt_neurons.(pos_type)(in_slice & in_type,x_coor), ...
        filt_neurons.(pos_type)(in_slice & in_type,y_coor), ...
        2, ...
        plot_color,...
        'filled' ...
        );
        
        xl=xlim;
        yl=ylim;
        axis off
        set(gca,'ydir',my_ydir)
        pbaspect([range(xl),range(yl),1]);

        end
        sgtitle(plot_type,'Interpreter','None')
    end

end