
function bc_comb=combine_allbc(varargin)
% combine multiple filt_neurons. add a new field uid, which is a unique
% cell id in the format of batch_num-slice-id

% must have the same number of fields as the first dataset. Additional
% fields are lost.


% check if the input is many bc, or a cell of many bc
if isscalar(varargin)&& iscell(varargin{1})
    bc=varargin{1};
else
    bc=varargin;
end

% check if any bc is missing uid. If they are, add bcid and uid first.
for n=1:numel(bc)
    if ~isfield(bc{n},'uid')
        bc{n}=add_uid(bc{n});
    end
end



bc_comb=bc{1};

% for all fields that are not rows = neurons, put them in cells and combine them across datasets. 
fnames=fieldnames(bc_comb);
cellnum=numel(bc_comb.slice);
is_cell_based=zeros(numel(fnames),1,'logical');

for n=1:numel(fnames)
    s=size(bc_comb.(fnames{n}),1);
    if s==cellnum
        is_cell_based(n)=1;
    else
        bc_comb.(fnames{n})={bc_comb.(fnames{n})};
    end
end

% go through all the rest of bc, concat based on whether it's cell based.
for m=2:numel(bc)
    for n=1:numel(fnames)
        if is_cell_based(n)
            bc_comb.(fnames{n})=[bc_comb.(fnames{n});bc{m}.(fnames{n})];
        else
            bc_comb.(fnames{n})=[bc_comb.(fnames{n});{bc{m}.(fnames{n})}];
        end
    end
end
end