
function bc_comb=combine_bc_multibatch(bc1,bc2)
% this version correctly handles fov and fov_names, so the correct raw data
% folder can be traced back from the combined filt_neurons.
% added check for batch_num first. batch_num must exist and must be
% different across the two
% this version does not handle different barcode lengths. This should be dealt with outside of this function on a case by case basis.




bc_comb=struct;

fnames1=fieldnames(bc1);
fnames2=fieldnames(bc2);
I=ismember(fnames1,fnames2);
fnames=fnames1(I);% only combine fields that are shared between datasets.
cellnum=numel(bc1.uid);

%%
if ~isfield(bc1,'batch_num')||~isfield(bc2,'batch_num')
    error('Batch_num does not exist in one of the filt_neurons. batch_num must exist and be unique in the two datasets.')
end

if ismember(unique(bc1.batch_num),unique(bc2.batch_num))
    error('The same batch_nums were found in both filt_neurons. batch_num must be unique in the two datasets.')
end




for n=1:numel(fnames)
    v=bc1.(fnames{n});
    s=size(v,1);
    if s==cellnum % for every other field with uid number of rows, just combine them
        bc_comb.(fnames{n})=[bc1.(fnames{n});bc2.(fnames{n})];
    else % if not gene, combine them in a cell array. 
        % first check if either is already combined. In a combined dataset,
        % numel should equal unique batch_num
        
        is_combined1=isstruct(bc1.(fnames{n}))&&isfield(bc1.(fnames{n}),'batch_num');
        is_combined2=isstruct(bc2.(fnames{n}))&&isfield(bc2.(fnames{n}),'batch_num');
        
        if ~is_combined1&&numel(unique(bc1.batch_num))>1
            error('The first dataset appears to contain a single dataset, but contain multiple batch_num.');
        elseif ~is_combined2&&numel(unique(bc2.batch_num))>1
            error('The second dataset appears to contain a single dataset, but contain multiple batch_num.');
        end

        if is_combined1
            value1=bc1.(fnames{n});
        else
            value1=struct;
            value1.batch_num=unique(bc1.batch_num);
            value1.value={bc1.(fnames{n})};% if not combined, switch to a struct and add batch_num
        end

        if is_combined2
            value2=bc2.(fnames{n});
        else
            value2=struct;
            value2.batch_num=unique(bc2.batch_num);
            value2.value={bc2.(fnames{n})};% if not combined, switch to a struct and add batch_num
        end

        bc_comb.(fnames{n})=struct;% combine cell arrays
        bc_comb.(fnames{n}).batch_num=[value1.batch_num;value2.batch_num];
        bc_comb.(fnames{n}).value=[value1.value;value2.value];
        
    end
end
%check if neuron ids are unique. If not, throw a warning, but continue
if max(ismember(bc1.uid,bc2.uid))>0
    warning('Some bcs are repeated in the two. Values from the second dataset will be replaced if in conflict.\n');
    cellid=unique(bc_comb.uid);
    bc_comb=subset_neurons(bc_comb,cellid);
end


end