
function filt_neurons_comb=combine_neurons_multibatch(filt_neurons1,filt_neurons2)
% this version correctly handles fov and fov_names, so the correct raw data
% folder can be traced back from the combined filt_neurons.
% added check for batch_num first. batch_num must exist and must be
% different across the two
%given a list of cellid, subset filt_neurons

filt_neurons_comb=struct;

fnames1=fieldnames(filt_neurons1);
fnames2=fieldnames(filt_neurons2);
I=ismember(fnames1,fnames2);
fnames=fnames1(I);% only combine fields that are shared between datasets.
cellnum=numel(filt_neurons1.uid);

%%
if ~isfield(filt_neurons1,'batch_num')||~isfield(filt_neurons2,'batch_num')
    error('Batch_num does not exist in one of the filt_neurons. batch_num must exist and be unique in the two datasets.')
end

if ismember(unique(filt_neurons1.batch_num),unique(filt_neurons2.batch_num))
    error('The same batch_nums were found in both filt_neurons. batch_num must be unique in the two datasets.')
end
% handle genes first, because this is required for expmat
[~,genes_I1,genes_I2]=intersect(filt_neurons1.genes(:,1),filt_neurons2.genes(:,1),'stable');
genelist=filt_neurons1.genes(genes_I1,:);


for n=1:numel(fnames)
    v=filt_neurons1.(fnames{n});
    s=size(v,1);
    if ismember(fnames{n},'expmat') % if expmat, keep only the shared genes
        filt_neurons_comb.expmat=[filt_neurons1.expmat(:,genes_I1);filt_neurons2.expmat(:,genes_I2)];
    elseif s==cellnum % for every other field with uid number of rows, just combine them
        filt_neurons_comb.(fnames{n})=[filt_neurons1.(fnames{n});filt_neurons2.(fnames{n})];
    elseif ismember(fnames{n},'genes') % if genes, use the shared genes
        % [~,genes_I1,genes_I2]=intersect(filt_neurons1.genes,filt_neurons2.genes,'stable');
        % filt_neurons_comb.genes=filt_neurons1.genes(genes_I1);
        filt_neurons_comb.genes=genelist;
        
        % filt_neurons_comb.(fnames{n})=filt_neurons1.(fnames{n});

    else % if not gene, combine them in a cell array. 
        % first check if either is already combined. In a combined dataset,
        % numel should equal unique batch_num
        
        is_combined1=isstruct(filt_neurons1.(fnames{n}))&&isfield(filt_neurons1.(fnames{n}),'batch_num');
        is_combined2=isstruct(filt_neurons2.(fnames{n}))&&isfield(filt_neurons2.(fnames{n}),'batch_num');
        
        if ~is_combined1&&numel(unique(filt_neurons1.batch_num))>1
            error('The first dataset appears to contain a single dataset, but contain multiple batch_num.');
        elseif ~is_combined2&&numel(unique(filt_neurons2.batch_num))>1
            error('The second dataset appears to contain a single dataset, but contain multiple batch_num.');
        end

        if is_combined1
            value1=filt_neurons1.(fnames{n});
        else
            value1=struct;
            value1.batch_num=unique(filt_neurons1.batch_num);
            value1.value={filt_neurons1.(fnames{n})};% if not combined, switch to a struct and add batch_num
        end

        if is_combined2
            value2=filt_neurons2.(fnames{n});
        else
            value2=struct;
            value2.batch_num=unique(filt_neurons2.batch_num);
            value2.value={filt_neurons2.(fnames{n})};% if not combined, switch to a struct and add batch_num
        end

        filt_neurons_comb.(fnames{n})=struct;% combine cell arrays
        filt_neurons_comb.(fnames{n}).batch_num=[value1.batch_num;value2.batch_num];
        filt_neurons_comb.(fnames{n}).value=[value1.value;value2.value];
        
    end
end
%check if neuron ids are unique. If not, throw a warning, but continue
if max(ismember(filt_neurons1.uid,filt_neurons2.uid))>0
    warning('Some neurons are repeated in the two. Values from the second dataset will be replaced if in conflict.\n');
    cellid=unique(filt_neurons_comb.uid);
    filt_neurons_comb=subset_neurons(filt_neurons_comb,cellid);
end


end