
function filt_neurons1=lean_neurons(filt_neurons)
% lean bc with the proper variable type
filt_neurons1=filt_neurons;
filt_neurons1.id=uint32(filt_neurons1.id);
filt_neurons1.pos=single(filt_neurons1.pos);
filt_neurons1.slice=uint16(filt_neurons1.slice);
filt_neurons1.pos40x=single(filt_neurons1.pos40x);
filt_neurons1.fov=uint16(filt_neurons1.fov);
filt_neurons1.batch_num=uint16(filt_neurons1.batch_num);

try
    filt_neurons1.depth=single(filt_neurons1.depth);
fil t_neurons1.angle=single(filt_neurons1.angle);
catch
    fprintf('No Depth/angle');
end


try
    
    filt_neurons1.soma_bc=uint8(filt_neurons1.soma_bc);
    filt_neurons1.soma_bc_sig=single(filt_neurons1.soma_bc_sig);
    filt_neurons1.soma_bc_score=single(filt_neurons1.soma_bc_score);
    filt_neurons1.soma_bc_hd=uint8(filt_neurons1.soma_bc_hd);
    filt_neurons1.soma_bc_sig_hd=single(filt_neurons1.soma_bc_sig_hd);
    filt_neurons1.soma_bc_score_hd=single(filt_neurons1.soma_bc_score_hd);
catch
    fprintf('No soma barcode data available, skipping soma_bc fields.\n');
end
try
    filt_neurons1.dom_bc=cellfun(@(x) uint8(x),filt_neurons1.dom_bc, ...
        'UniformOutput',false);
    filt_neurons1.dom_bc_count=uint16(filt_neurons1.dom_bc_count);
    filt_neurons1.all_bc=cellfun(@(x) uint8(x),filt_neurons1.all_bc, ...
        'UniformOutput',false);
filt_neurons1.all_bc_count=cellfun(@(x) uint16(x),filt_neurons1.all_bc_count, ...
        'UniformOutput',false);
catch
    fprintf('No barcode data available, skipping dom_bc all_bc fields.\n');
end



end