
function filt_neurons_subset=subset_neurons(filt_neurons,cellid)
% new version allows subsetting by either uid or id. Automatically detect
% based on whether cellid is string or numeric

%given a list of cellid, subset filt_neurons
filt_neurons_subset=filt_neurons;
if isnumeric(cellid) % then this is a id
    [~,idx]=ismember(cellid,filt_neurons.id);
elseif isstring(cellid) % this is a uid
    [~,idx]=ismember(cellid,filt_neurons.uid);
end
if sum(idx==0)>0
    error('Some cellids are not found in filt_neuron. Are they the same dataset?\n')
end



fnames=fieldnames(filt_neurons);
cellnum=numel(filt_neurons.id);
for n=1:numel(fnames)
    v=filt_neurons.(fnames{n});
    s=size(v);
    if s(1)==cellnum
        s_new=s;
        s_new(1)=numel(idx);
        filt_neurons_subset.(fnames{n})=reshape(v(idx,:),s_new);
    end
end


end
