
load filt_neurons-bc-clust-CCF.mat  %% neurons dataset 
%%
img_folder='F:\20220916__HTNA_YW143_32_YW144_18\processed';  %%processed image folder
cd(img_folder)
folders=get_folders();

analysis_folder='F:\';%% where you want to store your image


output_folder='F:\cropped_image';%%make a new folder where you want to store your cropped images
mkdir(output_folder);

%%

% for each starter cell, make crops
neuron_idx=cell2mat(this_neuron);
%neuron_id=[10270421] %%neuron id you want to check

% [~,neuron_idx]=ismember(neuron_id,filt_neurons.id);


%%
%
for i=1:numel(neuron_idx)
    folder_idx=floor(filt_neurons.id(neuron_idx(i))/10000);

    hyb_filename='alignedhyb01.tif';
    geneseq1_filename='alignedfixedn2vgeneseq01.tif';
    cellmask_filename='cellmask.mat';

    extract_aligned_img(folders{folder_idx},hyb_filename);
    extract_aligned_img(folders{folder_idx},geneseq1_filename);
    extract_aligned_img(folders{folder_idx},cellmask_filename);
    
    bcseq_filename={};
    for n=1:15
        bcseq_filename{n}=['alignedfixedregn2vbcseq',num2str(n,'%.2u'),'.tif'];
        extract_aligned_img(folders{folder_idx},bcseq_filename{n});
    end
    %get a crop of three channels of hyb, then RGB of seuqencing images.


    posx=filt_neurons.pos40x(neuron_idx(i),1);
    posy=filt_neurons.pos40x(neuron_idx(i),2);
    sz=100;
    
    bcseq_im={};
    for n=1:15
        bcseq_im{n}=make_crop_RGB(fullfile(folders{folder_idx},'aligned',bcseq_filename{n}),posx,posy,sz);
    end
    geneseq1_im=make_crop_RGB(fullfile(folders{folder_idx},'aligned',geneseq1_filename),posx,posy,sz);
    %
    hyb_im=expand_hyb_RGB(fullfile(folders{folder_idx},'aligned',hyb_filename),posx,posy,sz);
    cellmask_im=make_cellmask_RGB(fullfile(folders{folder_idx},'aligned',cellmask_filename),posx,posy,sz);
    %
    comp_bcseq_img=[];
    for n=1:numel(bcseq_im)
        comp_bcseq_img=[comp_bcseq_img,ones(sz,3,3),bcseq_im{n}];
    end
    comp_img=([comp_bcseq_img,ones(sz,3,3),geneseq1_im,ones(sz,3,3),hyb_im,ones(sz,3,3),cellmask_im]);
    img_file=append(output_folder,'\',['index',num2str(neuron_idx(i)),'.jpg']);
    imwrite(comp_img,img_file);
end


%% %funtions
function crop_im=make_crop_RGB(seqfilename,posx,posy,sz)
max_perct=99.9;

%generate RGB crops of cells for sequencing images
im=double(imread(seqfilename));
for n=2:4
    im(:,:,n)=double(imread(seqfilename,n));
end
%pad image in case it's at the edgedom_bc
im=padarray(im,[sz,sz],'both');%dom_bc
posx=posx+sz;
posy=posy+sz;

cmap=[0 1 1;
    1 1 0;
    1 0 1;
    0 0 1];

im_rgb=reshape(reshape(im,[],4)*double(cmap),size(im,1),size(im,2),[]);

crop_im=im_rgb(round(posy-sz/2):round(posy-sz/2)+sz-1,round(posx-sz/2):round(posx-sz/2)+sz-1,:);
max_thresh=sort(crop_im(:),'ascend');
max_thresh=max_thresh(round(numel(crop_im)*max_perct/100));
crop_im=min(crop_im/max_thresh,1);
end

function hyb_im=expand_hyb_RGB(seqfilename,posx,posy,sz)
max_perct=99.8;
im=double(imread(seqfilename));
im(:,:,2)=double(imread(seqfilename,2));
im(:,:,3)=double(imread(seqfilename,4));
im(:,:,4)=double(imread(seqfilename,5));
%pad image in case it's at the edge
im=padarray(im,[sz,sz],'both');
posx=posx+sz;
posy=posy+sz;

crop_im=im(round(posy-sz/2):round(posy-sz/2)+sz-1,round(posx-sz/2):round(posx-sz/2)+sz-1,:);
for i=1:size(crop_im,3)
    max_thresh=sort(reshape(crop_im(:,:,i),[],1),'ascend');
    max_thresh=max_thresh(round(numel(crop_im(:,:,i))*max_perct/100));
    crop_im(:,:,i)=min(crop_im(:,:,i)/max_thresh,1);
end

cmap=[0 1 1;
    1 1 0;
    1 0 1;
    0 0 1];

hyb_im=repmat([crop_im(:,:,1),ones(sz,3),crop_im(:,:,2),ones(sz,3),crop_im(:,:,3),ones(sz,3),crop_im(:,:,4)],1,1,3);

end

function cellmask_im=make_cellmask_RGB(seqfilename,posx,posy,sz)
S=load(seqfilename);
im=S.maski;
im=padarray(im,[sz,sz],'both');
posx=posx+sz;
posy=posy+sz;

crop_im=im(round(posy-sz/2):round(posy-sz/2)+sz-1,round(posx-sz/2):round(posx-sz/2)+sz-1,:);
cellmask_im=double(label2rgb(crop_im,'jet','k','shuffle'))/255;

end

function [folders,pos,xxx,yyy]=get_folders()
    %get all folder names and corresponding slice names
    folders=dir('MAX*');
    folders=sort_nat({folders.name});
    pos={};
    xxx=[];
    yyy=[];
    for n=1:numel(folders)
        i1=regexp(folders{n},'_');
        pos{n}=folders{n}(i1(1)+1:i1(2)-1);
        xxx(n)=str2double(folders{n}(i1(2)+1:i1(3)-1));
        yyy(n)=str2double(folders{n}(i1(3)+1:end));
    end
    xxx=xxx+1; %xxx and yyy +1
    yyy=yyy+1; %xxx and yyy +1
    
end

function extract_aligned_img(folder,filename)
warning('off', 'MATLAB:MKDIR:DirectoryExists');

zip_name=fullfile(folder,'aligned.zip');
file_name=fullfile(folder,'aligned',filename);
output_file_name=file_name;

if ~exist(output_file_name,'file')
    mkdir(fullfile(folder,'aligned'));
    unzip_file(zip_name,file_name,output_file_name)
end
warning('on', 'MATLAB:MKDIR:DirectoryExists');

end



function unzip_file(zip_name,file_name,output_file_name)
%windows file paths doesn't work in java, switch to '/'

file_name(file_name=='\')='/';
zip_name(zip_name=='\')='/';
output_file_name(output_file_name=='\')='/';

zipFilename = zip_name;
zipJavaFile  = java.io.File(zipFilename);
zipFile = org.apache.tools.zip.ZipFile(zipJavaFile);
% entries = zipFile.getEntries; % to get all entries then iterate
entry = zipFile.getEntry(file_name); % empty if not found
if(~isempty(entry))
    inputstream = zipFile.getInputStream(entry);
    outJavaFile = java.io.File(output_file_name);
    outStream = java.io.FileOutputStream(outJavaFile);
    copier = com.mathworks.mlwidgets.io.InterruptibleStreamCopier.getInterruptibleStreamCopier;
    copier.copyStream(inputstream, outStream);
    outStream.close();
end
zipFile.close();
end
