function crop_im=make_crop_RGB(seqfilename,posx,posy,sz)
max_perct=99.9;

%generate RGB crops of cells for sequencing images
im=double(imread(seqfilename));
for n=2:4
    im(:,:,n)=double(imread(seqfilename,n));
end
%pad image in case it's at the edge
im=padarray(im,[sz,sz],'both');
posx=posx+sz;
posy=posy+sz;

cmap=[0 1 1;
    1 1 0;
    1 0 1;
    0 0 1];

im_rgb=reshape(reshape(im,[],4)*double(cmap),size(im,1),size(im,2),[]);

crop_im=im_rgb(round(posy-sz/2):round(posy-sz/2)+sz-1,round(posx-sz/2):round(posx-sz/2)+sz-1,:);
max_thresh=sort(crop_im(:),'ascend');
max_thresh=max_thresh(round(numel(crop_im)*max_perct/100));
crop_im=min(crop_im/max_thresh,1);
end